/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.util.ScriptUploaderDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.model.ScriptActivityParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class UploadScriptAction
extends TreeViewerAction {
    private static final String NAME = "Upload Script...";
    private static final String DESCRIPTION = "Upload a script to the server.";

    public UploadScriptAction(TreeViewer model) {
        super(model);
        this.setEnabled(true);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(128));
    }

    public void actionPerformed(ActionEvent e) {
        ScriptUploaderDialog dialog = new ScriptUploaderDialog(this.model.getUI(), this.model.getScriptsAsString());
        dialog.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ScriptObject script = (ScriptObject)evt.getNewValue();
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                if (script == null) {
                    un.notifyInfo("Upload Script", "No script to upload");
                    return;
                }
                ScriptActivityParam p = new ScriptActivityParam(script, 1);
                un.notifyActivity(p);
            }
        });
        UIUtilities.centerAndShow(dialog);
    }
}

