/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserManageAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.util.TreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.PartialNameVisitor;
import org.openmicroscopy.shoola.agents.util.browser.SmartFolder;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.FileData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.MultiImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserUI
extends JPanel {
    private static final String LOADING_MSG = "Loading...";
    private static final String EMPTY_MSG = "Empty";
    private static final int[] VALUES = new int[]{0, 1, 2, 3};
    private JTree treeDisplay;
    private JToolBar rightMenuBar;
    private JToolBar leftMenuBar;
    private BrowserControl controller;
    private BrowserModel model;
    private ViewerSorter sorter = new ViewerSorter();
    private TreeExpansionListener listener;
    private TreeSelectionListener selectionListener;
    private Set<TreeImageDisplay> nodesToReset = new HashSet<TreeImageDisplay>();
    private JToggleButton partialButton;
    private boolean ctrl;
    private boolean leftMouseButton;
    private JComponent bottomComponent;

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.setBorder(null);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.setBorder(null);
        p.add(this.leftMenuBar);
        p.setPreferredSize(this.leftMenuBar.getPreferredSize());
        bar.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout(2, 0, 0));
        p.setBorder(null);
        p.add(this.rightMenuBar);
        p.setPreferredSize(this.rightMenuBar.getPreferredSize());
        bar.add(p);
        return bar;
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.buildToolBar(), "North");
        JScrollPane pane = new JScrollPane();
        pane.getViewport().add(this.treeDisplay);
        this.add((Component)pane, "Center");
    }

    private void createMenuBars() {
        JButton button;
        this.rightMenuBar = new JToolBar();
        this.rightMenuBar.setBorder(null);
        this.rightMenuBar.setRollover(true);
        this.rightMenuBar.setFloatable(false);
        this.leftMenuBar = new JToolBar();
        this.leftMenuBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.leftMenuBar.setRollover(true);
        this.leftMenuBar.setFloatable(false);
        int type = this.model.getBrowserType();
        switch (type) {
            case 100: 
            case 103: {
                BrowserManageAction a = (BrowserManageAction)this.controller.getAction(BrowserControl.NEW_CONTAINER);
                button = new JButton(a);
                button.setBorderPainted(false);
                button.addMouseListener(a);
                this.rightMenuBar.add(button);
                break;
            }
            case 107: {
                BrowserManageAction a = (BrowserManageAction)this.controller.getAction(BrowserControl.NEW_ADMIN);
                button = new JButton(a);
                button.setBorderPainted(false);
                button.addMouseListener(a);
                this.rightMenuBar.add(button);
                break;
            }
            case 102: {
                BrowserManageAction a = (BrowserManageAction)this.controller.getAction(BrowserControl.NEW_TAG);
                button = new JButton(a);
                button.setBorderPainted(false);
                button.addMouseListener(a);
                this.rightMenuBar.add(button);
            }
        }
        button = new JButton(this.controller.getAction(BrowserControl.DELETE));
        button.setBorderPainted(false);
        this.rightMenuBar.add(button);
        button = new JButton(this.controller.getAction(BrowserControl.REFRESH));
        button.setBorderPainted(false);
        this.rightMenuBar.add(button);
        if (type == 107) {
            button = new JButton(this.controller.getAction(BrowserControl.RESET_PASSWORD));
            button.setBorderPainted(false);
            this.rightMenuBar.add(button);
        } else {
            button = new JButton(this.controller.getAction(BrowserControl.IMPORT));
            button.setBorderPainted(false);
            this.rightMenuBar.add(button);
        }
        this.rightMenuBar.add(Box.createHorizontalStrut(6));
        if (type == 105) {
            button = new JButton(this.controller.getAction(BrowserControl.INFO));
            button.setBorderPainted(false);
            this.rightMenuBar.add(button);
        }
        this.rightMenuBar.add(new JSeparator());
        this.rightMenuBar.add(Box.createHorizontalStrut(6));
        ButtonGroup group = new ButtonGroup();
        JToggleButton b = new JToggleButton();
        group.add(b);
        b.setBorderPainted(true);
        b.setSelected(true);
        b.setAction(this.controller.getAction(BrowserControl.SORT));
        this.rightMenuBar.add(b);
        b = new JToggleButton(this.controller.getAction(BrowserControl.SORT_DATE));
        b.setBorderPainted(true);
        group.add(b);
        this.rightMenuBar.add(b);
        this.partialButton = new JToggleButton(this.controller.getAction(BrowserControl.PARTIAL_NAME));
        this.partialButton.setBorderPainted(true);
        this.rightMenuBar.add(this.partialButton);
        this.rightMenuBar.add(new JSeparator(1));
        button = new JButton(this.controller.getAction(BrowserControl.COLLAPSE));
        button.setBorderPainted(false);
        this.rightMenuBar.add(button);
    }

    private void onNodeNavigation(TreeExpansionEvent tee, boolean expanded) {
        TreeImageDisplay node = (TreeImageDisplay)tee.getPath().getLastPathComponent();
        node.setExpanded(expanded);
        this.controller.onNodeNavigation(node, expanded);
    }

    private void onClick(MouseEvent me, boolean released) {
        Point p = me.getPoint();
        int row = this.treeDisplay.getRowForLocation(p.x, p.y);
        if (row != -1) {
            if (me.getClickCount() == 1) {
                this.model.setClickPoint(p);
                if (me.isPopupTrigger() && !released || me.isPopupTrigger() && released && !UIUtilities.isMacOS() || UIUtilities.isMacOS() && SwingUtilities.isLeftMouseButton(me) && me.isControlDown()) {
                    if (this.model.getBrowserType() == 107) {
                        this.controller.showPopupMenu(7);
                    } else {
                        this.controller.showPopupMenu(1);
                    }
                }
            } else if (me.getClickCount() == 2 && released && !me.isMetaDown() && !me.isControlDown() && !me.isShiftDown()) {
                TreeImageDisplay d = this.model.getLastSelectedDisplay();
                if (d == null) {
                    return;
                }
                Object o = d.getUserObject();
                if (o instanceof ImageData) {
                    this.model.browser(d);
                } else if (o instanceof FileAnnotationData) {
                    this.model.openFile(d);
                } else if (o instanceof PlateData) {
                    if (!d.hasChildrenDisplay()) {
                        this.model.browser(d);
                    }
                } else if (o instanceof PlateAcquisitionData) {
                    this.model.browser(d);
                }
            }
        }
    }

    private void rollOver(MouseEvent e) {
        if (!this.model.getParentModel().isRollOver()) {
            return;
        }
        JTree tree = this.treeDisplay;
        TreePath path = this.treeDisplay.getClosestPathForLocation(e.getX(), e.getY());
        Rectangle bounds = tree.getPathBounds(path);
        if (!bounds.contains(e.getPoint())) {
            return;
        }
        TreeImageDisplay node = (TreeImageDisplay)path.getLastPathComponent();
        Object uo = node.getUserObject();
        if (!(uo instanceof DataObject)) {
            return;
        }
    }

    private TreeImageSet createExperimenterNode(ExperimenterData exp) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageSet node = new TreeImageSet(exp);
        switch (this.model.getBrowserType()) {
            case 101: {
                this.createTimeElements(node);
                break;
            }
            case 104: {
                this.createFileElements(node);
                break;
            }
            case 102: {
                this.createTagsElements(node);
                break;
            }
            default: {
                this.buildEmptyNode(node);
            }
        }
        TreeImageDisplay root = this.getTreeRoot();
        root.addChildDisplay(node);
        tm.insertNodeInto(node, root, root.getChildCount());
        return node;
    }

    private void createTimeElements(TreeImageSet parent) {
        int i;
        this.createTimeNode(99, parent, true);
        this.createTimeNode(100, parent, true);
        this.createTimeNode(101, parent, true);
        TreeImageTimeSet n = this.createTimeNode(103, parent, false);
        int month = TreeImageTimeSet.getCurrentMonth() + 1;
        for (i = 0; i < month; ++i) {
            this.createTimeNode(103, i, n);
        }
        n.setNumberItems(-1L);
        n = this.createTimeNode(104, parent, false);
        for (i = 0; i < 12; ++i) {
            this.createTimeNode(104, i, n);
        }
        n.setNumberItems(-1L);
        this.createTimeNode(102, parent, true);
    }

    private void createFileElements(TreeImageSet parent) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        for (int i = 0; i < VALUES.length; ++i) {
            TreeFileSet node = new TreeFileSet(VALUES[i]);
            this.buildEmptyNode(node);
            node.setNumberItems(-1L);
            parent.addChildDisplay(node);
            tm.insertNodeInto(node, parent, parent.getChildCount());
        }
    }

    private void createTagsElements(TreeImageDisplay parent) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeFileSet node = new TreeFileSet(4);
        this.buildEmptyNode(node);
        node.setNumberItems(-1L);
        parent.addChildDisplay(node);
        tm.insertNodeInto(node, parent, parent.getChildCount());
    }

    private TreeImageTimeSet createTimeNode(int index, TreeImageSet parent, boolean empty) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageTimeSet date = new TreeImageTimeSet(index);
        if (empty) {
            this.buildEmptyNode(date);
        }
        parent.addChildDisplay(date);
        tm.insertNodeInto(date, parent, parent.getChildCount());
        return date;
    }

    private TreeImageTimeSet createTimeNode(int index, int month, TreeImageSet parent) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageTimeSet date = new TreeImageTimeSet(index, month);
        this.buildEmptyNode(date);
        parent.addChildDisplay(date);
        tm.insertNodeInto(date, parent, parent.getChildCount());
        parent.setChildrenLoaded(true);
        return date;
    }

    private List<TreeImageNode> transformDirectory(TreeImageSet dirSet) {
        ArrayList<TreeImageNode> leaves = new ArrayList<TreeImageNode>();
        FileData dir = (FileData)dirSet.getUserObject();
        TreeImageDisplay expNode = BrowserFactory.getDataOwner(dirSet);
        if (expNode == null) {
            return leaves;
        }
        Object ho = expNode.getUserObject();
        if (!(ho instanceof ExperimenterData)) {
            return leaves;
        }
        long expID = ((ExperimenterData)ho).getId();
        DataObject[] files = this.model.getFilesData(expID, dir);
        if (files != null && files.length > 0) {
            DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
            for (int i = 0; i < files.length; ++i) {
                DataObject object = files[i];
                TreeImageDisplay display = null;
                if (object instanceof MultiImageData) {
                    display = TreeViewerTranslator.transformMultiImage((MultiImageData)object);
                    if (display != null) {
                        this.buildTreeNode(display, this.prepareSortedList(this.sorter.sort(display.getChildrenDisplay())), dtm);
                    }
                } else if (object instanceof FileData) {
                    FileData file = (FileData)object;
                    if (file.isDirectory()) {
                        if (!file.isHidden()) {
                            display = new TreeImageSet(file);
                            this.buildEmptyNode(display);
                        }
                    } else if (!file.isHidden()) {
                        display = new TreeImageNode(file);
                    }
                } else if (object instanceof ImageData) {
                    display = TreeViewerTranslator.transformImage((ImageData)object);
                }
                if (display == null) continue;
                dirSet.addChildDisplay(display);
            }
        }
        return leaves;
    }

    private Set<TreeImageDisplay> createFileSystemExplorer(TreeImageDisplay expNode) {
        HashSet<TreeImageDisplay> results = new HashSet<TreeImageDisplay>();
        ExperimenterData exp = (ExperimenterData)expNode.getUserObject();
        FSFileSystemView fs = this.model.getRepositories(exp.getId());
        if (fs == null) {
            return results;
        }
        FileData[] files = fs.getRoots();
        for (int j = 0; j < files.length; ++j) {
            FileData file = files[j];
            if (!file.isDirectory() || file.isHidden()) continue;
            TreeImageSet display = new TreeImageSet(file);
            expNode.addChildDisplay(display);
            this.buildEmptyNode(display);
            results.add(display);
        }
        return results;
    }

    private void createTrees(ExperimenterData exp) {
        this.treeDisplay = new JTree();
        this.treeDisplay.setVisible(true);
        this.treeDisplay.setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.treeDisplay);
        this.treeDisplay.setCellRenderer(new TreeCellRenderer());
        this.treeDisplay.setShowsRootHandles(true);
        this.treeDisplay.getSelectionModel().setSelectionMode(4);
        TreeImageSet root = new TreeImageSet("");
        this.treeDisplay.setModel(new DefaultTreeModel(root));
        TreeImageSet node = this.createExperimenterNode(exp);
        this.treeDisplay.collapsePath(new TreePath(node.getPath()));
        this.treeDisplay.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                BrowserUI.this.ctrl = e.isControlDown();
                if (UIUtilities.isMacOS()) {
                    BrowserUI.this.ctrl = e.isMetaDown();
                }
                BrowserUI.this.leftMouseButton = SwingUtilities.isLeftMouseButton(e);
                BrowserUI.this.onClick(e, false);
            }

            public void mouseReleased(MouseEvent e) {
                BrowserUI.this.leftMouseButton = SwingUtilities.isLeftMouseButton(e);
                BrowserUI.this.onClick(e, true);
            }
        });
        this.treeDisplay.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                BrowserUI.this.rollOver(e);
            }
        });
        this.treeDisplay.addTreeExpansionListener(this.listener);
        this.selectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (BrowserUI.this.ctrl && BrowserUI.this.leftMouseButton) {
                    int i;
                    TreePath[] paths = BrowserUI.this.treeDisplay.getSelectionPaths();
                    ArrayList<TreePath> added = new ArrayList<TreePath>();
                    TreePath[] all = null;
                    if (paths != null) {
                        all = new TreePath[paths.length];
                        for (i = 0; i < paths.length; ++i) {
                            all[i] = new TreePath(paths[i].getPath());
                        }
                    }
                    BrowserUI.this.treeDisplay.removeTreeSelectionListener(BrowserUI.this.selectionListener);
                    if (all != null) {
                        BrowserUI.this.treeDisplay.setSelectionPaths(all);
                    }
                    BrowserUI.this.treeDisplay.addTreeSelectionListener(BrowserUI.this.selectionListener);
                    if (all != null) {
                        for (i = 0; i < all.length; ++i) {
                            added.add(all[i]);
                        }
                    }
                    BrowserUI.this.controller.onClick(added);
                    return;
                }
                TreePath[] paths = e.getPaths();
                ArrayList<TreePath> added = new ArrayList<TreePath>();
                for (int i = 0; i < paths.length; ++i) {
                    if (!e.isAddedPath(paths[i])) continue;
                    added.add(paths[i]);
                }
                BrowserUI.this.controller.onClick(added);
            }
        };
        this.treeDisplay.addTreeSelectionListener(this.selectionListener);
        this.treeDisplay.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                BrowserUI.this.ctrl = false;
                block0 : switch (e.getKeyCode()) {
                    case 10: {
                        ViewCmd cmd = new ViewCmd(BrowserUI.this.model.getParentModel(), true);
                        cmd.execute();
                        break;
                    }
                    case 127: {
                        switch (BrowserUI.this.model.getState()) {
                            case 11: 
                            case 12: {
                                break block0;
                            }
                        }
                        BrowserUI.this.model.delete();
                        break;
                    }
                    case 17: {
                        if (UIUtilities.isMacOS()) break;
                        BrowserUI.this.ctrl = true;
                        break;
                    }
                    case 157: {
                        if (!UIUtilities.isMacOS()) break;
                        BrowserUI.this.ctrl = true;
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                BrowserUI.this.ctrl = false;
            }
        });
    }

    private void buildTreeNode(TreeImageDisplay parent, Collection nodes, DefaultTreeModel tm) {
        if (nodes.size() == 0) {
            tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), parent, parent.getChildCount());
            return;
        }
        Iterator i = nodes.iterator();
        parent.removeAllChildren();
        int browserType = this.model.getBrowserType();
        while (i.hasNext()) {
            TreeImageDisplay display = (TreeImageDisplay)i.next();
            tm.insertNodeInto(display, parent, parent.getChildCount());
            if (!(display instanceof TreeImageSet)) continue;
            List children = display.getChildrenDisplay();
            if (children.size() != 0) {
                if (display.containsImages()) {
                    display.setExpanded(true);
                    this.setExpandedParent(display, false);
                    this.nodesToReset.add(display);
                    this.buildTreeNode(display, this.prepareSortedList(this.sorter.sort(children)), tm);
                    this.expandNode(display);
                    tm.reload(display);
                    continue;
                }
                if (display.isExpanded()) {
                    this.setExpandedParent(display, true);
                    this.nodesToReset.add(display);
                }
                this.buildTreeNode(display, this.prepareSortedList(this.sorter.sort(children)), tm);
                continue;
            }
            Object uo = display.getUserObject();
            if (uo instanceof DatasetData) {
                tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), display, display.getChildCount());
                continue;
            }
            if (uo instanceof TagAnnotationData) {
                TagAnnotationData tag = (TagAnnotationData)uo;
                if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) continue;
                tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), display, display.getChildCount());
                continue;
            }
            if (uo instanceof GroupData) {
                tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), display, display.getChildCount());
                continue;
            }
            if (!(uo instanceof FileAnnotationData) || browserType != 103) continue;
            TreeImageSet n = new TreeImageSet(uo);
            tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), n, n.getChildCount());
        }
        if (parent.isExpanded()) {
            this.expandNode(parent);
            tm.reload(parent);
        }
    }

    private void setExpandedParent(TreeImageDisplay n, boolean b) {
        TreeImageDisplay p = n.getParentDisplay();
        if (p != null) {
            p.setExpanded(b);
            this.setExpandedParent(p, b);
        }
    }

    private void buildEmptyNode(DefaultMutableTreeNode node) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), node, node.getChildCount());
    }

    private void sortNode(TreeImageTimeSet node) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        List children = node.getChildrenDisplay();
        if (node.containsImages()) {
            node.removeAllChildren();
            dtm.reload(node);
            if (children.size() != 0) {
                this.buildTreeNode(node, this.sorter.sort(children), dtm);
            } else {
                this.buildEmptyNode(node);
            }
            Iterator<TreeImageDisplay> j = this.nodesToReset.iterator();
            while (j.hasNext()) {
                this.setExpandedParent(j.next(), true);
            }
        } else if (children.size() != 0) {
            Iterator j = children.iterator();
            while (j.hasNext()) {
                this.sortNode((TreeImageTimeSet)j.next());
            }
        } else {
            this.buildEmptyNode(node);
        }
    }

    private void refreshFolderNode(TreeImageSet node, Set elements) {
        node.removeAllChildren();
        node.removeAllChildrenDisplay();
        for (TreeImageDisplay child : elements) {
            node.addChildDisplay(child);
        }
        this.buildTreeNode(node, this.sorter.sort(elements), (DefaultTreeModel)this.treeDisplay.getModel());
        node.setExpanded(true);
        this.expandNode(node);
    }

    private List prepareSortedList(List sorted) {
        ArrayList<TreeImageDisplay> top = new ArrayList<TreeImageDisplay>();
        ArrayList<TreeImageDisplay> bottom = new ArrayList<TreeImageDisplay>();
        ArrayList<TreeImageDisplay> top2 = new ArrayList<TreeImageDisplay>();
        ArrayList<TreeImageDisplay> bottom2 = new ArrayList<TreeImageDisplay>();
        for (TreeImageDisplay object : sorted) {
            File f;
            Object uo = object.getUserObject();
            if (uo instanceof ProjectData) {
                top.add(object);
                continue;
            }
            if (uo instanceof GroupData) {
                top.add(object);
                continue;
            }
            if (uo instanceof ScreenData) {
                top2.add(object);
                continue;
            }
            if (uo instanceof DatasetData) {
                bottom.add(object);
                continue;
            }
            if (uo instanceof PlateData) {
                bottom2.add(object);
                continue;
            }
            if (uo instanceof PlateAcquisitionData) {
                bottom2.add(object);
                continue;
            }
            if (uo instanceof TagAnnotationData) {
                if ("openmicroscopy.org/omero/insight/tagset".equals(((TagAnnotationData)uo).getNameSpace())) {
                    top.add(object);
                    continue;
                }
                bottom.add(object);
                continue;
            }
            if (uo instanceof File) {
                f = (File)uo;
                if (f.isDirectory()) {
                    if (((TreeImageSet)object).isSystem()) {
                        top.add(object);
                        continue;
                    }
                    bottom.add(object);
                    continue;
                }
                top.add(object);
                continue;
            }
            if (uo instanceof FileData) {
                f = (FileData)uo;
                if (f.isDirectory()) {
                    top.add(object);
                    continue;
                }
                bottom.add(object);
                continue;
            }
            if (uo instanceof ImageData) {
                bottom.add(object);
                continue;
            }
            if (uo instanceof MultiImageData) {
                bottom.add(object);
                continue;
            }
            if (uo instanceof ExperimenterData) {
                bottom.add(object);
                continue;
            }
            if (!(object instanceof SmartFolder)) continue;
            bottom.add(object);
        }
        ArrayList<TreeImageDisplay> all = new ArrayList<TreeImageDisplay>();
        if (top.size() > 0) {
            all.addAll(top);
        }
        if (bottom.size() > 0) {
            all.addAll(bottom);
        }
        if (top2.size() > 0) {
            all.addAll(top2);
        }
        if (bottom2.size() > 0) {
            all.addAll(bottom2);
        }
        return all;
    }

    private void refreshFileFolder(TreeImageDisplay expNode, Map<Integer, Set> r) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        expNode.setChildrenLoaded(Boolean.TRUE);
        expNode.setExpanded(true);
        if (r == null || r.size() == 0) {
            return;
        }
        Iterator<Integer> i = r.keySet().iterator();
        int n = expNode.getChildCount();
        dtm.reload();
        while (i.hasNext()) {
            int index = i.next();
            for (int j = 0; j < n; ++j) {
                TreeFileSet node = (TreeFileSet)expNode.getChildAt(j);
                if (node.getType() != index) continue;
                this.refreshFolderNode(node, r.get(index));
            }
        }
        this.setExpandedParent(expNode, true);
    }

    private void refreshTimeFolder(TreeImageDisplay expNode, Map<Integer, Set> r) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        expNode.setChildrenLoaded(Boolean.TRUE);
        expNode.setExpanded(true);
        if (r == null || r.size() == 0) {
            return;
        }
        Iterator<Integer> i = r.keySet().iterator();
        int n = expNode.getChildCount();
        dtm.reload();
        while (i.hasNext()) {
            int index = i.next();
            for (int j = 0; j < n; ++j) {
                TreeImageTimeSet node = (TreeImageTimeSet)expNode.getChildAt(j);
                int nodeType = node.getType();
                switch (nodeType) {
                    case 103: 
                    case 104: {
                        List children = node.getChildrenDisplay();
                        for (TreeImageTimeSet child : children) {
                            if (child.getIndex() != index) continue;
                            this.refreshFolderNode(child, r.get(index));
                        }
                        break;
                    }
                }
                if (node.getIndex() != index) continue;
                this.refreshFolderNode(node, r.get(index));
            }
        }
        this.setExpandedParent(expNode, true);
    }

    BrowserUI() {
        this.listener = new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                BrowserUI.this.onNodeNavigation(e, false);
            }

            public void treeExpanded(TreeExpansionEvent e) {
                BrowserUI.this.onNodeNavigation(e, true);
            }
        };
    }

    void initialize(BrowserControl controller, BrowserModel model, ExperimenterData exp) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller cannot be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        this.controller = controller;
        this.model = model;
        this.createMenuBars();
        this.createTrees(exp);
        this.buildGUI();
    }

    void loadAction(TreeImageDisplay parent) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        parent.removeAllChildren();
        tm.insertNodeInto(new DefaultMutableTreeNode(LOADING_MSG), parent, parent.getChildCount());
        tm.reload(parent);
    }

    boolean isFirstChildMessage(TreeImageDisplay parent) {
        int n = parent.getChildCount();
        if (n == 0) {
            return true;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(0);
        Object uo = node.getUserObject();
        return LOADING_MSG.equals(uo) || EMPTY_MSG.equals(uo);
    }

    JTree getTreeDisplay() {
        return this.treeDisplay;
    }

    TreeImageDisplay getTreeRoot() {
        if (this.treeDisplay == null) {
            return null;
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        if (dtm == null) {
            return null;
        }
        return (TreeImageDisplay)dtm.getRoot();
    }

    String getBrowserTitle() {
        switch (this.model.getBrowserType()) {
            case 100: {
                return "Hierarchies";
            }
            case 101: {
                return "Images";
            }
            case 102: {
                return "Tags";
            }
            case 103: {
                return "Screens";
            }
            case 104: {
                return "Attachments";
            }
            case 105: {
                return "File System";
            }
            case 107: {
                return "Administration";
            }
        }
        return "";
    }

    void selectFoundNode(TreeImageDisplay node) {
        TreePath path = new TreePath(node.getPath());
        this.treeDisplay.setSelectionPath(path);
        TreeCellRenderer renderer = (TreeCellRenderer)this.treeDisplay.getCellRenderer();
        renderer.getTreeCellRendererComponent(this.treeDisplay, node, this.treeDisplay.isPathSelected(path), false, true, 0, false);
    }

    void collapsePath(DefaultMutableTreeNode node) {
        this.treeDisplay.removeTreeExpansionListener(this.listener);
        this.treeDisplay.collapsePath(new TreePath(node.getPath()));
        this.treeDisplay.addTreeExpansionListener(this.listener);
    }

    void cancel(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.getChildCount() <= 1 && node.getUserObject() instanceof String) {
            node.removeAllChildren();
            this.buildEmptyNode(node);
        }
        ((DefaultTreeModel)this.treeDisplay.getModel()).reload(node);
        this.collapsePath(node);
    }

    void updateNodes(List nodes, DataObject object) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        for (TreeImageDisplay node : nodes) {
            node.setUserObject(object);
            dtm.nodeChanged(node);
        }
    }

    void removeNodes(List nodes, TreeImageDisplay parentDisplay) {
        if (parentDisplay == null) {
            parentDisplay = this.getTreeRoot();
        }
        Iterator i = nodes.iterator();
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        while (i.hasNext()) {
            TreeImageDisplay node = (TreeImageDisplay)i.next();
            TreeImageDisplay parent = node.getParentDisplay();
            if (!parent.isChildrenLoaded()) continue;
            parent.removeChildDisplay(node);
            parent.remove(node);
            dtm.reload(parent);
            if (!parent.equals(parentDisplay)) continue;
            this.treeDisplay.setSelectionPath(new TreePath(parent.getPath()));
        }
    }

    void createNodes(List nodes, TreeImageDisplay newNode, TreeImageDisplay parentDisplay) {
        if (parentDisplay == null) {
            parentDisplay = this.getTreeRoot();
        }
        Iterator i = nodes.iterator();
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        boolean toLoad = false;
        while (i.hasNext()) {
            TreeImageDisplay parent = (TreeImageDisplay)i.next();
            if (parent.isChildrenLoaded()) {
                parent.addChildDisplay(newNode);
                List list = this.prepareSortedList(this.sorter.sort(parent.getChildrenDisplay()));
                parent.removeAllChildren();
                for (TreeImageDisplay n : list) {
                    if (!n.isChildrenLoaded()) {
                        n.removeAllChildren();
                        this.buildEmptyNode(n);
                    }
                    dtm.insertNodeInto(n, parent, parent.getChildCount());
                }
                dtm.reload(parent);
                this.expandNode(parent);
                if (!parent.equals(parentDisplay)) continue;
                this.treeDisplay.setSelectionPath(new TreePath(newNode.getPath()));
                continue;
            }
            if (!parent.equals(parentDisplay)) continue;
            toLoad = true;
        }
        if (toLoad) {
            // empty if block
        }
    }

    void sortNodes(int type) {
        boolean b = type == 300;
        this.sorter.setByDate(b);
        this.sorter.setAscending(!b);
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay root = (TreeImageDisplay)dtm.getRoot();
        int n = root.getChildCount();
        switch (this.model.getBrowserType()) {
            case 101: {
                for (int i = 0; i < n; ++i) {
                    TreeImageDisplay node = (TreeImageDisplay)root.getChildAt(i);
                    List children = node.getChildrenDisplay();
                    for (TreeImageDisplay child : children) {
                        if (!(child instanceof TreeImageTimeSet)) continue;
                        this.sortNode((TreeImageTimeSet)child);
                    }
                }
                break;
            }
            case 107: {
                for (int i = 0; i < n; ++i) {
                    TreeImageDisplay node = (TreeImageDisplay)root.getChildAt(i);
                    List children = node.getChildrenDisplay();
                    node.removeAllChildren();
                    dtm.reload(node);
                    if (children.size() != 0) {
                        if (node.getUserObject() instanceof GroupData) {
                            List all = this.prepareSortedList(this.sorter.sort(children));
                            this.buildTreeNode(node, all, dtm);
                        } else {
                            this.buildTreeNode(node, this.sorter.sort(children), dtm);
                        }
                    } else {
                        this.buildEmptyNode(node);
                    }
                    Iterator<TreeImageDisplay> j = this.nodesToReset.iterator();
                    while (j.hasNext()) {
                        this.setExpandedParent(j.next(), true);
                    }
                }
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    TreeImageDisplay node = (TreeImageDisplay)root.getChildAt(i);
                    List children = node.getChildrenDisplay();
                    node.removeAllChildren();
                    dtm.reload(node);
                    if (children.size() != 0) {
                        if (node.getUserObject() instanceof ExperimenterData) {
                            List all = this.prepareSortedList(this.sorter.sort(children));
                            this.buildTreeNode(node, all, dtm);
                        } else {
                            this.buildTreeNode(node, this.sorter.sort(children), dtm);
                        }
                    } else {
                        this.buildEmptyNode(node);
                    }
                    Iterator<TreeImageDisplay> j = this.nodesToReset.iterator();
                    while (j.hasNext()) {
                        this.setExpandedParent(j.next(), true);
                    }
                }
            }
        }
    }

    void loadExperimenterData() {
        TreeImageDisplay root = this.getTreeRoot();
        TreeImageDisplay child = (TreeImageDisplay)root.getFirstChild();
        this.treeDisplay.expandPath(new TreePath(child.getPath()));
    }

    void onStateChanged(boolean b) {
        this.model.getParentModel().onComponentStateChange(b);
    }

    void onComponentStateChange(boolean b) {
        this.treeDisplay.setEnabled(b);
    }

    void setNullSelectedNode() {
        if (this.getTreeRoot() != null) {
            this.treeDisplay.setSelectionRow(-1);
        }
    }

    boolean isPartialName() {
        return !this.partialButton.isSelected();
    }

    void removeTreePaths(List paths) {
        this.treeDisplay.removeTreeSelectionListener(this.selectionListener);
        Iterator j = paths.iterator();
        while (j.hasNext()) {
            this.treeDisplay.removeSelectionPath((TreePath)j.next());
        }
        this.treeDisplay.addTreeSelectionListener(this.selectionListener);
    }

    void setExperimenterData(Set nodes, TreeImageDisplay expNode) {
        Iterator<Object> i;
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        expNode.removeAllChildren();
        expNode.removeAllChildrenDisplay();
        expNode.setChildrenLoaded(Boolean.TRUE);
        dtm.reload();
        if (nodes.size() != 0) {
            i = nodes.iterator();
            while (i.hasNext()) {
                expNode.addChildDisplay((TreeImageDisplay)i.next());
            }
            this.buildTreeNode(expNode, this.prepareSortedList(this.sorter.sort(nodes)), (DefaultTreeModel)this.treeDisplay.getModel());
            if (this.model.getBrowserType() == 102) {
                this.createTagsElements(expNode);
            }
        } else {
            expNode.setExpanded(false);
            if (this.model.getBrowserType() == 102) {
                this.createTagsElements(expNode);
            } else {
                this.buildEmptyNode(expNode);
            }
        }
        i = this.nodesToReset.iterator();
        while (i.hasNext()) {
            this.setExpandedParent((TreeImageDisplay)i.next(), true);
        }
        TreeImageDisplay root = this.getTreeRoot();
        for (int j = 0; j < root.getChildCount(); ++j) {
            TreeImageDisplay element = (TreeImageDisplay)root.getChildAt(j);
            if (!(element.getUserObject() instanceof ExperimenterData) || !element.isExpanded()) continue;
            this.expandNode(element);
        }
    }

    void setGroups(Set nodes, List expanded) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay root = this.getTreeRoot();
        root.removeAllChildren();
        root.removeAllChildrenDisplay();
        root.setChildrenLoaded(Boolean.TRUE);
        root.setExpanded(true);
        dtm.reload();
        if (nodes.size() != 0) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                root.addChildDisplay((TreeImageDisplay)i.next());
            }
            this.buildTreeNode(root, this.prepareSortedList(this.sorter.sort(nodes)), dtm);
            i = nodes.iterator();
            while (i.hasNext()) {
                ((TreeImageDisplay)i.next()).setExpanded(false);
            }
            if (expanded != null && expanded.size() > 0) {
                for (TreeImageDisplay display : nodes) {
                    GroupData g;
                    Object ho = display.getUserObject();
                    if (!(ho instanceof GroupData) || !expanded.contains((g = (GroupData)ho).getId())) continue;
                    this.expandNode(display);
                }
            }
        }
        if (TreeViewerAgent.isAdministrator()) {
            SmartFolder folder = new SmartFolder(GroupData.class, "Experimenters w/o groups");
            this.buildEmptyNode(folder);
        }
    }

    void setCountValues(TreeImageDisplay expNode, int index, Object value) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        if (this.model.getBrowserType() != 102) {
            expNode.setChildrenLoaded(Boolean.TRUE);
        }
        expNode.setExpanded(true);
        int n = expNode.getChildCount();
        ArrayList<TreeImageTimeSet> toRemove = new ArrayList<TreeImageTimeSet>();
        ArrayList<TreeImageTimeSet> toKeep = new ArrayList<TreeImageTimeSet>();
        for (int j = 0; j < n; ++j) {
            TreeImageSet node = (TreeImageSet)expNode.getChildAt(j);
            if (node instanceof TreeImageTimeSet) {
                if (((TreeImageTimeSet)node).getType() != index) continue;
                if (value instanceof Integer) {
                    node.setNumberItems(((Integer)value).intValue());
                } else if (value instanceof List) {
                    List l = (List)value;
                    int total = 0;
                    for (TreeImageTimeSet child : node.getChildrenDisplay()) {
                        int number = child.countTime(l);
                        total += number;
                        if (number > 0) {
                            child.setNumberItems(number);
                            toKeep.add(child);
                            continue;
                        }
                        toRemove.add(child);
                    }
                    node.removeAllChildren();
                    node.removeChildrenDisplay(toRemove);
                    node.setNumberItems(total);
                    Iterator k = toKeep.iterator();
                    while (k.hasNext()) {
                        dtm.insertNodeInto((TreeImageTimeSet)k.next(), node, node.getChildCount());
                    }
                }
                dtm.reload(node);
                continue;
            }
            if (!(node instanceof TreeFileSet) || ((TreeFileSet)node).getType() != index || !(value instanceof Long)) continue;
            node.setNumberItems((Long)value);
        }
    }

    void refreshFolder(TreeImageDisplay expNode, Map<Integer, Set> r) {
        int browseType = this.model.getBrowserType();
        if (browseType == 101) {
            this.refreshTimeFolder(expNode, r);
        } else if (browseType == 104) {
            this.refreshFileFolder(expNode, r);
        }
    }

    void setLeavesViews(Collection nodes, TreeImageSet parent) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        parent.removeAllChildren();
        parent.removeAllChildrenDisplay();
        parent.setChildrenLoaded(Boolean.TRUE);
        if (nodes.size() != 0) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                parent.addChildDisplay((TreeImageDisplay)i.next());
            }
            this.buildTreeNode(parent, this.sorter.sort(nodes), dtm);
        } else {
            this.buildEmptyNode(parent);
        }
        dtm.reload(parent);
        if (!this.isPartialName()) {
            this.model.component.accept(new PartialNameVisitor(this.isPartialName()), 0);
        }
    }

    void addExperimenter(ExperimenterData experimenter, boolean load) {
        TreeImageSet node = this.createExperimenterNode(experimenter);
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        dtm.reload();
        if (load) {
            this.treeDisplay.expandPath(new TreePath(node.getPath()));
        }
    }

    void removeExperimenter(ExperimenterData exp) {
        TreeImageDisplay root = this.getTreeRoot();
        ArrayList<TreeImageDisplay> nodesToKeep = new ArrayList<TreeImageDisplay>();
        TreeImageDisplay node = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeImageDisplay element = (TreeImageDisplay)root.getChildAt(i);
            Object ho = element.getUserObject();
            if (!(ho instanceof ExperimenterData)) continue;
            ExperimenterData expElement = (ExperimenterData)ho;
            if (expElement.getId() == exp.getId()) {
                node = element;
                continue;
            }
            nodesToKeep.add(element);
        }
        if (node != null) {
            root.removeChildDisplay(node);
        }
        Iterator i = nodesToKeep.iterator();
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        root.removeAllChildren();
        while (i.hasNext()) {
            tm.insertNodeInto((TreeImageSet)i.next(), root, root.getChildCount());
        }
        tm.reload();
    }

    void reActivate() {
        TreeImageDisplay root = this.getTreeRoot();
        root.removeAllChildren();
        root.removeAllChildrenDisplay();
        this.createExperimenterNode(TreeViewerAgent.getUserDetails());
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.reload();
    }

    TreeImageDisplay getLoggedExperimenterNode() {
        TreeImageDisplay root = this.getTreeRoot();
        return (TreeImageDisplay)root.getChildAt(0);
    }

    void refreshExperimenter() {
        TreeImageDisplay root = this.getTreeRoot();
        TreeImageDisplay element = (TreeImageDisplay)root.getChildAt(0);
        Object ho = element.getUserObject();
        if (ho instanceof ExperimenterData) {
            element.setUserObject(this.model.getUserDetails());
            DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
            tm.reload(element);
        }
    }

    void setFoundNode(TreeImageDisplay[] newSelection) {
        this.treeDisplay.removeTreeSelectionListener(this.selectionListener);
        this.treeDisplay.clearSelection();
        if (newSelection != null) {
            TreePath[] paths = new TreePath[newSelection.length];
            for (int i = 0; i < newSelection.length; ++i) {
                paths[i] = new TreePath(newSelection[i].getPath());
            }
            this.treeDisplay.setSelectionPaths(paths);
        }
        this.treeDisplay.repaint();
        this.treeDisplay.addTreeSelectionListener(this.selectionListener);
    }

    void loadFile(TreeImageDisplay display) {
        display.removeAllChildren();
        display.removeAllChildrenDisplay();
        display.setChildrenLoaded(Boolean.TRUE);
        display.setExpanded(true);
        this.transformDirectory((TreeImageSet)display);
        this.buildTreeNode(display, this.prepareSortedList(this.sorter.sort(display.getChildrenDisplay())), (DefaultTreeModel)this.treeDisplay.getModel());
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.reload(display);
    }

    void loadFileSystem(TreeImageDisplay expNode) {
        if (this.model.getBrowserType() != 105) {
            return;
        }
        this.setExperimenterData(this.createFileSystemExplorer(expNode), expNode);
    }

    void reloadContainer(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        node.removeAllChildren();
        node.removeAllChildrenDisplay();
        node.setChildrenLoaded(Boolean.FALSE);
        this.buildEmptyNode(node);
        this.treeDisplay.collapsePath(new TreePath(node.getPath()));
        this.treeDisplay.expandPath(new TreePath(node.getPath()));
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.reload(node);
    }

    void reloadNode(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.reload(node);
    }

    void expandUser() {
        TreeImageDisplay root = this.getTreeRoot();
        long id = this.model.getUserID();
        for (int i = 0; i < root.getChildCount(); ++i) {
            ExperimenterData exp;
            TreeImageDisplay element = (TreeImageDisplay)root.getChildAt(i);
            Object ho = element.getUserObject();
            if (!(ho instanceof ExperimenterData) || (exp = (ExperimenterData)ho).getId() != id || element.isExpanded()) continue;
            this.expandNode(element);
            break;
        }
    }

    void expandNode(TreeImageDisplay node, boolean withListener) {
        node.setExpanded(true);
        if (withListener) {
            this.treeDisplay.expandPath(new TreePath(node.getPath()));
        } else {
            this.treeDisplay.removeTreeExpansionListener(this.listener);
            this.treeDisplay.expandPath(new TreePath(node.getPath()));
            this.treeDisplay.addTreeExpansionListener(this.listener);
        }
    }

    void expandNode(TreeImageDisplay node) {
        this.expandNode(node, false);
    }

    void addComponent(JComponent component) {
        if (this.bottomComponent != null) {
            this.remove(this.bottomComponent);
        }
        this.bottomComponent = component;
        if (component != null) {
            this.add((Component)this.bottomComponent, "South");
        }
        this.revalidate();
        this.repaint();
    }
}

