/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.finder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderControl;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderModel;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderUI;
import org.openmicroscopy.shoola.agents.treeviewer.finder.RegExVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.RegExFactory;

public class Finder
extends JPanel {
    public static final String TEXT_ENTERED_PROPERTY = "textEntered";
    public static final String LEVEL_PROPERTY = "level";
    public static final String RETRIEVED_PROPERTY = "retrieved";
    private FinderUI uiDelegate;
    private FinderModel model;
    private FinderControl controller;
    private boolean found;

    private void buildGUI() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.uiDelegate, "Center");
    }

    public Finder(TreeViewer parentComponent) {
        if (parentComponent == null) {
            throw new IllegalArgumentException("No parent component.");
        }
        this.found = false;
        this.model = new FinderModel(parentComponent);
        this.controller = new FinderControl(this);
        parentComponent.addPropertyChangeListener("finderVisible", this.controller);
        this.uiDelegate = new FinderUI(this, this.controller, this.model);
        this.controller.initialize(this.uiDelegate);
        this.buildGUI();
    }

    void setNameSelected(boolean b) {
        if (b == this.model.isNameSelected()) {
            return;
        }
        this.found = false;
        Boolean oldValue = this.model.isNameSelected() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.model.setNameSelected(b);
        this.firePropertyChange(LEVEL_PROPERTY, oldValue, newValue);
    }

    void setDescriptionSelected(boolean b) {
        if (b == this.model.isDescriptionSelected()) {
            return;
        }
        this.found = false;
        Boolean oldValue = this.model.isDescriptionSelected() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.model.setDescriptionSelected(b);
        this.firePropertyChange(LEVEL_PROPERTY, oldValue, newValue);
    }

    void setAnnotationSelected(boolean b) {
        if (b == this.model.isAnnotationSelected()) {
            return;
        }
        this.found = false;
        Boolean oldValue = this.model.isAnnotationSelected() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.model.setAnnotationSelected(b);
        this.firePropertyChange(LEVEL_PROPERTY, oldValue, newValue);
    }

    void setTextUpdate(String text) {
        this.found = false;
        String oldValue = this.model.getFindText();
        this.model.setFindText(text);
        this.firePropertyChange(TEXT_ENTERED_PROPERTY, oldValue, text);
    }

    void setCaseSensitive(boolean b) {
        if (b == this.model.isCaseSensitive()) {
            return;
        }
        this.found = false;
        this.model.setCaseSensitive(b);
    }

    boolean isCaseSensitive() {
        return this.model.isCaseSensitive();
    }

    boolean isTextEmpty() {
        return this.model.getFindText().length() == 0;
    }

    void close() {
        if (!this.model.isDisplay()) {
            return;
        }
        this.model.getParentComponent().showFinder(false);
    }

    boolean isNameSelected() {
        return this.model.isNameSelected();
    }

    boolean isDescriptionSelected() {
        return this.model.isDescriptionSelected();
    }

    boolean isAnnotationSelected() {
        return this.model.isAnnotationSelected();
    }

    void showMenu(Component c, Point p) {
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (p == null) {
            throw new IllegalArgumentException("No point.");
        }
        this.uiDelegate.showPopup(c, p);
    }

    void find() {
        TreeViewer pc = this.model.getParentComponent();
        if (pc.getSelectedBrowser() == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String findText = this.model.getFindText();
            Pattern p = !this.model.isCaseSensitive() ? RegExFactory.createCaseInsensitivePattern(findText) : RegExFactory.createPattern(findText);
            RegExVisitor visitor = new RegExVisitor(this, p);
            pc.getSelectedBrowser().accept(visitor);
            Set set = visitor.getFoundNodes();
            pc.getSelectedBrowser().setFoundInBrowser(set);
            this.found = true;
            this.model.addToHistory(findText);
            this.firePropertyChange(RETRIEVED_PROPERTY, (Object)-1, (Object)set.size());
        }
        catch (PatternSyntaxException pse) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Find", "The phrase contains non valid characters.");
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void findNext() {
        if (!this.found) {
            this.find();
        } else {
            TreeViewer pc = this.model.getParentComponent();
            if (pc.getSelectedBrowser() == null) {
                return;
            }
            pc.getSelectedBrowser().findNext();
        }
    }

    void findPrevious() {
        if (!this.found) {
            this.find();
        } else {
            TreeViewer pc = this.model.getParentComponent();
            if (pc.getSelectedBrowser() == null) {
                return;
            }
            pc.getSelectedBrowser().findPrevious();
        }
    }

    void setDisplay(boolean b) {
        this.model.setDisplay(b);
    }

    public boolean isDisplay() {
        return this.model.isDisplay();
    }
}

