/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.util.DeletableTableNode;
import org.openmicroscopy.shoola.agents.treeviewer.util.DeletableTableRenderer;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.treetable.OMETreeTable;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeTableModel;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotDeletedObjectDialog
extends JDialog {
    public static final int CLOSE = 0;
    static final int TYPE_COL = 0;
    static final int ID_COL = 1;
    static final int NAME_COL = 2;
    private static final String TITLE = "Objects not deleted";
    private static final String TEXT = "Follow the list of objects that could not be deleted.";
    private static final String NAME = "Name";
    private static final String TYPE = "Type";
    private static final String ID = "ID";
    private static Vector<String> COLUMNS = new Vector(3);
    private static Map<Integer, Class> RENDERERS;
    private OMETreeTable table;
    private DeletableTableNode root;
    private JButton closeButton;
    private int index;

    private void close() {
        this.index = 0;
        this.setVisible(false);
    }

    private void initComponents(Collection<DataObject> notDeleted) {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                NotDeletedObjectDialog.this.close();
            }
        });
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NotDeletedObjectDialog.this.close();
            }
        });
        this.getRootPane().setDefaultButton(this.closeButton);
        this.root = new DeletableTableNode("");
        for (DataObject node : notDeleted) {
            if (node == null) continue;
            this.root.insert((MutableTreeTableNode)new DeletableTableNode(node), this.root.getChildCount());
        }
        this.table = new OMETreeTable();
        this.table.setTableModel((TreeTableModel)new OMETreeTableModel(this.root, COLUMNS, RENDERERS));
        this.table.setTreeCellRenderer(new DeletableTableRenderer());
        this.table.setAutoResizeMode(4);
        this.table.setRootVisible(false);
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setHorizontalScrollEnabled(true);
    }

    public JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.closeButton);
        bar.add(Box.createHorizontalStrut(10));
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        return p;
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        Icon icon = icons.getIcon(91);
        Container c = this.getContentPane();
        TitlePanel tp = new TitlePanel(TITLE, TEXT, icon);
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)tp), "North");
        c.add((Component)new JScrollPane((Component)((Object)this.table)), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public NotDeletedObjectDialog(JFrame owner, Collection<DataObject> notDeleted) {
        super(owner);
        if (notDeleted == null || notDeleted.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        this.setModal(true);
        this.setTitle(TITLE);
        this.initComponents(notDeleted);
        this.buildGUI();
        this.pack();
    }

    public int centerAndShow() {
        UIUtilities.centerAndShow(this);
        return this.index;
    }

    static {
        COLUMNS.add(TYPE);
        COLUMNS.add(ID);
        COLUMNS.add(NAME);
        RENDERERS = new HashMap<Integer, Class>();
        RENDERERS.put(2, DeletableTableNode.class);
        RENDERERS.put(0, String.class);
        RENDERERS.put(1, Long.class);
    }
}

