/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBox
extends MessageBox {
    private static final String TITLE = "Confirm delete";
    private static final String DEFAULT_TEXT = "Are you sure you want to delete the selected ";
    private static final String TOOL_TIP = "The annotations are deleted only if you own them and if they are not used by others.";
    private static final String WARNING_GROUP_OWNER = "Some data might be used by other users,\nthey will no longer be able to use or see them.";
    private JButton infoButton;
    private JRadioButton withContent;
    private JRadioButton withoutContent;
    private JCheckBox withAnnotation;
    private Class type;
    private String nameSpace;
    private boolean annotation;
    private boolean children;
    private Map<JCheckBox, Class> annotationTypes;
    private JPanel typesPane;

    private JCheckBox createBox(String name) {
        JCheckBox box = new JCheckBox(name);
        Font f = box.getFont();
        int size = f.getSize() - 2;
        Font newFont = f.deriveFont(2, size);
        box.setSelected(true);
        box.setFont(newFont);
        box.setEnabled(false);
        return box;
    }

    private void initComponents(String annotationText) {
        IconManager icons = IconManager.getInstance();
        this.infoButton = new JButton(icons.getIcon(105));
        this.infoButton.setToolTipText(TOOL_TIP);
        this.withAnnotation = new JCheckBox("Also delete the annotations linked to the objects.");
        this.withAnnotation.setToolTipText(TOOL_TIP);
        this.withContent = new JRadioButton("Also delete contents.");
        this.withoutContent = new JRadioButton("Do not delete contents.");
        ButtonGroup group = new ButtonGroup();
        group.add(this.withContent);
        group.add(this.withoutContent);
        this.withoutContent.setSelected(true);
        this.annotationTypes = new LinkedHashMap<JCheckBox, Class>();
        this.annotationTypes.put(this.createBox("Tag"), TagAnnotationData.class);
        this.annotationTypes.put(this.createBox("Attachment"), FileAnnotationData.class);
        this.withAnnotation.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DeleteBox.this.layoutAnnotationTypes();
            }
        });
        this.typesPane = new JPanel();
        this.typesPane.setLayout(new GridBagLayout());
    }

    private void layoutAnnotationTypes() {
        boolean b = this.withAnnotation.isSelected();
        this.typesPane.setEnabled(b);
        Iterator<JCheckBox> i = this.annotationTypes.keySet().iterator();
        while (i.hasNext()) {
            i.next().setEnabled(b);
        }
    }

    private JLabel buildAnnotationWarning() {
        JLabel label = UIUtilities.setTextFont(TOOL_TIP, 2);
        Font f = label.getFont();
        label.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        return label;
    }

    private void layoutComponents() {
        JPanel body;
        Iterator<JCheckBox> i = this.annotationTypes.keySet().iterator();
        TableLayout layout = new TableLayout();
        double[] columns = new double[]{130.0, -2.0};
        layout.setColumn(columns);
        this.typesPane.setLayout((LayoutManager)layout);
        int index = 0;
        while (i.hasNext()) {
            layout.insertRow(index, -2.0);
            this.typesPane.add(Box.createHorizontalStrut(5), "0, " + index);
            this.typesPane.add((Component)i.next(), "1, " + index);
            ++index;
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        boolean add = false;
        if (ImageData.class.equals((Object)this.type)) {
            add = true;
            if (this.annotation) {
                p.add(this.buildAnnotationWarning());
                p.add(Box.createVerticalStrut(10));
                p.add(this.withAnnotation);
                p.add(this.typesPane);
            }
        } else if (DatasetData.class.equals((Object)this.type) || ProjectData.class.equals((Object)this.type) || PlateData.class.equals((Object)this.type) || ScreenData.class.equals((Object)this.type) || PlateAcquisitionData.class.equals((Object)this.type)) {
            add = true;
            if (this.children) {
                p.add(this.withContent);
                p.add(this.withoutContent);
            }
            if (this.annotation) {
                p.add(new JSeparator());
                p.add(this.buildAnnotationWarning());
                p.add(Box.createVerticalStrut(10));
                p.add(this.withAnnotation);
                p.add(this.typesPane);
            }
        } else if (TagAnnotationData.class.equals((Object)this.type) && "openmicroscopy.org/omero/insight/tagset".equals(this.nameSpace)) {
            add = true;
            if (this.children) {
                p.add(this.withContent);
                p.add(this.withoutContent);
            }
        }
        if (TreeViewerAgent.isLeaderOfCurrentGroup()) {
            body = new JPanel();
            body.setLayout(new BoxLayout(body, 1));
            body.add(p);
            JLabel label = UIUtilities.setTextFont(WARNING_GROUP_OWNER, 1);
            label.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
            body.add(UIUtilities.buildComponentPanel(label));
        } else {
            body = p;
        }
        if (add) {
            this.addBodyComponent(UIUtilities.buildComponentPanel(body));
        }
    }

    private static String getTypeAsString(Class type, int number, String ns) {
        String end = "";
        if (number > 1) {
            end = "s";
        }
        if (ImageData.class.equals((Object)type)) {
            return "Image" + end;
        }
        if (DatasetData.class.equals((Object)type)) {
            return "Dataset" + end;
        }
        if (ProjectData.class.equals((Object)type)) {
            return "Project" + end;
        }
        if (FileAnnotationData.class.equals((Object)type)) {
            return "File" + end;
        }
        if (ScreenData.class.equals((Object)type)) {
            return "Screen" + end;
        }
        if (PlateData.class.equals((Object)type)) {
            return "Plate" + end;
        }
        if (PlateAcquisitionData.class.equals((Object)type)) {
            return "Plate Run" + end;
        }
        if (ExperimenterData.class.equals((Object)type)) {
            return "Experimenter" + end;
        }
        if (GroupData.class.equals((Object)type)) {
            return "Group" + end;
        }
        if (TagAnnotationData.class.equals((Object)type)) {
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                return "Tag Set" + end;
            }
            return "Tag" + end;
        }
        return "";
    }

    private static String getMessage(Class type, int number, String nameSpace, boolean annotation, boolean children) {
        StringBuffer buffer = new StringBuffer();
        String value = DeleteBox.getTypeAsString(type, number, nameSpace);
        String text = null;
        if (value != null && value.length() > 0) {
            text = DEFAULT_TEXT + value + "?";
        }
        if (text != null) {
            buffer.append(text);
            buffer.append("\n");
            if (ImageData.class.equals((Object)type) || DatasetData.class.equals((Object)type) || ProjectData.class.equals((Object)type) || ScreenData.class.equals((Object)type) || PlateData.class.equals((Object)type) || PlateAcquisitionData.class.equals((Object)type)) {
                if (annotation || children) {
                    buffer.append("If yes, ");
                }
            } else if (TagAnnotationData.class.equals((Object)type) && "openmicroscopy.org/omero/insight/tagset".equals(nameSpace) && children) {
                buffer.append("If yes, ");
            }
        }
        return buffer.toString();
    }

    public DeleteBox(Class type, boolean annotation, boolean children, int number, String nameSpace, JFrame parent) {
        super(parent, TITLE, DeleteBox.getMessage(type, number, nameSpace, annotation, children));
        this.nameSpace = nameSpace;
        this.type = type;
        this.annotation = annotation;
        if (PlateData.class.equals((Object)type)) {
            children = false;
        }
        this.children = children;
        this.initComponents(DeleteBox.getTypeAsString(type, number, nameSpace));
        this.layoutComponents();
        this.pack();
        this.setResizable(false);
    }

    public boolean deleteContents() {
        if (ImageData.class.equals((Object)this.type)) {
            return false;
        }
        return this.withContent.isSelected();
    }

    public List<Class> getAnnotationTypes() {
        ArrayList<Class> types = new ArrayList<Class>();
        Iterator<JCheckBox> i = this.annotationTypes.keySet().iterator();
        if (!this.withAnnotation.isSelected()) {
            while (i.hasNext()) {
                JCheckBox box = i.next();
                types.add(this.annotationTypes.get(box));
            }
        } else {
            while (i.hasNext()) {
                JCheckBox box = i.next();
                if (box.isSelected()) continue;
                types.add(this.annotationTypes.get(box));
            }
        }
        return types;
    }
}

