/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.AddAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowseContainerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserSelectionAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ClearAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateTopContainerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.DownloadAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.EditorAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ExitApplicationAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.FinderAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.FullScreenViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.GroupSelectionAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ImportAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ImporterVisibilityAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.InspectorVisibilityAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManageObjectAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManageRndSettingsAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManagerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.MetadataVisibilityAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.NewObjectAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.PasswordResetAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.PersonalManagementAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RefreshExperimenterData;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RefreshTreeAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RemoveExperimenterNode;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RollOverAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SearchAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SendFeedbackAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SwitchUserAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TaggingAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.UploadScriptAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ViewImageAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ViewOtherAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CopyCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CutCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteRndSettingsCmd;
import org.openmicroscopy.shoola.agents.treeviewer.util.ImportableObject;
import org.openmicroscopy.shoola.agents.treeviewer.view.TaskPaneBrowser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import org.openmicroscopy.shoola.agents.util.DataObjectRegistration;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.ScriptActivityParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.JXTaskPaneContainerSingle;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.WellData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeViewerControl
implements ChangeListener,
PropertyChangeListener,
WindowFocusListener {
    static final Integer BROWSE = 1;
    static final Integer CREATE_OBJECT = 3;
    static final Integer COPY_OBJECT = 4;
    static final Integer PASTE_OBJECT = 5;
    static final Integer DELETE_OBJECT = 6;
    static final Integer HIERARCHY_EXPLORER = 7;
    static final Integer IMAGES_EXPLORER = 9;
    static final Integer FIND = 10;
    static final Integer EXIT = 14;
    static final Integer CLEAR = 15;
    static final Integer ADD_OBJECT = 16;
    static final Integer CREATE_TOP_PROJECT = 17;
    static final Integer REFRESH_TREE = 18;
    static final Integer MANAGER = 19;
    static final Integer CUT_OBJECT = 21;
    static final Integer ACTIVATION = 22;
    static final Integer SWITCH_USER = 23;
    static final Integer ROLL_OVER = 26;
    static final Integer REMOVE_FROM_DISPLAY = 27;
    static final Integer REFRESH_EXPERIMENTER = 29;
    static final Integer PASTE_RND_SETTINGS = 31;
    static final Integer COPY_RND_SETTINGS = 32;
    static final Integer RESET_RND_SETTINGS = 33;
    static final Integer SEARCH = 34;
    static final Integer TAGS_EXPLORER = 35;
    static final Integer SET_RND_SETTINGS = 36;
    static final Integer CREATE_TOP_DATASET = 37;
    static final Integer CREATE_TOP_TAG = 38;
    static final Integer SCREENS_EXPLORER = 39;
    static final Integer CREATE_TOP_SCREEN = 40;
    static final Integer VIEW = 41;
    static final Integer NEW_OBJECT = 42;
    static final Integer EDITOR_NO_SELECTION = 43;
    static final Integer FILES_EXPLORER = 44;
    static final Integer CREATE_TOP_TAG_SET = 45;
    static final Integer NEW_TAG_OBJECT = 46;
    static final Integer TAGGING = 47;
    static final Integer EDITOR_WITH_SELECTION = 48;
    static final Integer EDITOR_NEW_WITH_SELECTION = 49;
    static final Integer INSPECTOR = 50;
    static final Integer IMPORTER = 51;
    static final Integer FILE_SYSTEM_EXPLORER = 52;
    static final Integer IMPORT = 53;
    static final Integer DOWNLOAD = 54;
    static final Integer BROWSE_NO_THUMBNAILS = 55;
    static final Integer VIEWER_WITH_OTHER = 56;
    static final Integer PERSONAL = 57;
    static final Integer FULLSCREEN = 58;
    static final Integer METADATA = 59;
    static final Integer UPLOAD_SCRIPT = 60;
    static final Integer CREATE_TOP_GROUP = 61;
    static final Integer CREATE_TOP_EXPERIMENTER = 62;
    static final Integer RESET_PASSWORD = 63;
    static final Integer SET_OWNER_RND_SETTINGS = 64;
    static final Integer SEND_COMMENT = 65;
    private TreeViewer model;
    private TreeViewerWin view;
    private Map<Integer, TreeViewerAction> actionsMap;
    private ChangeListener tabsListener;
    private LoadingWindow loadingWindow;

    private void downloadScript(ScriptActivityParam param) {
        FileChooser chooser = new FileChooser(this.view, 1, "Download", "Select where to download the file.", null, true);
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(109));
        chooser.setSelectedFileFull(param.getScript().getName());
        chooser.setApproveButtonText("Download");
        final long id = param.getScript().getScriptID();
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    File folder = (File)evt.getNewValue();
                    IconManager icons = IconManager.getInstance();
                    DownloadActivityParam activity = new DownloadActivityParam(id, 0, folder, icons.getIcon(110));
                    UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                    un.notifyActivity(activity);
                }
            }
        });
        chooser.centerDialog();
    }

    private void handleTaskPaneSelection(JXTaskPane pane) {
        JXTaskPaneContainerSingle container = (JXTaskPaneContainerSingle)((Object)pane.getParent());
        if (pane.isCollapsed() && container.hasTaskPaneExpanded()) {
            return;
        }
        int state = this.model.getState();
        if (state == 7 || state == 1) {
            this.model.clearFoundResults();
            if (!container.hasTaskPaneExpanded()) {
                this.model.setSelectedBrowser(null);
            } else if (pane instanceof TaskPaneBrowser) {
                TaskPaneBrowser p = (TaskPaneBrowser)pane;
                if (p.getBrowser() != null) {
                    this.model.setSelectedBrowser(p.getBrowser());
                } else {
                    this.model.setSelectedBrowser(null);
                    this.model.showSearch();
                }
            } else {
                this.model.setSelectedBrowser(null);
            }
        } else {
            pane.setCollapsed(true);
        }
    }

    private void createActions() {
        this.actionsMap.put(BROWSE, new BrowseContainerAction(this.model));
        this.actionsMap.put(BROWSE_NO_THUMBNAILS, new BrowseContainerAction(this.model, false));
        this.actionsMap.put(CREATE_OBJECT, new CreateAction(this.model));
        this.actionsMap.put(COPY_OBJECT, new ManageObjectAction(this.model, 0));
        this.actionsMap.put(DELETE_OBJECT, new ManageObjectAction(this.model, 2));
        this.actionsMap.put(PASTE_OBJECT, new ManageObjectAction(this.model, 1));
        this.actionsMap.put(CUT_OBJECT, new ManageObjectAction(this.model, 3));
        this.actionsMap.put(SCREENS_EXPLORER, new BrowserSelectionAction(this.model, 103));
        this.actionsMap.put(HIERARCHY_EXPLORER, new BrowserSelectionAction(this.model, 100));
        this.actionsMap.put(TAGS_EXPLORER, new BrowserSelectionAction(this.model, 102));
        this.actionsMap.put(IMAGES_EXPLORER, new BrowserSelectionAction(this.model, 101));
        this.actionsMap.put(FILES_EXPLORER, new BrowserSelectionAction(this.model, 104));
        this.actionsMap.put(FILE_SYSTEM_EXPLORER, new BrowserSelectionAction(this.model, 105));
        this.actionsMap.put(FIND, new FinderAction(this.model));
        this.actionsMap.put(CLEAR, new ClearAction(this.model));
        this.actionsMap.put(EXIT, new ExitApplicationAction(this.model));
        this.actionsMap.put(ADD_OBJECT, new AddAction(this.model));
        this.actionsMap.put(CREATE_TOP_PROJECT, new CreateTopContainerAction(this.model, 0));
        this.actionsMap.put(CREATE_TOP_DATASET, new CreateTopContainerAction(this.model, 1));
        this.actionsMap.put(CREATE_TOP_TAG, new CreateTopContainerAction(this.model, 2));
        this.actionsMap.put(REFRESH_TREE, new RefreshTreeAction(this.model));
        this.actionsMap.put(MANAGER, new ManagerAction(this.model));
        this.actionsMap.put(ACTIVATION, new ActivationAction(this.model));
        this.actionsMap.put(SWITCH_USER, new SwitchUserAction(this.model));
        this.actionsMap.put(ROLL_OVER, new RollOverAction(this.model));
        this.actionsMap.put(REMOVE_FROM_DISPLAY, new RemoveExperimenterNode(this.model));
        this.actionsMap.put(REFRESH_EXPERIMENTER, new RefreshExperimenterData(this.model));
        this.actionsMap.put(PASTE_RND_SETTINGS, new ManageRndSettingsAction(this.model, 1));
        this.actionsMap.put(COPY_RND_SETTINGS, new ManageRndSettingsAction(this.model, 0));
        this.actionsMap.put(RESET_RND_SETTINGS, new ManageRndSettingsAction(this.model, 2));
        this.actionsMap.put(SET_OWNER_RND_SETTINGS, new ManageRndSettingsAction(this.model, 4));
        this.actionsMap.put(SEARCH, new SearchAction(this.model));
        this.actionsMap.put(SET_RND_SETTINGS, new ManageRndSettingsAction(this.model, 3));
        this.actionsMap.put(CREATE_TOP_SCREEN, new CreateTopContainerAction(this.model, 3));
        this.actionsMap.put(VIEW, new ViewImageAction(this.model));
        this.actionsMap.put(NEW_OBJECT, new NewObjectAction(this.model, 1));
        this.actionsMap.put(EDITOR_NO_SELECTION, new EditorAction(this.model, 0));
        this.actionsMap.put(EDITOR_WITH_SELECTION, new EditorAction(this.model, 1));
        this.actionsMap.put(CREATE_TOP_TAG_SET, new CreateTopContainerAction(this.model, 6));
        this.actionsMap.put(NEW_TAG_OBJECT, new NewObjectAction(this.model, 0));
        this.actionsMap.put(TAGGING, new TaggingAction(this.model));
        this.actionsMap.put(EDITOR_NEW_WITH_SELECTION, new EditorAction(this.model, 2));
        this.actionsMap.put(INSPECTOR, new InspectorVisibilityAction(this.model));
        this.actionsMap.put(IMPORTER, new ImporterVisibilityAction(this.model));
        this.actionsMap.put(IMPORT, new ImportAction(this.model));
        this.actionsMap.put(DOWNLOAD, new DownloadAction(this.model));
        this.actionsMap.put(VIEWER_WITH_OTHER, new ViewOtherAction(this.model, null));
        this.actionsMap.put(PERSONAL, new PersonalManagementAction(this.model));
        this.actionsMap.put(FULLSCREEN, new FullScreenViewerAction(this.model));
        this.actionsMap.put(METADATA, new MetadataVisibilityAction(this.model));
        this.actionsMap.put(UPLOAD_SCRIPT, new UploadScriptAction(this.model));
        this.actionsMap.put(CREATE_TOP_GROUP, new CreateTopContainerAction(this.model, 7));
        this.actionsMap.put(CREATE_TOP_EXPERIMENTER, new CreateTopContainerAction(this.model, 8));
        this.actionsMap.put(RESET_PASSWORD, new PasswordResetAction(this.model));
        this.actionsMap.put(SEND_COMMENT, new SendFeedbackAction(this.model));
    }

    private void createWindowsMenuItems(JMenu menu) {
        Set viewers = TreeViewerFactory.getViewers();
        Iterator i = viewers.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction((TreeViewer)i.next())));
        }
    }

    private void attachListeners() {
        Map browsers = this.model.getBrowsers();
        for (Browser browser : browsers.values()) {
            browser.addPropertyChangeListener(this);
            browser.addChangeListener(this);
        }
        this.view.addWindowFocusListener(this);
        this.model.addPropertyChangeListener(this);
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TreeViewerControl.this.model.closeWindow();
            }
        });
        JMenu menu = TreeViewerFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    TreeViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    TreeViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuKeyPressed(MenuKeyEvent e) {
            }

            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
    }

    TreeViewerControl(TreeViewer model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, TreeViewerAction>();
    }

    void initialize(TreeViewerWin view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.createActions();
        this.model.addChangeListener(this);
        this.attachListeners();
        TreeViewerFactory.attachWindowMenuToTaskBar();
        this.loadingWindow = new LoadingWindow(view);
        this.loadingWindow.setAlwaysOnTop(false);
        this.loadingWindow.setStatus("Saving changes");
    }

    List<ViewOtherAction> getApplicationActions() {
        ArrayList<ViewOtherAction> l = new ArrayList<ViewOtherAction>();
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return l;
        }
        TreeImageDisplay d = browser.getLastSelectedDisplay();
        if (d == null) {
            return l;
        }
        Object object = d.getUserObject();
        if (!(object instanceof DataObject)) {
            return l;
        }
        String type = this.view.getObjectMimeType();
        if (type == null) {
            return l;
        }
        List<ApplicationData> applications = TreeViewerFactory.getApplications(type);
        if (applications == null) {
            return l;
        }
        for (ApplicationData data : applications) {
            l.add(new ViewOtherAction(this.model, data));
        }
        return l;
    }

    ChangeListener getTabbedListener() {
        if (this.tabsListener == null) {
            this.tabsListener = new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JTabbedPane pane = (JTabbedPane)ce.getSource();
                    TreeViewerControl.this.model.clearFoundResults();
                    Component c = pane.getSelectedComponent();
                    if (c == null) {
                        TreeViewerControl.this.model.setSelectedBrowser(null);
                        return;
                    }
                    Map browsers = TreeViewerControl.this.model.getBrowsers();
                    Iterator i = browsers.values().iterator();
                    boolean selected = false;
                    while (i.hasNext()) {
                        Browser browser = (Browser)i.next();
                        if (!c.equals(browser.getUI())) continue;
                        TreeViewerControl.this.model.setSelectedBrowser(browser);
                        selected = true;
                        break;
                    }
                    if (!selected) {
                        TreeViewerControl.this.model.setSelectedBrowser(null);
                    }
                }
            };
        }
        return this.tabsListener;
    }

    void attachUIListeners(JComponent component) {
        if (component instanceof JTabbedPane) {
            ((JTabbedPane)component).addChangeListener(this.getTabbedListener());
        } else if (component instanceof JXTaskPaneContainer) {
            component.addPropertyChangeListener("selectedTaskPane", this);
        }
    }

    TreeViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    List<GroupSelectionAction> getUserGroupAction() {
        ArrayList<GroupSelectionAction> l = new ArrayList<GroupSelectionAction>();
        Set m = TreeViewerAgent.getAvailableUserGroups();
        if (m == null || m.size() == 0) {
            return l;
        }
        ViewerSorter sorter = new ViewerSorter();
        for (GroupData group : sorter.sort(m)) {
            l.add(new GroupSelectionAction(this.model, group));
        }
        return l;
    }

    void cancel() {
        this.model.cancel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if (name == null) {
            return;
        }
        if ("cancelLoading".equals(name)) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                browser.cancel();
            }
        } else if ("popupMenu".equals(name)) {
            Integer c = (Integer)pce.getNewValue();
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                this.view.showPopup(c, browser.getClickComponent(), browser.getClickPoint());
            }
        } else if ("close".equals(name)) {
            Browser browser = (Browser)pce.getNewValue();
            if (browser != null) {
                this.view.removeBrowser(browser);
            }
        } else if ("finderVisible".equals(name)) {
            Boolean b = (Boolean)pce.getNewValue();
            if (!b.booleanValue()) {
                this.model.clearFoundResults();
                this.model.onComponentStateChange(true);
            }
        } else if ("selectedBrowser".equals(name)) {
            Browser b = this.model.getSelectedBrowser();
            for (Browser browser : this.model.getBrowsers().values()) {
                browser.setSelected(browser.equals(b));
            }
        } else if ("selectedTreeNodeDisplay".equals(name)) {
            this.model.onSelectedDisplay();
            this.view.updateMenuItems();
        } else if (!"hierarchyRoot".equals(name)) {
            if ("existingAdd".equals(name)) {
                this.model.addExistingObjects((Set)pce.getNewValue());
            } else if ("userSwitch".equals(name)) {
                Map m = (Map)pce.getNewValue();
                for (Map.Entry entry : m.entrySet()) {
                    Long groupID = (Long)entry.getKey();
                    ExperimenterData d = (ExperimenterData)entry.getValue();
                    this.model.setHierarchyRoot(groupID, d);
                }
            } else if ("noUserSwitch".equals(name)) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("User Selection", "Please select a user first.");
            } else if ("create".equals(name)) {
                DataObject data = (DataObject)pce.getNewValue();
                this.model.createObject(data, true);
            } else if ("createNoParent".equals(name)) {
                DataObject data = (DataObject)pce.getNewValue();
                this.model.createObject(data, false);
            } else if ("onDataSave".equals(name)) {
                Object object = pce.getNewValue();
                if (object != null) {
                    if (object instanceof DataObject) {
                        this.model.onDataObjectSave((DataObject)object, 301);
                    } else {
                        this.model.onDataObjectSave((List)object, 301);
                    }
                }
            } else if ("selectedNodeDisplay".equals(name)) {
                this.model.setSelectedNode(pce.getNewValue());
            } else if ("unselectedNodeDisplay".equals(name)) {
                this.model.setUnselectedNode(pce.getNewValue());
            } else if ("dataObjectCreated".equals(name)) {
                Map map = (Map)pce.getNewValue();
                if (map != null && map.size() == 1) {
                    DataObject data = null;
                    Set set = map.entrySet();
                    Iterator i = set.iterator();
                    DataObject parent = null;
                    if (i.hasNext()) {
                        Map.Entry entry = i.next();
                        data = (DataObject)entry.getKey();
                        Object o = entry.getValue();
                        if (o != null) {
                            parent = (DataObject)o;
                        }
                    }
                    if (parent == null) {
                        this.model.onOrphanDataObjectCreated(data);
                    } else {
                        this.model.onDataObjectSave(data, parent, 300);
                    }
                }
            } else if ("addedToDataObject".equals(name)) {
                this.model.getSelectedBrowser().refreshLoggedExperimenterData();
            } else if ("copyRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                if (data != null) {
                    this.model.copyRndSettings((ImageData)data);
                } else {
                    this.model.copyRndSettings(null);
                }
            } else if ("pasteRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 0, (Collection)data) : new PasteRndSettingsCmd(this.model, 0);
                cmd.execute();
            } else if ("resetRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 1, (Collection)data) : new PasteRndSettingsCmd(this.model, 1);
                cmd.execute();
            } else if ("setOriginalRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 2, (Collection)data) : new PasteRndSettingsCmd(this.model, 2);
                cmd.execute();
            } else if ("setOriginalRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 3, (Collection)data) : new PasteRndSettingsCmd(this.model, 3);
                cmd.execute();
            } else if ("cutItems".equals(name)) {
                CutCmd cmd = new CutCmd(this.model);
                cmd.execute();
            } else if ("copyItems".equals(name)) {
                CopyCmd cmd = new CopyCmd(this.model);
                cmd.execute();
            } else if ("pasteItems".equals(name)) {
                PasteCmd cmd = new PasteCmd(this.model);
                cmd.execute();
            } else if ("removeItems".equals(name)) {
                DeleteCmd cmd = new DeleteCmd(this.model.getSelectedBrowser());
                cmd.execute();
            } else if ("resultsFound".equals(name)) {
                this.model.setSearchResult(pce.getNewValue());
            } else if ("saveGeneric".equals(name)) {
                Object parent = pce.getNewValue();
                if (parent instanceof MetadataViewer) {
                    MetadataViewer mv = (MetadataViewer)parent;
                    mv.saveData();
                }
            } else if ("dataRefreshed".equals(name)) {
                this.model.onSelectedDisplay();
            } else if ("adminUpdated".equals(name)) {
                Object data = pce.getNewValue();
                Map browsers = this.model.getBrowsers();
                Set set = browsers.entrySet();
                for (Map.Entry entry : set) {
                    Browser browser = (Browser)entry.getValue();
                    browser.refreshAdmin(data);
                }
                this.view.createTitle();
            } else if ("tagWizard".equals(name)) {
                this.model.showTagWizard();
            } else if ("createNewExperiment".equals(name)) {
                this.model.openEditorFile(2);
            } else if ("fieldSelected".equals(name)) {
                this.model.setSelectedField(pce.getNewValue());
            } else if ("viewImage".equals(name)) {
                ImageData image = (ImageData)pce.getNewValue();
                EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
                ViewImage evt = new ViewImage((DataObject)image, this.view.getBounds());
                bus.post(evt);
            } else if ("sendFiles".equals(name)) {
                Map files = (Map)pce.getNewValue();
                if (files != null && files.size() > 0) {
                    UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                    un.notifyError("Import failures", "Submit the files to development team", "", files);
                }
            } else if ("fileFormats".equals(name)) {
                this.view.showSupportedFileFormats();
            } else if ("renderThumbnail".equals(name)) {
                long imageID = (Long)pce.getNewValue();
                ArrayList<Long> ids = new ArrayList<Long>(1);
                ids.add(imageID);
                this.view.reloadThumbnails(ids);
            } else if ("applySettings".equals(name)) {
                Object object = pce.getNewValue();
                if (object instanceof ImageData) {
                    this.model.copyRndSettings((ImageData)object);
                    List l = this.model.getSelectedBrowser().getSelectedDataObjects();
                    Collection toUpdate = l.size() > 1 ? l : this.model.getDisplayedImages();
                    if (toUpdate != null) {
                        PasteRndSettingsCmd cmd = new PasteRndSettingsCmd(this.model, 0, toUpdate);
                        cmd.execute();
                    }
                } else if (object instanceof Object[]) {
                    Object[] objects = (Object[])object;
                    WellSampleData wsd = (WellSampleData)objects[0];
                    WellData well = (WellData)objects[1];
                    this.model.copyRndSettings(wsd.getImage());
                    ArrayList<Long> ids = new ArrayList<Long>(1);
                    ids.add(well.getPlate().getId());
                    this.model.pasteRndSettings(ids, PlateData.class);
                }
            } else if ("import".equals(name)) {
                ImportableObject object = (ImportableObject)pce.getNewValue();
                this.model.importFiles(object);
            } else if ("selectedTaskPane".equals(name)) {
                this.handleTaskPaneSelection((JXTaskPane)pce.getNewValue());
            } else if ("generateFigure".equals(name)) {
                TreeImageDisplay[] nodes;
                Object object = pce.getNewValue();
                if (!(object instanceof FigureParam)) {
                    return;
                }
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                IconManager icons = IconManager.getInstance();
                Icon icon = icons.getIcon(107);
                ArrayList<Long> ids = new ArrayList<Long>();
                FigureParam param = (FigureParam)object;
                Collection l = param.isSelectedObjects() ? this.model.getSelectedBrowser().getSelectedDataObjects() : this.model.getDisplayedImages();
                if (l == null) {
                    return;
                }
                Class<?> klass = null;
                Object p = null;
                if (param.getIndex() == 2 && (nodes = this.model.getSelectedBrowser().getSelectedDisplays()) != null && nodes.length > 0) {
                    TreeImageDisplay pNode;
                    TreeImageDisplay node = nodes[0];
                    Object ho = node.getUserObject();
                    if (ho instanceof DatasetData) {
                        klass = ho.getClass();
                        pNode = node.getParentDisplay();
                        if (pNode != null && !((p = pNode.getUserObject()) instanceof ProjectData)) {
                            p = null;
                        }
                    } else if (ho instanceof ImageData) {
                        klass = ho.getClass();
                        pNode = node.getParentDisplay();
                        if (pNode != null && !((p = pNode.getUserObject()) instanceof DatasetData)) {
                            p = null;
                        }
                        if (p == null) {
                            p = ho;
                        }
                    }
                    if (p != null) {
                        param.setAnchor((DataObject)p);
                    }
                }
                Iterator i = l.iterator();
                int n = 0;
                while (i.hasNext()) {
                    DataObject obj = (DataObject)i.next();
                    ids.add(obj.getId());
                    if (n == 0) {
                        p = obj;
                    }
                    ++n;
                }
                if (ids.size() == 0) {
                    return;
                }
                if (param.getIndex() != 2) {
                    param.setAnchor((DataObject)p);
                }
                FigureActivityParam activity = new FigureActivityParam(object, ids, klass, 0);
                activity.setIcon(icon);
                un.notifyActivity(activity);
            } else if ("handleScript".equals(name)) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                ScriptActivityParam p = (ScriptActivityParam)pce.getNewValue();
                int index = p.getIndex();
                ScriptObject script = p.getScript();
                if (index == 3) {
                    Environment env = (Environment)TreeViewerAgent.getRegistry().lookup("/env");
                    String path = env.getOmeroFilesHome();
                    path = path + File.separator + script.getName();
                    File f = new File(path);
                    DownloadActivityParam activity = new DownloadActivityParam(p.getScript().getScriptID(), 0, f, null);
                    activity.setApplicationData(new ApplicationData(""));
                    un.notifyActivity(activity);
                } else if (index == 2) {
                    this.downloadScript(p);
                } else {
                    un.notifyActivity(pce.getNewValue());
                }
            } else if ("cancelImport".equals(name)) {
                this.model.cancelImports();
            } else if ("openDocument".equals(name)) {
                ApplicationData data = (ApplicationData)pce.getNewValue();
                if (data == null) {
                    return;
                }
                String format = this.view.getObjectMimeType();
                if (format == null) {
                    return;
                }
                TreeViewerFactory.register(data, format);
                this.model.openWith(data);
            } else if ("openExternalApplication".equals(name)) {
                this.model.openWith((ApplicationData)pce.getNewValue());
            } else if ("createAdmin".equals(name)) {
                AdminObject object = (AdminObject)pce.getNewValue();
                this.model.administrate(object);
            } else if ("register".equals(name)) {
                this.model.register((DataObjectRegistration)pce.getNewValue());
            } else if ("resetPassword".equals(name)) {
                this.model.resetPassword((String)pce.getNewValue());
            } else if ("uploadScript".equals(name)) {
                TreeViewerAction action = this.getAction(UPLOAD_SCRIPT);
                action.actionPerformed(new ActionEvent(this, 1, ""));
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            switch (browser.getState()) {
                case 14: {
                    this.loadingWindow.setStatus("Loading Data...");
                    UIUtilities.centerAndShow(this.loadingWindow);
                    return;
                }
                case 15: {
                    this.loadingWindow.setVisible(false);
                }
            }
        }
        switch (this.model.getState()) {
            case 2: {
                this.view.closeViewer();
                break;
            }
            case 5: {
                this.view.setStatus("Loading Data...", false);
                this.view.setStatusIcon(true);
                this.view.onStateChanged(false);
                break;
            }
            case 3: {
                this.view.setStatus("Saving Data", false);
                this.view.setStatusIcon(true);
                this.view.onStateChanged(false);
                break;
            }
            case 6: 
            case 7: {
                this.loadingWindow.setVisible(false);
                this.view.setStatus(null, true);
                this.view.setStatusIcon(false);
                this.view.onStateChanged(true);
                this.view.requestFocus();
                break;
            }
            case 8: {
                UIUtilities.centerAndShow(this.loadingWindow);
            }
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.view.refreshRenderer();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }
}

