/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.PopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.StatusBar;
import org.openmicroscopy.shoola.agents.treeviewer.view.TaskPaneBrowser;
import org.openmicroscopy.shoola.agents.treeviewer.view.ToolBar;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinder;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.JXTaskPaneContainerSingle;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeViewerWin
extends TopWindow {
    static final String JXTASKPANE_TYPE = "JXTaskPane";
    private static final double WEIGHT = 0.7;
    private static final String TITLE = "Data Manager";
    private TreeViewerControl controller;
    private TreeViewerModel model;
    private JSplitPane splitPane;
    private JScrollPane workingPane;
    private JSplitPane rightPane;
    private JComponent browsersDisplay;
    private List<JMenuItem> menuItems = new ArrayList<JMenuItem>();
    private ToolBar toolBar;
    private StatusBar statusBar;
    private Rectangle invokerBounds;
    private int displayMode;
    private JScrollPane finderScrollPane;
    private Component leftComponent;
    private Component rightComponent;
    private int dividerLocation;
    private TinyDialog formatDialog;
    private boolean treeVisible;
    private boolean metadataVisible;
    private int dividerRightLocation;
    private JXTaskPane firstPane;
    private JXTaskPaneContainerSingle container;
    private JSplitPane viewerPane;

    private boolean isSPWFirst() {
        Boolean type = (Boolean)TreeViewerAgent.getRegistry().lookup("BrowserSPW");
        if (type == null) {
            return false;
        }
        return type;
    }

    private boolean isBrowserVisible(Browser browser) {
        Component[] comps = this.browsersDisplay.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].equals(browser.getUI())) continue;
            return true;
        }
        return false;
    }

    private void layoutBrowsers() {
        Map browsers = this.model.getBrowsers();
        if (this.getLayoutType().equals(JXTASKPANE_TYPE)) {
            Browser browser;
            this.container = new JXTaskPaneContainerSingle();
            this.container.addPropertyChangeListener(this.controller);
            if (this.isSPWFirst()) {
                browser = (Browser)browsers.get(103);
                TaskPaneBrowser pane = new TaskPaneBrowser(browser);
                this.firstPane = pane;
                this.container.add(pane);
                browser = (Browser)browsers.get(100);
                this.container.add(new TaskPaneBrowser(browser));
            } else {
                browser = (Browser)browsers.get(100);
                TaskPaneBrowser pane = new TaskPaneBrowser(browser);
                this.firstPane = pane;
                this.container.add(pane);
                browser = (Browser)browsers.get(103);
                this.container.add(new TaskPaneBrowser(browser));
            }
            browser = (Browser)browsers.get(104);
            this.container.add(new TaskPaneBrowser(browser));
            browser = (Browser)browsers.get(102);
            this.container.add(new TaskPaneBrowser(browser));
            browser = (Browser)browsers.get(101);
            this.container.add(new TaskPaneBrowser(browser));
            if (this.model.isLeader() || this.model.isAdministrator()) {
                browser = (Browser)browsers.get(107);
                this.container.add(new TaskPaneBrowser(browser));
            }
            AdvancedFinder finder = this.model.getAdvancedFinder();
            finder.addPropertyChangeListener(this.controller);
            this.container.add(new TaskPaneBrowser(finder));
            JScrollPane s = new JScrollPane((Component)((Object)this.container));
            s.setVerticalScrollBarPolicy(21);
            this.browsersDisplay = s;
        } else {
            JTabbedPane tabs = new JTabbedPane(1, 0);
            tabs.setAlignmentX(0.0f);
            Font font = (Font)TreeViewerAgent.getRegistry().lookup("/resources/fonts/Titles");
            tabs.setFont(font);
            tabs.setForeground(UIUtilities.STEELBLUE);
            Browser browser = (Browser)browsers.get(100);
            if (browser.isDisplayed()) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            if ((browser = (Browser)browsers.get(104)).isDisplayed()) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            if ((browser = (Browser)browsers.get(102)).isDisplayed()) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            if ((browser = (Browser)browsers.get(101)).isDisplayed()) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            this.browsersDisplay = tabs;
        }
    }

    private JMenuBar createMenuBar() {
        TaskBar tb = TreeViewerAgent.getRegistry().getTaskBar();
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        menus.add(this.createFileMenu());
        menus.add(this.createEditMenu());
        if (!this.getLayoutType().equals(JXTASKPANE_TYPE)) {
            menus.add(this.createViewMenu());
        }
        JMenuBar bar = tb.getTaskBarMenuBar();
        JMenu[] existingMenus = new JMenu[bar.getMenuCount()];
        for (int i = 0; i < existingMenus.length; ++i) {
            existingMenus[i] = bar.getMenu(i);
        }
        bar.removeAll();
        Iterator k = menus.iterator();
        while (k.hasNext()) {
            bar.add((JMenu)k.next());
        }
        for (int i = 0; i < existingMenus.length; ++i) {
            bar.add(existingMenus[i]);
        }
        return bar;
    }

    private JMenu createNewMenu() {
        JMenu menu = new JMenu("New");
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.CREATE_TOP_PROJECT);
        JMenuItem item = new JMenuItem(a);
        menu.add(item);
        item.setText(a.getActionName());
        a = this.controller.getAction(TreeViewerControl.CREATE_TOP_DATASET);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        menu.add(new JSeparator());
        a = this.controller.getAction(TreeViewerControl.CREATE_TOP_SCREEN);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        menu.add(new JSeparator());
        a = this.controller.getAction(TreeViewerControl.CREATE_TOP_TAG_SET);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        a = this.controller.getAction(TreeViewerControl.CREATE_TOP_TAG);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        return menu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu("View");
        menu.setMnemonic(86);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        Map browsers = this.model.getBrowsers();
        Browser browser = (Browser)browsers.get(100);
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.HIERARCHY_EXPLORER));
        menu.add(item);
        item = new JCheckBoxMenuItem();
        browser = (Browser)browsers.get(104);
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.FILES_EXPLORER));
        menu.add(item);
        item = new JCheckBoxMenuItem();
        browser = (Browser)browsers.get(102);
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.TAGS_EXPLORER));
        menu.add(item);
        item = new JCheckBoxMenuItem();
        browser = (Browser)browsers.get(101);
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.IMAGES_EXPLORER));
        menu.add(item);
        return menu;
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.add(this.createNewMenu());
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.SWITCH_USER);
        JMenuItem item = new JMenuItem(a);
        item.setText(a.getActionName());
        a = this.controller.getAction(TreeViewerControl.EDITOR_NO_SELECTION);
        item = new JMenuItem(a);
        menu.add(item);
        item.setText(a.getActionName());
        menu.add(new JSeparator(0));
        a = this.controller.getAction(TreeViewerControl.BROWSE);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        this.menuItems.add(item);
        menu.add(item);
        a = this.controller.getAction(TreeViewerControl.VIEW);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        this.menuItems.add(item);
        menu.add(item);
        a = this.controller.getAction(TreeViewerControl.REFRESH_TREE);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        menu.add(new JSeparator(0));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.EXIT)));
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.CUT_OBJECT)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.COPY_OBJECT)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.PASTE_OBJECT)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.DELETE_OBJECT)));
        return menu;
    }

    private void initComponents() {
        this.layoutBrowsers();
        this.workingPane = new JScrollPane();
        this.workingPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.workingPane.getViewport().setBackground(UIUtilities.BACKGROUND_COLOR);
        this.viewerPane = new JSplitPane();
        this.viewerPane.setOrientation(0);
        this.viewerPane.setOneTouchExpandable(true);
        this.viewerPane.setContinuousLayout(true);
        this.viewerPane.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    private void buildGUI() {
        this.treeVisible = true;
        this.metadataVisible = true;
        this.rightPane = new JSplitPane();
        this.rightPane.setOrientation(1);
        this.rightPane.setOneTouchExpandable(true);
        this.rightPane.setContinuousLayout(true);
        this.rightPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.rightPane.setLeftComponent(this.workingPane);
        this.rightPane.setRightComponent(this.model.getMetadataViewer().getEditorUI());
        this.rightPane.setResizeWeight(0.7);
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(1);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setLeftComponent(this.browsersDisplay);
        this.splitPane.setRightComponent(this.rightPane);
        this.splitPane.setResizeWeight(0.1);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)this.toolBar, "North");
        c.add((Component)this.splitPane, "Center");
        c.add((Component)this.statusBar, "South");
    }

    TreeViewerWin() {
        super(TITLE);
    }

    void initialize(TreeViewerControl controller, TreeViewerModel model, Rectangle bounds) {
        this.controller = controller;
        this.invokerBounds = bounds;
        this.model = model;
        this.displayMode = 100;
        this.statusBar = new StatusBar(controller);
        this.statusBar.addPropertyChangeListener(controller);
        this.toolBar = new ToolBar(controller, model, this);
        this.initComponents();
        this.setJMenuBar(this.createMenuBar());
        this.buildGUI();
        controller.attachUIListeners(this.browsersDisplay);
        this.createTitle();
    }

    void createTitle() {
        String title = this.model.getExperimenterNames() + "'s ";
        this.setTitle(title + TITLE);
    }

    void selectFirstPane() {
        if (JXTASKPANE_TYPE.equals(this.getLayoutType())) {
            if (this.firstPane != null) {
                this.firstPane.setCollapsed(false);
            }
            if (!UIUtilities.isLinuxOS()) {
                List<JXTaskPane> list = this.container.getTaskPanes();
                for (JXTaskPane pane : list) {
                    pane.setAnimated(true);
                }
            }
        }
    }

    void initializeDisplay() {
        if (this.rightComponent == null) {
            this.rightComponent = new JScrollPane(this.model.getMetadataViewer().getEditorUI());
        }
        if (this.metadataVisible) {
            Component[] components = this.rightPane.getComponents();
            boolean b = false;
            for (int i = 0; i < components.length; ++i) {
                if (components[i] != this.rightComponent) continue;
                b = true;
            }
            if (!b) {
                this.rightPane.setRightComponent(this.rightComponent);
            }
        }
    }

    void selectPane(int browserType) {
        if (JXTASKPANE_TYPE.equals(this.getLayoutType())) {
            List<JXTaskPane> list = this.container.getTaskPanes();
            for (JXTaskPane pane : list) {
                TaskPaneBrowser p;
                Browser b;
                if (!(pane instanceof TaskPaneBrowser) || (b = (p = (TaskPaneBrowser)pane).getBrowser()) == null || b.getBrowserType() != browserType) continue;
                p.setCollapsed(false);
            }
        }
    }

    String getLayoutType() {
        String type = (String)TreeViewerAgent.getRegistry().lookup("BrowserLayout");
        if (type == null) {
            type = "";
        }
        return type;
    }

    void closeViewer() {
        this.setVisible(false);
        this.dispose();
    }

    void addBrowser(Browser browser) {
        if (this.browsersDisplay instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)this.browsersDisplay;
            if (!this.isBrowserVisible(browser)) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            tabs.removeChangeListener(this.controller.getTabbedListener());
            tabs.setSelectedComponent(browser.getUI());
            tabs.addChangeListener(this.controller.getTabbedListener());
        }
    }

    void removeBrowser(Browser browser) {
        if (this.browsersDisplay instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)this.browsersDisplay;
            if (this.isBrowserVisible(browser)) {
                tabs.remove(browser.getUI());
                Component c = tabs.getSelectedComponent();
                if (c == null) {
                    this.model.setSelectedBrowser(null);
                    return;
                }
                Map browsers = this.model.getBrowsers();
                Iterator i = browsers.values().iterator();
                boolean selected = false;
                while (i.hasNext()) {
                    browser = (Browser)i.next();
                    if (!c.equals(browser.getUI())) continue;
                    this.model.setSelectedBrowser(browser);
                    selected = true;
                    break;
                }
                if (!selected) {
                    this.model.setSelectedBrowser(null);
                }
            }
        }
    }

    void showPopup(int index, Component c, Point p) {
        if (c == null) {
            return;
        }
        if (p == null) {
            p = new Point(0, 0);
        }
        switch (index) {
            case 1: 
            case 2: 
            case 7: {
                PopupMenu popupMenu = new PopupMenu(this.controller, index);
                popupMenu.show(c, p.x, p.y);
            }
        }
    }

    void addComponent(JComponent component) {
        if (component == null) {
            return;
        }
        JViewport viewPort = this.workingPane.getViewport();
        component.setPreferredSize(viewPort.getExtentSize());
        viewPort.removeAll();
        viewPort.add(component);
        viewPort.validate();
    }

    void displayViewer(JComponent viewer, JComponent controls, boolean toAdd, boolean toDetach) {
        JViewport viewPort = this.workingPane.getViewport();
        viewPort.removeAll();
        this.viewerPane.removeAll();
        if (toAdd) {
            if (this.model.isFullScreen()) {
                return;
            }
            this.addComponent(viewer);
            DataBrowser db = this.model.getDataViewer();
            int location = this.splitPane.getDividerLocation();
            this.splitPane.removeAll();
            this.splitPane.setLeftComponent(this.browsersDisplay);
            if (db != null) {
                this.viewerPane.setTopComponent(viewer);
                this.viewerPane.setBottomComponent(db.getUI(false));
                this.viewerPane.setResizeWeight(0.7);
                this.splitPane.setRightComponent(this.viewerPane);
            } else {
                this.splitPane.setRightComponent(this.rightPane);
            }
            this.splitPane.setDividerLocation(location);
        }
    }

    void displayBrowser(DataBrowser db) {
        if (db == null) {
            return;
        }
        if (this.model.isFullScreen()) {
            this.addComponent(db.getUI(this.model.isFullScreen()));
        } else {
            this.viewerPane.removeAll();
            this.viewerPane.setBottomComponent(db.getUI(false));
        }
    }

    void removeAllFromWorkingPane() {
        JViewport viewPort = this.workingPane.getViewport();
        viewPort.removeAll();
        viewPort.validate();
        viewPort.repaint();
    }

    void showFinder(boolean b) {
        JSplitPane pane = null;
        if (b) {
            pane = new JSplitPane();
            pane.setOrientation(0);
            pane.setResizeWeight(1.0);
            pane.setOneTouchExpandable(true);
            pane.setContinuousLayout(true);
            pane.setTopComponent(this.splitPane);
            pane.setBottomComponent(this.model.getFinder());
        } else {
            pane = this.splitPane;
        }
        Container c = this.getContentPane();
        c.removeAll();
        c.add((Component)this.toolBar, "North");
        c.add((Component)pane, "Center");
        c.add((Component)this.statusBar, "South");
        c.validate();
    }

    void showAdvancedFinder() {
        if (!this.getLayoutType().equals(JXTASKPANE_TYPE)) {
            if (this.displayMode == 101) {
                this.displayMode = 100;
            } else if (this.displayMode == 100) {
                this.displayMode = 101;
            }
            this.splitPane.setDividerLocation(this.splitPane.getDividerLocation());
            if (this.finderScrollPane == null) {
                AdvancedFinder finder = this.model.getAdvancedFinder();
                finder.addPropertyChangeListener(this.controller);
                this.finderScrollPane = new JScrollPane(finder);
            }
            switch (this.displayMode) {
                case 101: {
                    this.splitPane.remove(this.browsersDisplay);
                    this.splitPane.setLeftComponent(this.finderScrollPane);
                    break;
                }
                case 100: {
                    this.splitPane.remove(this.finderScrollPane);
                    this.splitPane.setLeftComponent(this.browsersDisplay);
                }
            }
        } else if (this.displayMode == 101) {
            this.displayMode = 100;
        } else if (this.displayMode == 100) {
            this.displayMode = 101;
        }
    }

    int getDisplayMode() {
        return this.displayMode;
    }

    void showMenu(int menuID, Component c, Point p) {
        switch (menuID) {
            case 0: {
                this.toolBar.showManagementMenu(c, p);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                this.toolBar.showCreateMenu(c, p, menuID);
                break;
            }
            case 5: {
                this.toolBar.showPersonalMenu(c, p);
            }
        }
    }

    void onStateChanged(boolean b) {
        Map browsers = this.model.getBrowsers();
        if (browsers != null) {
            Iterator i = browsers.keySet().iterator();
            while (i.hasNext()) {
                ((Browser)browsers.get(i.next())).onComponentStateChange(b);
            }
        }
        if (this.container != null) {
            this.container.setExpandable(b);
        }
        this.browsersDisplay.setEnabled(b);
    }

    void setStatus(String text, boolean hide) {
        this.statusBar.setStatus(text);
        this.statusBar.setProgress(hide);
    }

    void setStatusIcon(boolean b) {
        if (b) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.statusBar.setStatusIcon(b);
    }

    void updateMenuItems() {
        for (JMenuItem item : this.menuItems) {
            TreeViewerAction a = (TreeViewerAction)item.getAction();
            item.setText(a.getActionName());
            item.setToolTipText(a.getActionDescription());
        }
    }

    void setInspectorVisibility() {
        if (this.treeVisible) {
            if (this.leftComponent == null) {
                this.leftComponent = this.splitPane.getLeftComponent();
            }
            this.dividerLocation = this.splitPane.getDividerLocation();
            Component[] components = this.splitPane.getComponents();
            if (components != null) {
                boolean b = false;
                for (int i = 0; i < components.length; ++i) {
                    if (components[i] != this.leftComponent) continue;
                    b = true;
                }
                if (b && this.leftComponent != null) {
                    this.splitPane.remove(this.leftComponent);
                }
            }
        } else if (this.leftComponent != null) {
            this.splitPane.add(this.leftComponent);
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
        this.treeVisible = !this.treeVisible;
    }

    void setMetadataVisibility() {
        if (this.rightComponent == null) {
            this.rightComponent = new JScrollPane(this.model.getMetadataViewer().getEditorUI());
        }
        if (this.metadataVisible) {
            Component[] components = this.rightPane.getComponents();
            if (components != null && components.length > 0) {
                boolean b = false;
                for (int i = 0; i < components.length; ++i) {
                    if (components[i] != this.rightComponent) continue;
                    b = true;
                }
                if (b) {
                    this.rightPane.remove(this.rightComponent);
                    this.dividerRightLocation = this.rightPane.getDividerLocation();
                }
            }
        } else if (this.rightComponent != null) {
            this.rightPane.add(this.rightComponent);
            if (this.dividerRightLocation > 0) {
                this.rightPane.setDividerLocation(this.dividerRightLocation);
            } else {
                this.rightPane.setResizeWeight(0.7);
            }
        }
        this.metadataVisible = !this.metadataVisible;
    }

    boolean setImporterVisibility(JComponent importUI, boolean init) {
        if (init) {
            Icon icon = IconManager.getInstance().getIcon(41);
            this.controller.getAction(TreeViewerControl.IMPORTER).putValue("SmallIcon", icon);
        }
        JComponent r = (JComponent)this.rightPane.getRightComponent();
        this.rightPane.remove(r);
        int div = this.rightPane.getDividerLocation();
        boolean visible = false;
        if (r == importUI) {
            this.rightPane.setRightComponent(this.model.getMetadataViewer().getEditorUI());
        } else {
            visible = true;
            this.rightPane.setRightComponent(importUI);
        }
        this.rightPane.setDividerLocation(div);
        return visible;
    }

    boolean isImporterVisible() {
        JComponent r = (JComponent)this.rightPane.getRightComponent();
        return r != this.model.getMetadataViewer().getEditorUI();
    }

    void setImportStatus(String perc, boolean show) {
        this.toolBar.setImportStatus(perc, show);
    }

    void showSupportedFileFormats() {
        if (this.formatDialog == null) {
            List<FileFilter> filters = this.model.getSupportedFormats();
            if (filters == null || filters.size() == 0) {
                return;
            }
            String[] array = new String[filters.size()];
            Iterator<FileFilter> i = filters.iterator();
            int index = 0;
            while (i.hasNext()) {
                FileFilter filter = i.next();
                array[index] = filter.getDescription();
                ++index;
            }
            JList<String> list = new JList<String>(array);
            this.formatDialog = new TinyDialog((Frame)this, (JComponent)new JScrollPane(list), 1);
            this.formatDialog.setFontTitleStyle(1);
            this.formatDialog.setTitle("Supported Formats");
            this.formatDialog.addPropertyChangeListener("closedDialog", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    TreeViewerWin.this.hideAnimation();
                    TreeViewerWin.this.formatDialog = null;
                }
            });
            this.formatDialog.pack();
        }
        Point p = new Point(0, 2 * this.statusBar.getPreferredSize().height);
        this.showJDialogAsSheet(this.formatDialog, p, 1);
    }

    void reloadThumbnails(List<Long> ids) {
        this.model.reloadThumbnails(ids);
    }

    void onActivityTerminated(ActivityComponent activity) {
        TinyDialog d = new TinyDialog((Frame)this, activity.getActivityType(), 1);
        d.getContentPane().setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        d.addPropertyChangeListener("closedDialog", this.controller);
        d.pack();
        Point p = new Point(0, 2 * this.statusBar.getPreferredSize().height);
        this.setCloseAfter(true);
        this.showJDialogAsSheet(d, p, 2);
    }

    void refreshRenderer() {
        this.model.refreshRenderer();
    }

    String getObjectMimeType() {
        return this.model.getObjectMimeType();
    }

    @Override
    public void setOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(8 * (screenSize.width / 10), 8 * (screenSize.height / 10));
        UIUtilities.incrementRelativeToAndShow(this.invokerBounds, this);
        this.invokerBounds = null;
    }
}

