/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.Color;
import java.awt.Font;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import omero.RDouble;
import omero.model.PlaneInfo;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.util.filter.file.CppFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.filter.file.JavaFilter;
import org.openmicroscopy.shoola.util.filter.file.MatlabFilter;
import org.openmicroscopy.shoola.util.filter.file.PythonFilter;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMEComboBoxUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelAcquisitionData;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.DetectorData;
import pojos.DichroicData;
import pojos.ExperimenterData;
import pojos.FilterData;
import pojos.FilterSetData;
import pojos.ImageAcquisitionData;
import pojos.ImageData;
import pojos.InstrumentData;
import pojos.LightSourceData;
import pojos.ObjectiveData;
import pojos.PermissionData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.WellData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorUtil {
    public static final int DEFAULT_SCALE = 5;
    public static final String DATE_NOT_AVAILABLE = "Not available";
    public static final String DEFAULT_GROUP = "Current Group";
    public static final String MANDATORY_SYMBOL = " *";
    public static final String MANDATORY_DESCRIPTION = "* indicates the required fields.";
    public static final String GROUP_OWNER = "Group's owner";
    public static final String ADMINISTRATOR = "Administrator";
    public static final String ACTIVE = "Active";
    public static final String DISPLAY_NAME = "Login Name";
    public static final String LAST_NAME = "Last Name";
    public static final String FIRST_NAME = "First Name";
    public static final String MIDDLE_NAME = "Middle Name";
    public static final String INSTITUTION = "Institution";
    public static final String OWNER = "Owner: ";
    public static final String GROUP = "Group: ";
    public static final String WORLD = "Others: ";
    public static final String READ = "Read";
    public static final String WRITE = "Write";
    public static final String PUBLIC = "Public";
    public static final String GROUP_VISIBLE = "Collaborative";
    public static final String GROUP_DESCRIPTION = "Visible to members of the Group only.";
    public static final String PRIVATE = "Private";
    public static final String GROUPS = "Belongs to the following groups: ";
    public static final String EMAIL = "E-mail";
    public static final String MICRONS_NO_BRACKET = "\u00b5m";
    public static final String MICRONS = "(\u00b5m)";
    public static final String CELCIUS = "(\u2103)";
    public static final String PERCENT = "(%)";
    public static final String MILLIBARS = "(mb)";
    public static final String SIZE_X = "Size X";
    public static final String SIZE_Y = "Size Y";
    public static final String PIXEL_SIZE_X = "Pixel size X (\u00b5m)";
    public static final String PIXEL_SIZE_Y = "Pixel size Y (\u00b5m)";
    public static final String PIXEL_SIZE_Z = "Pixel size Z (\u00b5m)";
    public static final String SECTIONS = "Number of sections";
    public static final String TIMEPOINTS = "Number of timepoints";
    public static final String PIXEL_TYPE = "Pixel Type";
    public static final String NAME = "Name";
    public static final String ACQUISITION_DATE = "Acquisition date";
    public static final String EMISSION = "Emission";
    public static final String EXCITATION = "Excitation";
    public static final String PIN_HOLE_SIZE = "Pinhole size (\u00b5m)";
    public static final String ND_FILTER = "NDFilter (%)";
    public static final String FLUOR = "Fluor";
    public static final String ILLUMINATION = "Illumination";
    public static final String CONTRAST_METHOD = "Contrast Method";
    public static final String MODE = "Mode";
    public static final String POCKEL_CELL_SETTINGS = "Pockel Cell";
    public static final String NOMINAL_MAGNIFICATION = "Nominal Magnification";
    public static final String CALIBRATED_MAGNIFICATION = "Calibrated Magnification";
    public static final String LENSNA = "Lens NA";
    public static final String WORKING_DISTANCE = "Working Distance";
    public static final String IMMERSION = "Immersion";
    public static final String CORRECTION = "Correction";
    public static final String CORRECTION_COLLAR = "Correction Collar";
    public static final String MEDIUM = "Medium";
    public static final String REFRACTIVE_INDEX = "Refractive index";
    public static final String TEMPERATURE = "Temperature (\u2103)";
    public static final String AIR_PRESSURE = "Air Pressure (mb)";
    public static final String HUMIDITY = "Humidy (%)";
    public static final String CO2_PERCENT = "CO2 Percent (%)";
    public static final String MODEL = "Model";
    public static final String MANUFACTURER = "Manufacturer";
    public static final String SERIAL_NUMBER = "Serial Number";
    public static final String LOT_NUMBER = "Lot Number";
    public static final String POSITION_X = "Position X";
    public static final String POSITION_Y = "Position Y";
    public static final String POSITION_Z = "Position Z";
    public static final String TYPE = "Type";
    public static final String VOLTAGE = "Voltage";
    public static final String GAIN = "Gain";
    public static final String OFFSET = "Offset";
    public static final String READ_OUT_RATE = "Read out rate";
    public static final String BINNING = "Binning";
    public static final String AMPLIFICATION = "Amplification Gain";
    public static final String ZOOM = "Zoom";
    public static final String EXPOSURE_TIME = "Exposure Time";
    public static final String DELTA_T = "DeltaT";
    public static final String POWER = "Power";
    public static final String LIGHT_TYPE = "Light";
    public static final String TUNEABLE = "Tuneable";
    public static final String PULSE = "Pulse";
    public static final String POCKEL_CELL = "PockelCell";
    public static final String REPETITION_RATE = "Repetition Rate (Hz)";
    public static final String PUMP = "Pump";
    public static final String WAVELENGTH = "Wavelength";
    public static final String FREQUENCY_MULTIPLICATION = "Frequency Multiplication";
    public static final String IRIS = "Iris";
    public static final String NOT_SET = "NotSet";
    public static final Map<String, String> PIXELS_TYPE_DESCRIPTION;
    public static final Map<String, String> PIXELS_TYPE;
    public static final String FILTER = "Filter";
    public static final String FILTER_WHEEL = "FilterWheel";
    public static final String TRANSMITTANCE = "Transmittance";
    public static final String CUT_IN = "Cut In";
    public static final String CUT_IN_TOLERANCE = "Cut In Tolerance";
    public static final String CUT_OUT = "Cut Out";
    public static final String CUT_OUT_TOLERANCE = "Cut Out Tolerance";
    public static final String ATTENUATION = "Attenuation (%)";
    public static final int MAX_FIELDS_DETECTOR_AND_SETTINGS = 12;
    public static final int MAX_FIELDS_DETECTOR = 10;
    public static final int MAX_FIELDS_FILTER = 11;
    public static final int MAX_FIELDS_OBJECTIVE_AND_SETTINGS = 14;
    public static final int MAX_FIELDS_OBJECTIVE = 11;
    public static final int MAX_FIELDS_LASER = 14;
    public static final int MAX_FIELDS_LIGHT = 7;
    public static final int MAX_FIELDS_LIGHT_AND_SETTINGS = 9;
    public static final int MAX_FIELDS_LASER_AND_SETTINGS = 15;
    public static final int MAX_FIELDS_DICHROIC = 4;
    public static final int MAX_FIELDS_CHANNEL = 10;
    public static final int MAX_FIELDS_STAGE_LABEL = 4;
    public static final int MAX_FIELDS_ENVIRONMENT = 4;
    public static final int MAX_FIELDS_MICROSCOPE = 5;
    public static final int MAX_FIELDS_PLANE_INFO = 5;
    public static final String TIME_UNIT = "s";
    private static final Color INDIGO;
    private static final Color VIOLET;
    private static final int PERCENT_FRACTION = 100;
    public static final Map<Color, String> COLORS_BAR;
    public static final List<CustomizedFileFilter> SCRIPTS_FILTERS;
    private static final EditorFileFilter editorFilter;

    private static double roundValue(double v) {
        if (v <= 0.0) {
            return UIUtilities.roundTwoDecimals(v);
        }
        int decimal = UIUtilities.findDecimal(v, 1);
        if (decimal <= 2) {
            return UIUtilities.roundTwoDecimals(v);
        }
        return UIUtilities.ceil(v, decimal + 1);
    }

    public static Map<String, String> transformExperimenterData(ExperimenterData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(2);
        if (data == null) {
            details.put(OWNER, "");
            details.put(EMAIL, "");
        } else {
            try {
                details.put(OWNER, data.getFirstName() + " " + data.getLastName());
                details.put(EMAIL, data.getEmail());
            }
            catch (Exception e) {
                details.put(OWNER, "");
                details.put(EMAIL, "");
            }
        }
        return details;
    }

    public static Map<String, String> transformPixelsData(PixelsData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(9);
        if (data == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
        } else {
            details.put(SIZE_X, "" + data.getSizeX());
            details.put(SIZE_Y, "" + data.getSizeY());
            details.put(SECTIONS, "" + data.getSizeZ());
            details.put(TIMEPOINTS, "" + data.getSizeT());
            try {
                details.put(PIXEL_SIZE_X, "" + data.getPixelSizeX());
                details.put(PIXEL_SIZE_Y, "" + data.getPixelSizeY());
                details.put(PIXEL_SIZE_Z, "" + data.getPixelSizeZ());
                details.put(PIXEL_TYPE, PIXELS_TYPE_DESCRIPTION.get("" + data.getPixelType()));
            }
            catch (Exception e) {
                details.put(PIXEL_SIZE_X, "");
                details.put(PIXEL_SIZE_Y, "");
                details.put(PIXEL_SIZE_Z, "");
                details.put(PIXEL_TYPE, "");
            }
        }
        details.put("Emission Wavelengths", "");
        return details;
    }

    public static Map<String, String> transformImageData(ImageData image) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(10);
        if (image == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
            details.put("Emission Wavelengths", "");
            details.put(ACQUISITION_DATE, DATE_NOT_AVAILABLE);
            return details;
        }
        PixelsData data = image.getDefaultPixels();
        if (data == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            details.put(SIZE_X, "" + data.getSizeX());
            details.put(SIZE_Y, "" + data.getSizeY());
            details.put(SECTIONS, "" + data.getSizeZ());
            details.put(TIMEPOINTS, "" + data.getSizeT());
            try {
                details.put(PIXEL_SIZE_X, nf.format(data.getPixelSizeX()));
                details.put(PIXEL_SIZE_Y, nf.format(data.getPixelSizeY()));
                details.put(PIXEL_SIZE_Z, nf.format(data.getPixelSizeZ()));
                details.put(PIXEL_TYPE, PIXELS_TYPE_DESCRIPTION.get("" + data.getPixelType()));
            }
            catch (Exception e) {
                details.put(PIXEL_SIZE_X, "");
                details.put(PIXEL_SIZE_Y, "");
                details.put(PIXEL_SIZE_Z, "");
                details.put(PIXEL_TYPE, "");
            }
        }
        details.put("Emission Wavelengths", "");
        Timestamp date = EditorUtil.getAcquisitionTime(image);
        if (date == null) {
            details.put(ACQUISITION_DATE, DATE_NOT_AVAILABLE);
        } else {
            details.put(ACQUISITION_DATE, UIUtilities.formatTime(date));
        }
        return details;
    }

    public static Timestamp getAcquisitionTime(ImageData image) {
        if (image == null) {
            return null;
        }
        Timestamp date = null;
        try {
            date = image.getAcquisitionDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static String formatExperimenter(ExperimenterData exp) {
        if (exp == null) {
            return "";
        }
        return exp.getFirstName() + " " + exp.getLastName();
    }

    public static Map<String, String> convertExperimenter(ExperimenterData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(3);
        if (data == null) {
            details.put(FIRST_NAME, "");
            details.put(MIDDLE_NAME, "");
            details.put(LAST_NAME, "");
            details.put(EMAIL, "");
            details.put(INSTITUTION, "");
        } else {
            try {
                details.put(FIRST_NAME, data.getFirstName());
            }
            catch (Exception e) {
                details.put(FIRST_NAME, "");
            }
            try {
                details.put(MIDDLE_NAME, data.getMiddleName());
            }
            catch (Exception e) {
                details.put(MIDDLE_NAME, "");
            }
            try {
                details.put(LAST_NAME, data.getLastName());
            }
            catch (Exception e) {
                details.put(LAST_NAME, "");
            }
            try {
                details.put(EMAIL, data.getEmail());
            }
            catch (Exception e) {
                details.put(EMAIL, "");
            }
            try {
                details.put(INSTITUTION, data.getInstitution());
            }
            catch (Exception e) {
                details.put(INSTITUTION, "");
            }
        }
        return details;
    }

    public static boolean isAnnotated(Object object) {
        if (object == null) {
            return false;
        }
        Map counts = null;
        if (object instanceof DatasetData) {
            counts = ((DatasetData)object).getAnnotationsCounts();
        } else if (object instanceof ProjectData) {
            counts = ((ProjectData)object).getAnnotationsCounts();
        } else {
            if (object instanceof ImageData) {
                counts = ((ImageData)object).getAnnotationsCounts();
                if (counts == null || counts.size() <= 0) {
                    return false;
                }
                Iterator i = counts.entrySet().iterator();
                long value = 0L;
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    value = (Long)entry.getValue();
                }
                return (value -= 2L) > 0L;
            }
            if (object instanceof ScreenData) {
                counts = ((ScreenData)object).getAnnotationsCounts();
            } else if (object instanceof PlateData) {
                counts = ((PlateData)object).getAnnotationsCounts();
            } else if (object instanceof WellData) {
                counts = ((WellData)object).getAnnotationsCounts();
            }
        }
        return counts != null && counts.size() > 0;
    }

    public static boolean isAnnotatedByCurrentUser(Object object, long userID) {
        if (object == null) {
            return false;
        }
        Map counts = null;
        if (object instanceof DatasetData) {
            counts = ((DatasetData)object).getAnnotationsCounts();
        } else if (object instanceof ProjectData) {
            counts = ((ProjectData)object).getAnnotationsCounts();
        } else if (object instanceof ImageData) {
            counts = ((ImageData)object).getAnnotationsCounts();
        } else if (object instanceof ScreenData) {
            counts = ((ScreenData)object).getAnnotationsCounts();
        } else if (object instanceof PlateData) {
            counts = ((PlateData)object).getAnnotationsCounts();
        } else if (object instanceof WellData) {
            counts = ((WellData)object).getAnnotationsCounts();
        }
        if (counts == null || counts.size() == 0) {
            return false;
        }
        return counts.keySet().contains(userID);
    }

    public static boolean isAnnotatedByOtherUser(Object object, long userID) {
        if (object == null) {
            return false;
        }
        Map counts = null;
        if (object instanceof ImageData) {
            counts = ((ImageData)object).getAnnotationsCounts();
        } else if (object instanceof DatasetData) {
            counts = ((DatasetData)object).getAnnotationsCounts();
        } else if (object instanceof ProjectData) {
            counts = ((ProjectData)object).getAnnotationsCounts();
        } else if (object instanceof ScreenData) {
            counts = ((ScreenData)object).getAnnotationsCounts();
        } else if (object instanceof PlateData) {
            counts = ((PlateData)object).getAnnotationsCounts();
        } else if (object instanceof WellData) {
            counts = ((WellData)object).getAnnotationsCounts();
        }
        if (counts == null || counts.size() == 0) {
            return false;
        }
        Set set = counts.keySet();
        if (set.size() > 1) {
            return true;
        }
        return !set.contains(userID);
    }

    public static String getPartialName(String originalName) {
        return UIUtilities.getPartialName(originalName);
    }

    public static final String getObjectName(String originalName) {
        int n;
        if (originalName == null) {
            return null;
        }
        String[] l = UIUtilities.splitString(originalName);
        if (l != null && (n = l.length) > 0) {
            return l[n - 1];
        }
        return originalName;
    }

    public static boolean isReadable(Object ho, long userID, long groupID) {
        if (ho == null || ho instanceof ExperimenterData || ho instanceof String) {
            return false;
        }
        if (!(ho instanceof DataObject)) {
            return false;
        }
        DataObject data = (DataObject)ho;
        PermissionData permissions = data.getPermissions();
        if (userID == data.getOwner().getId()) {
            return permissions.isUserRead();
        }
        return permissions.isGroupRead();
    }

    public static boolean isUserOwner(Object ho, long userID) {
        if (ho == null || ho instanceof ExperimenterData || ho instanceof String) {
            return false;
        }
        if (!(ho instanceof DataObject)) {
            return false;
        }
        DataObject data = (DataObject)ho;
        PermissionData permissions = data.getPermissions();
        try {
            if (userID == data.getOwner().getId()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Map<String, Object> transformChannelData(ChannelData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(10);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(NAME, "");
        details.put(EXCITATION, 0);
        details.put(EMISSION, 0);
        details.put(ND_FILTER, Float.valueOf(0.0f));
        details.put(PIN_HOLE_SIZE, Float.valueOf(0.0f));
        details.put(FLUOR, "");
        details.put(ILLUMINATION, "");
        details.put(CONTRAST_METHOD, "");
        details.put(MODE, "");
        details.put(POCKEL_CELL_SETTINGS, 0);
        if (data == null) {
            notSet.add(NAME);
            notSet.add(EMISSION);
            notSet.add(EXCITATION);
            notSet.add(ND_FILTER);
            notSet.add(PIN_HOLE_SIZE);
            notSet.add(FLUOR);
            notSet.add(ILLUMINATION);
            notSet.add(CONTRAST_METHOD);
            notSet.add(MODE);
            notSet.add(POCKEL_CELL_SETTINGS);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getName();
        if (s == null || s.trim().length() == 0) {
            notSet.add(NAME);
        }
        details.put(NAME, s);
        int i = data.getEmissionWavelength();
        if (i <= 100) {
            i = 0;
            notSet.add(EMISSION);
        }
        details.put(EMISSION, i);
        i = data.getExcitationWavelength();
        if (i <= 100) {
            i = 0;
            notSet.add(EXCITATION);
        }
        details.put(EXCITATION, i);
        double f = data.getNDFilter();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(ND_FILTER);
        }
        details.put(ND_FILTER, f * 100.0);
        f = data.getPinholeSize();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(PIN_HOLE_SIZE);
        }
        details.put(PIN_HOLE_SIZE, f);
        s = data.getFluor();
        if (s == null || s.trim().length() == 0) {
            notSet.add(FLUOR);
        }
        details.put(FLUOR, s);
        s = data.getIllumination();
        if (s == null || s.trim().length() == 0) {
            notSet.add(ILLUMINATION);
        }
        details.put(ILLUMINATION, s);
        s = data.getContrastMethod();
        if (s == null || s.trim().length() == 0) {
            notSet.add(CONTRAST_METHOD);
        }
        details.put(CONTRAST_METHOD, s);
        s = data.getMode();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODE);
        }
        details.put(MODE, s);
        i = data.getPockelCell();
        if (i < 0) {
            i = 0;
            notSet.add(POCKEL_CELL_SETTINGS);
        }
        details.put(POCKEL_CELL_SETTINGS, i);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformDichroic(DichroicData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformMicroscope(InstrumentData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(TYPE, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(TYPE);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getMicroscopeModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getMicroscopeManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getMicroscopeSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getMicroscopeLotNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        s = data.getMicroscopeType();
        if (s == null || s.trim().length() == 0) {
            notSet.add(TYPE);
        }
        details.put(TYPE, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformObjective(ObjectiveData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(NOMINAL_MAGNIFICATION, 0);
        details.put(CALIBRATED_MAGNIFICATION, Float.valueOf(0.0f));
        details.put(LENSNA, new Float(0.0f));
        details.put(IMMERSION, "");
        details.put(CORRECTION, "");
        details.put(WORKING_DISTANCE, Float.valueOf(0.0f));
        details.put(IRIS, null);
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(NOMINAL_MAGNIFICATION);
            notSet.add(CALIBRATED_MAGNIFICATION);
            notSet.add(LENSNA);
            notSet.add(IMMERSION);
            notSet.add(CORRECTION);
            notSet.add(WORKING_DISTANCE);
            notSet.add(IRIS);
            details.put(NOT_SET, notSet);
            return details;
        }
        Object o = data.hasIris();
        if (o == null) {
            notSet.add(IRIS);
        }
        details.put(IRIS, o);
        String s = data.getModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        int i = data.getNominalMagnification();
        if (i < 0) {
            i = 0;
            notSet.add(NOMINAL_MAGNIFICATION);
        }
        details.put(NOMINAL_MAGNIFICATION, i);
        System.err.println("NM:" + details.get(NOMINAL_MAGNIFICATION));
        double f = data.getCalibratedMagnification();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(CALIBRATED_MAGNIFICATION);
        }
        details.put(CALIBRATED_MAGNIFICATION, f);
        f = data.getLensNA();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(LENSNA);
        }
        details.put(LENSNA, f);
        s = data.getImmersion();
        if (s == null || s.trim().length() == 0) {
            notSet.add(IMMERSION);
        }
        details.put(IMMERSION, s);
        s = data.getCorrection();
        if (s == null || s.trim().length() == 0) {
            notSet.add(CORRECTION);
        }
        details.put(CORRECTION, s);
        f = data.getWorkingDistance();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(WORKING_DISTANCE);
        }
        details.put(WORKING_DISTANCE, f);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformObjectiveAndSettings(ImageAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(9);
        Map<String, Object> m = data == null ? EditorUtil.transformObjective(null) : EditorUtil.transformObjective(data.getObjective());
        List notSet = (List)m.get(NOT_SET);
        m.remove(NOT_SET);
        details.putAll(m);
        details.put(CORRECTION_COLLAR, Float.valueOf(0.0f));
        details.put(MEDIUM, "");
        details.put(REFRACTIVE_INDEX, Float.valueOf(0.0f));
        details.put(IRIS, null);
        if (data == null) {
            notSet.add(CORRECTION_COLLAR);
            notSet.add(MEDIUM);
            notSet.add(REFRACTIVE_INDEX);
            details.put(NOT_SET, notSet);
            return details;
        }
        double f = data.getCorrectionCollar();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(CORRECTION_COLLAR);
        }
        details.put(CORRECTION_COLLAR, f);
        String s = data.getMedium();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MEDIUM);
        }
        details.put(MEDIUM, s);
        f = data.getRefractiveIndex();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(REFRACTIVE_INDEX);
        }
        details.put(REFRACTIVE_INDEX, f);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformImageEnvironment(ImageAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(4);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(TEMPERATURE, new Double(0.0));
        details.put(AIR_PRESSURE, new Double(0.0));
        details.put(HUMIDITY, new Double(0.0));
        details.put(CO2_PERCENT, new Double(0.0));
        if (data == null) {
            notSet.add(TEMPERATURE);
            notSet.add(AIR_PRESSURE);
            notSet.add(HUMIDITY);
            notSet.add(CO2_PERCENT);
            details.put(NOT_SET, notSet);
            return details;
        }
        Object o = data.getTemperature();
        double f = 0.0;
        if (o == null) {
            notSet.add(TEMPERATURE);
        } else {
            f = (Double)o;
        }
        details.put(TEMPERATURE, f);
        f = data.getAirPressure();
        if (f < 0.0) {
            notSet.add(AIR_PRESSURE);
            f = 0.0;
        }
        details.put(AIR_PRESSURE, f);
        f = data.getHumidity();
        if (f < 0.0) {
            notSet.add(HUMIDITY);
            f = 0.0;
        }
        details.put(HUMIDITY, f * 100.0);
        f = data.getCo2Percent();
        if (f < 0.0) {
            notSet.add(CO2_PERCENT);
            f = 0.0;
        }
        details.put(CO2_PERCENT, f * 100.0);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformStageLabel(ImageAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(4);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(NAME, "");
        details.put(POSITION_X, new Double(0.0));
        details.put(POSITION_Y, new Double(0.0));
        details.put(POSITION_Z, new Double(0.0));
        if (data == null) {
            notSet.add(NAME);
            notSet.add(POSITION_X);
            notSet.add(POSITION_Y);
            notSet.add(POSITION_Z);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getLabelName();
        if (s == null || s.trim().length() == 0) {
            notSet.add(NAME);
        }
        details.put(NAME, s);
        Object o = data.getPositionX();
        double f = 0.0;
        if (o == null) {
            notSet.add(POSITION_X);
        } else {
            f = (Double)o;
        }
        details.put(POSITION_X, f);
        f = 0.0;
        if (o == null) {
            notSet.add(POSITION_Y);
        } else {
            f = (Double)o;
        }
        details.put(POSITION_Y, f);
        f = 0.0;
        if (o == null) {
            notSet.add(POSITION_Z);
        } else {
            f = (Double)o;
        }
        details.put(POSITION_Z, f);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformFilterSetManufacturer(FilterSetData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformFilter(FilterData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(TYPE, "");
        details.put(FILTER_WHEEL, "");
        details.put(CUT_IN, "");
        details.put(CUT_OUT, "");
        details.put(CUT_IN_TOLERANCE, "");
        details.put(CUT_OUT_TOLERANCE, "");
        details.put(TRANSMITTANCE, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(TYPE);
            notSet.add(FILTER_WHEEL);
            notSet.add(CUT_IN);
            notSet.add(CUT_OUT);
            notSet.add(CUT_IN_TOLERANCE);
            notSet.add(CUT_OUT_TOLERANCE);
            notSet.add(TRANSMITTANCE);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        s = data.getType();
        if (s == null || s.trim().length() == 0) {
            notSet.add(TYPE);
        }
        details.put(TYPE, s);
        s = data.getFilterWheel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(FILTER_WHEEL);
        }
        details.put(FILTER_WHEEL, s);
        Integer v = data.getCutIn();
        int i = 0;
        if (v == null) {
            notSet.add(CUT_IN);
        } else {
            i = v;
        }
        details.put(CUT_IN, i);
        v = data.getCutOut();
        if (v == null) {
            notSet.add(CUT_OUT);
            i = 0;
        } else {
            i = v;
        }
        details.put(CUT_OUT, i);
        v = data.getCutInTolerance();
        if (v == null) {
            i = 0;
            notSet.add(CUT_IN_TOLERANCE);
        } else {
            i = v;
        }
        details.put(CUT_IN_TOLERANCE, i);
        v = data.getCutOutTolerance();
        if (v == null) {
            i = 0;
            notSet.add(CUT_OUT_TOLERANCE);
        } else {
            i = v;
        }
        details.put(CUT_OUT_TOLERANCE, i);
        Double d = data.getTransmittance();
        double dv = 0.0;
        if (d == null) {
            notSet.add(TRANSMITTANCE);
        } else {
            dv = d;
        }
        details.put(TRANSMITTANCE, dv);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformLightSourceAndSetting(ChannelAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        Map<String, Object> m = data == null ? EditorUtil.transformLightSource(null) : EditorUtil.transformLightSource(data.getLightSource());
        List notSet = (List)m.get(NOT_SET);
        m.remove(NOT_SET);
        details.putAll(m);
        details.put(ATTENUATION, new Double(0.0));
        if (data == null) {
            details.put(WAVELENGTH, new Integer(0));
            notSet.add(ATTENUATION);
            notSet.add(WAVELENGTH);
            details.put(NOT_SET, notSet);
            return details;
        }
        Double f = data.getLigthSettingsAttenuation();
        double v = 0.0;
        if (f == null) {
            notSet.add(ATTENUATION);
        } else {
            v = f;
        }
        details.put(ATTENUATION, v * 100.0);
        Integer i = data.getLigthSettingsWavelength();
        if (details.containsKey(WAVELENGTH)) {
            if (i != null) {
                details.put(WAVELENGTH, i);
            }
        } else {
            int vi = 0;
            if (i == null) {
                notSet.add(WAVELENGTH);
            } else {
                vi = i;
            }
            details.put(WAVELENGTH, vi);
        }
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformLightSource(LightSourceData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(LIGHT_TYPE, "");
        details.put(POWER, new Double(0.0));
        details.put(TYPE, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(LIGHT_TYPE);
            notSet.add(POWER);
            notSet.add(TYPE);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getLightSourceModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        s = data.getKind();
        details.put(LIGHT_TYPE, s);
        double f = data.getPower();
        if (f < 0.0) {
            notSet.add(POWER);
            f = 0.0;
        }
        details.put(POWER, f);
        s = data.getType();
        if (s == null || s.trim().length() == 0) {
            notSet.add(TYPE);
        }
        details.put(TYPE, s);
        s = data.getKind();
        if (LightSourceData.LASER.equals(s)) {
            s = data.getLaserMedium();
            if (s == null || s.trim().length() == 0) {
                notSet.add(MEDIUM);
            }
            details.put(MEDIUM, s);
            int i = data.getLaserWavelength();
            if (i < 0) {
                i = 0;
                notSet.add(WAVELENGTH);
            }
            details.put(WAVELENGTH, i);
            i = data.getLaserFrequencyMultiplication();
            if (i < 0) {
                i = 0;
                notSet.add(FREQUENCY_MULTIPLICATION);
            }
            details.put(FREQUENCY_MULTIPLICATION, i);
            Object o = data.getLaserTuneable();
            if (o == null) {
                notSet.add(TUNEABLE);
            }
            details.put(TUNEABLE, o);
            s = data.getLaserPulse();
            if (s == null || s.trim().length() == 0) {
                notSet.add(PULSE);
            }
            details.put(PULSE, s);
            f = data.getLaserRepetitionRate();
            if (f < 0.0) {
                f = 0.0;
                notSet.add(REPETITION_RATE);
            }
            details.put(REPETITION_RATE, f);
            o = data.getLaserPockelCell();
            if (o == null) {
                notSet.add(POCKEL_CELL);
            }
            details.put(POCKEL_CELL, o);
        }
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformDetector(DetectorData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LOT_NUMBER, "");
        details.put(TYPE, "");
        details.put(GAIN, new Double(0.0));
        details.put(VOLTAGE, new Double(0.0));
        details.put(OFFSET, new Double(0.0));
        details.put(ZOOM, new Double(0.0));
        details.put(AMPLIFICATION, "");
        ArrayList<String> notSet = new ArrayList<String>();
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LOT_NUMBER);
            notSet.add(GAIN);
            notSet.add(VOLTAGE);
            notSet.add(ZOOM);
            notSet.add(AMPLIFICATION);
            notSet.add(TYPE);
            notSet.add(OFFSET);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLotNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(LOT_NUMBER);
        }
        details.put(LOT_NUMBER, s);
        Double f = data.getGain();
        double v = 0.0;
        if (f == null) {
            notSet.add(GAIN);
        } else {
            v = f;
        }
        details.put(GAIN, v);
        f = data.getVoltage();
        if (f == null) {
            v = 0.0;
            notSet.add(VOLTAGE);
        } else {
            v = f;
        }
        details.put(VOLTAGE, v);
        f = data.getOffset();
        if (f == null) {
            v = 0.0;
            notSet.add(OFFSET);
        } else {
            v = f;
        }
        details.put(OFFSET, v);
        f = data.getZoom();
        if (f == null) {
            v = 0.0;
            notSet.add(ZOOM);
        } else {
            v = f;
        }
        details.put(ZOOM, v);
        f = data.getAmplificationGain();
        if (f == null) {
            v = 0.0;
            notSet.add(AMPLIFICATION);
        } else {
            v = f;
        }
        details.put(AMPLIFICATION, v);
        s = data.getType();
        if (s == null || s.trim().length() == 0) {
            notSet.add(TYPE);
        }
        details.put(TYPE, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformDetectorAndSettings(ChannelAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(11);
        Map<String, Object> m = data == null ? EditorUtil.transformDetector(null) : EditorUtil.transformDetector(data.getDetector());
        List notSet = (List)m.get(NOT_SET);
        m.remove(NOT_SET);
        details.putAll(m);
        details.put(READ_OUT_RATE, new Double(0.0));
        details.put(BINNING, "");
        if (data == null) {
            notSet.add(READ_OUT_RATE);
            notSet.add(BINNING);
            details.put(NOT_SET, notSet);
            return details;
        }
        Double f = data.getDetectorSettingsGain();
        if (f != null) {
            details.put(GAIN, f);
            notSet.remove(GAIN);
        }
        if ((f = data.getDetectorSettingsVoltage()) != null) {
            notSet.remove(VOLTAGE);
            details.put(VOLTAGE, UIUtilities.roundTwoDecimals(f));
        }
        if ((f = data.getDetectorSettingsOffset()) != null) {
            notSet.remove(OFFSET);
            details.put(OFFSET, UIUtilities.roundTwoDecimals(f));
        }
        f = data.getDetectorSettingsReadOutRate();
        double v = 0.0;
        if (f == null) {
            v = 0.0;
            notSet.add(READ_OUT_RATE);
        } else {
            v = UIUtilities.roundTwoDecimals(f);
        }
        details.put(READ_OUT_RATE, v);
        String s = data.getDetectorSettingsBinning();
        if (s == null || s.trim().length() == 0) {
            notSet.add(BINNING);
        }
        details.put(BINNING, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static String formatTimeInSeconds(Double value) {
        int v = value.intValue();
        int hours = v / 3600;
        int remainder = v % 3600;
        int minutes = remainder / 60;
        int seconds = remainder % 60;
        String text = "";
        if (hours > 0) {
            text = text + hours + "h";
        }
        if (minutes > 0) {
            text = text + minutes + "min";
            if (seconds > 0) {
                text = text + seconds + TIME_UNIT;
            }
        } else {
            text = text + seconds + TIME_UNIT;
        }
        return text;
    }

    public static Map<String, Object> transformPlaneInfo(PlaneInfo plane) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(4);
        details.put(DELTA_T, new Double(0.0));
        details.put(EXPOSURE_TIME, new Double(0.0));
        details.put(POSITION_X, new Double(0.0));
        details.put(POSITION_Y, new Double(0.0));
        details.put(POSITION_Z, new Double(0.0));
        ArrayList<String> notSet = new ArrayList<String>();
        notSet.add(DELTA_T);
        notSet.add(EXPOSURE_TIME);
        notSet.add(POSITION_X);
        notSet.add(POSITION_Y);
        notSet.add(POSITION_Z);
        details.put(NOT_SET, notSet);
        if (plane != null) {
            RDouble o = plane.getDeltaT();
            if (o != null) {
                notSet.remove(DELTA_T);
                details.put(DELTA_T, EditorUtil.roundValue(o.getValue()));
            }
            if ((o = plane.getExposureTime()) != null) {
                notSet.remove(EXPOSURE_TIME);
                details.put(EXPOSURE_TIME, EditorUtil.roundValue(o.getValue()));
            }
            if ((o = plane.getPositionX()) != null) {
                notSet.remove(POSITION_X);
                details.put(POSITION_X, EditorUtil.roundValue(o.getValue()));
            }
            if ((o = plane.getPositionY()) != null) {
                notSet.remove(POSITION_Y);
                details.put(POSITION_Y, EditorUtil.roundValue(o.getValue()));
            }
            if ((o = plane.getPositionZ()) != null) {
                notSet.remove(POSITION_Z);
                details.put(POSITION_Z, EditorUtil.roundValue(o.getValue()));
            }
        }
        return details;
    }

    public static OMEComboBox createComboBox(Object[] values, int decrement, Color backgoundColor) {
        OMEComboBox box = new OMEComboBox(values);
        box.setOpaque(true);
        if (backgoundColor != null) {
            box.setBackground(backgoundColor);
        }
        OMEComboBoxUI ui = new OMEComboBoxUI();
        ui.setBackgroundColor(box.getBackground());
        ui.installUI(box);
        box.setUI(ui);
        Font f = box.getFont();
        int size = f.getSize() - decrement;
        box.setBorder(null);
        box.setFont(f.deriveFont(2, size));
        return box;
    }

    public static OMEComboBox createComboBox(Object[] values, int decrement) {
        return EditorUtil.createComboBox(values, decrement, UIUtilities.BACKGROUND_COLOR);
    }

    public static OMEComboBox createComboBox(Object[] values) {
        return EditorUtil.createComboBox(values, 3);
    }

    public static OMEComboBox createComboBox(List values) {
        if (values == null) {
            return null;
        }
        Iterator i = values.iterator();
        Object[] array = new Object[values.size()];
        int index = 0;
        while (i.hasNext()) {
            array[index] = i.next();
            ++index;
        }
        return EditorUtil.createComboBox(array, 3);
    }

    public static JXTaskPane createTaskPane(String title) {
        return UIUtilities.createTaskPane(title, UIUtilities.BACKGROUND_COLOR);
    }

    public static boolean isEditorFile(String fileName) {
        return editorFilter.accept(fileName);
    }

    public static JComponent getLabel(String value, boolean required) {
        if (required) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            JLabel l = UIUtilities.setTextFont(value);
            p.add(l);
            l = UIUtilities.setTextFont(MANDATORY_SYMBOL);
            l.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
            p.add(l);
            return p;
        }
        return UIUtilities.setTextFont(value);
    }

    public static String getWorkflowForDisplay(String value) {
        if (value == null) {
            return value;
        }
        String result = value;
        if (value.contains("/")) {
            String[] list = value.split("/");
            result = list[list.length - 1];
        }
        return result;
    }

    public static String getExperimenterName(ExperimenterData exp) {
        if (exp == null) {
            return "";
        }
        return exp.getFirstName() + " " + exp.getLastName();
    }

    static {
        INDIGO = new Color(75, 0, 130);
        VIOLET = new Color(238, 130, 238);
        SCRIPTS_FILTERS = new ArrayList<CustomizedFileFilter>();
        SCRIPTS_FILTERS.add(new CppFilter());
        SCRIPTS_FILTERS.add(new JavaFilter());
        SCRIPTS_FILTERS.add(new MatlabFilter());
        SCRIPTS_FILTERS.add(new PythonFilter());
        PIXELS_TYPE_DESCRIPTION = new LinkedHashMap<String, String>();
        PIXELS_TYPE_DESCRIPTION.put("int8", "Signed 8-bit (1byte)");
        PIXELS_TYPE_DESCRIPTION.put("uint8", "Unsigned 8-bit (1 byte)");
        PIXELS_TYPE_DESCRIPTION.put("int16", "Signed 16-bit (2byte)");
        PIXELS_TYPE_DESCRIPTION.put("uint16", "Unsigned 16-bit(2byte)");
        PIXELS_TYPE_DESCRIPTION.put("int32", "Signed 32-bit(4byte)");
        PIXELS_TYPE_DESCRIPTION.put("uint32", "Unsigned 32-bit(4byte)");
        PIXELS_TYPE_DESCRIPTION.put("float", "Floating precision");
        PIXELS_TYPE_DESCRIPTION.put("double", "Double precision");
        PIXELS_TYPE = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : PIXELS_TYPE_DESCRIPTION.entrySet()) {
            PIXELS_TYPE.put(entry.getValue(), entry.getKey());
        }
        COLORS_BAR = new LinkedHashMap<Color, String>();
        COLORS_BAR.put(ImagePaintingFactory.UNIT_BAR_COLOR, "Gray");
        COLORS_BAR.put(Color.ORANGE, "Orange");
        COLORS_BAR.put(Color.YELLOW, "Yellow");
        COLORS_BAR.put(Color.BLACK, "Black");
        COLORS_BAR.put(INDIGO, "Indigo");
        COLORS_BAR.put(VIOLET, "Violet");
        COLORS_BAR.put(Color.RED, "Red");
        COLORS_BAR.put(Color.GREEN, "Green");
        COLORS_BAR.put(Color.BLUE, "Blue");
        COLORS_BAR.put(Color.WHITE, "White");
        editorFilter = new EditorFileFilter();
    }
}

