/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.util.SelectionWizardUI;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionWizard
extends JDialog
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String SELECTED_ITEMS_PROPERTY = "selectedItems";
    public static final String CANCEL_SELECTION_PROPERTY = "cancelSelection";
    private static final int ACCEPT = 0;
    private static final int CANCEL = 1;
    private static final int RESET = 2;
    private static final int ADD_NEW = 3;
    private static final Dimension DEFAULT_SIZE = new Dimension(500, 500);
    private JButton acceptButton;
    private JButton resetButton;
    private JButton cancelButton;
    private Class type;
    private JButton addNewButton;
    private JTextField addField;
    private SelectionWizardUI uiDelegate;

    private void initComponents() {
        this.acceptButton = new JButton("Accept");
        this.acceptButton.setToolTipText("Accept the selection.");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Cancel the selection.");
        this.resetButton = new JButton("Reset");
        this.resetButton.setToolTipText("Reset the selection.");
        this.addNewButton = new JButton("Add");
        this.addNewButton.setEnabled(false);
        this.addNewButton.setToolTipText("Add the new elements to the selection.");
        this.addNewButton.setActionCommand("3");
        this.addNewButton.addActionListener(this);
        this.acceptButton.setActionCommand("0");
        this.acceptButton.addActionListener(this);
        this.acceptButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.cancelButton.setActionCommand("1");
        this.cancelButton.addActionListener(this);
        this.resetButton.setActionCommand("2");
        this.resetButton.addActionListener(this);
        this.addField = new JTextField(20);
        this.addField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        SelectionWizard.this.addNewObjects();
                    }
                }
            }
        });
        this.addField.getDocument().addDocumentListener(this);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void cancel() {
        this.close();
        this.firePropertyChange(CANCEL_SELECTION_PROPERTY, (Object)false, (Object)true);
    }

    private void accept() {
        HashMap<Class, Collection<Object>> r = new HashMap<Class, Collection<Object>>();
        r.put(this.type, this.uiDelegate.getSelection());
        this.firePropertyChange(SELECTED_ITEMS_PROPERTY, null, r);
        this.close();
    }

    private void buildUI(boolean addCreation) {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        if (!addCreation || !TagAnnotationData.class.equals((Object)this.type)) {
            c.add((Component)this.uiDelegate, "Center");
        } else {
            JPanel container = new JPanel();
            container.setLayout(new BoxLayout(container, 1));
            container.add(this.uiDelegate);
            container.add(this.createAdditionPane());
            c.add((Component)container, "Center");
        }
        c.add((Component)this.createControlsPane(), "South");
    }

    private JPanel createControlsPane() {
        JPanel controlPanel = new JPanel();
        controlPanel.setOpaque(false);
        controlPanel.setLayout(new FlowLayout());
        controlPanel.add(this.resetButton);
        controlPanel.add(this.acceptButton);
        controlPanel.add(this.cancelButton);
        return UIUtilities.buildComponentPanelRight(controlPanel);
    }

    private JPanel createAdditionPane() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        String text = null;
        String tip = null;
        p.setLayout(new BoxLayout(p, 1));
        if (TagAnnotationData.class.equals((Object)this.type)) {
            tip = "Enter the new Tags, use comma to separate them.";
            text = "New Tag: ";
        }
        if (tip != null) {
            p.add(UIUtilities.buildComponentPanel(new JLabel(tip)));
        }
        if (text != null) {
            JPanel pane = new JPanel();
            pane.setLayout(new BoxLayout(pane, 0));
            pane.add(UIUtilities.setTextFont(text));
            pane.add(this.addField);
            pane.add(this.addNewButton);
            p.add(pane);
        }
        return UIUtilities.buildComponentPanel(p);
    }

    private void addNewObjects() {
        if (TagAnnotationData.class.equals((Object)this.type)) {
            String text = this.addField.getText();
            if (text == null || text.trim().length() == 0) {
                return;
            }
            String[] names = text.split(",");
            ArrayList<DataObject> objects = new ArrayList<DataObject>();
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null || names[i].length() <= 0) continue;
                objects.add((DataObject)new TagAnnotationData(names[i].trim()));
            }
            this.uiDelegate.addObjects(objects);
            this.addField.setText("");
        }
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Class type, long userID) {
        this(owner, available, null, type, userID);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Class type, boolean addCreation, long userID) {
        this(owner, available, null, type, addCreation, userID);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Collection<Object> selected, Class type, long userID) {
        this(owner, available, selected, type, false, userID);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Collection<Object> selected, Class type, boolean addCreation, long userID) {
        super(owner);
        this.setModal(true);
        this.uiDelegate = new SelectionWizardUI(available, selected, type, userID);
        this.uiDelegate.addPropertyChangeListener(this);
        this.type = type;
        this.initComponents();
        this.buildUI(addCreation);
        this.setSize(DEFAULT_SIZE);
    }

    public void setImmutableElements(Collection immutable) {
        this.uiDelegate.setImmutableElements(immutable);
    }

    public void setTitle(String title, String text) {
        this.setTitle(title, text, null);
    }

    public void setTitle(String title, String text, Icon titleIcon) {
        this.setTitle(title);
        if (titleIcon == null) {
            IconManager icons = IconManager.getInstance();
            titleIcon = icons.getIcon(89);
        }
        TitlePanel titlePanel = new TitlePanel(title, text, titleIcon);
        this.getContentPane().add((Component)((Object)titlePanel), "North");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int id = Integer.parseInt(evt.getActionCommand());
        switch (id) {
            case 0: {
                this.accept();
                break;
            }
            case 1: {
                this.cancel();
                break;
            }
            case 2: {
                this.uiDelegate.reset();
                break;
            }
            case 3: {
                this.addNewObjects();
            }
        }
    }

    public void setAcceptButtonText(String text) {
        if (this.acceptButton != null) {
            this.acceptButton.setText(text);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        String text = this.addField.getText();
        boolean b = text != null && text.trim().length() > 0;
        this.addNewButton.setEnabled(b);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        String text = this.addField.getText();
        boolean b = text != null && text.trim().length() > 0;
        this.addNewButton.setEnabled(b);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selectionChangeProperty".equals(name)) {
            Boolean b = (Boolean)evt.getNewValue();
            this.acceptButton.setEnabled(b);
            this.resetButton.setEnabled(b);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

