/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class EditorDialog
extends JDialog
implements ActionListener,
DocumentListener {
    public static final int CREATE_TYPE = 0;
    public static final int EDIT_TYPE = 1;
    public static final String CREATE_PROPERTY = "create";
    public static final String CREATE_NO_PARENT_PROPERTY = "createNoParent";
    public static final String CLOSE_EDITOR_DIALOG_PROPERTY = "closeEditorDialog";
    private static final Dimension WIN_DIM = new Dimension(600, 300);
    private static final String TITLE = "Create";
    private static final String TITLE_EDIT = "Edit";
    private static final int CANCEL = 0;
    private static final int SAVE = 1;
    private JTextField nameArea;
    private JTextArea descriptionArea;
    private JButton cancelButton;
    private JButton saveButton;
    private DataObject data;
    private JRadioButton publicBox;
    private JRadioButton groupBox;
    private JRadioButton privateBox;
    private String typeName;
    private String originalText;
    private String originalDescription;
    private boolean withParent;
    private int type;

    private JPanel buildPermissions() {
        JPanel content = new JPanel();
        content.add(this.privateBox);
        content.add(this.groupBox);
        content.add(this.publicBox);
        return content;
    }

    private void initComponents() {
        this.publicBox = new JRadioButton("Public");
        this.publicBox.setEnabled(false);
        this.groupBox = new JRadioButton("Collaborative");
        this.groupBox.setEnabled(false);
        this.privateBox = new JRadioButton("Private");
        this.privateBox.setSelected(true);
        this.privateBox.setEnabled(false);
        this.nameArea = new JTextField();
        this.descriptionArea = new MultilineLabel();
        this.descriptionArea.setEditable(true);
        this.originalText = "";
        this.originalDescription = "";
        if (this.type == 1) {
            this.originalText = this.getDataName();
            this.originalDescription = this.getDataDescription();
            this.nameArea.setText(this.originalText);
            this.descriptionArea.setText(this.originalDescription);
            this.descriptionArea.getDocument().addDocumentListener(this);
        }
        this.nameArea.getDocument().addDocumentListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Close the dialog.");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        if (this.type == 1) {
            this.saveButton = new JButton("Save");
            this.saveButton.setToolTipText("Edit the object.");
        } else {
            this.saveButton = new JButton(TITLE);
            this.saveButton.setToolTipText("Create a new object.");
        }
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("1");
        this.saveButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.saveButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                EditorDialog.this.nameArea.requestFocus();
            }
        });
    }

    private JPanel buildContentPanel() {
        JPanel content = new JPanel();
        int height = 80;
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, 5.0, height}};
        TableLayout layout = new TableLayout((double[][])tl);
        content.setLayout((LayoutManager)layout);
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.add((Component)UIUtilities.setTextFont("Name"), "0, 0, LEFT, TOP");
        content.add((Component)this.nameArea, "1, 0");
        content.add((Component)UIUtilities.setTextFont("Description"), "0, 2, LEFT, TOP");
        content.add((Component)new JScrollPane(this.descriptionArea), "1, 2");
        return content;
    }

    public JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.cancelButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.saveButton);
        bar.add(Box.createHorizontalStrut(10));
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        return p;
    }

    private TitlePanel buildTitlePanel() {
        IconManager im = IconManager.getInstance();
        TitlePanel tp = null;
        Icon icon = im.getIcon(115);
        if (this.data instanceof ProjectData) {
            this.typeName = "Project";
            icon = im.getIcon(111);
        } else if (this.data instanceof DatasetData) {
            this.typeName = "Dataset";
            icon = im.getIcon(112);
        } else if (this.data instanceof ScreenData) {
            this.typeName = "Screen";
            icon = im.getIcon(114);
        } else if (this.data instanceof TagAnnotationData) {
            this.typeName = "Tag";
            icon = im.getIcon(66);
            String ns = ((TagAnnotationData)this.data).getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                this.typeName = "Tag Set";
                icon = im.getIcon(113);
            }
        }
        if (this.type == 0) {
            tp = new TitlePanel("Create " + this.typeName, "Create a new " + this.typeName + ".", icon);
        } else if (this.type == 1) {
            tp = new TitlePanel("Edit " + this.typeName, "Edit the " + this.typeName + ".", icon);
        }
        return tp;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(this.buildContentPanel());
        c.add((Component)((Object)this.buildTitlePanel()), "North");
        c.add((Component)this.buildContentPanel(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private void close() {
        this.firePropertyChange(CLOSE_EDITOR_DIALOG_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        this.setVisible(false);
        this.dispose();
    }

    private void save() {
        String name = this.nameArea.getText();
        if (name == null) {
            return;
        }
        int n = (name = name.trim()).length();
        if (n == 0 || n > 256) {
            return;
        }
        if (this.data instanceof ProjectData) {
            ProjectData p = (ProjectData)this.data;
            p.setName(name);
            p.setDescription(this.descriptionArea.getText().trim());
            this.data = p;
        } else if (this.data instanceof DatasetData) {
            DatasetData d = (DatasetData)this.data;
            d.setName(name);
            d.setDescription(this.descriptionArea.getText().trim());
            this.data = d;
        } else if (this.data instanceof ScreenData) {
            ScreenData d = (ScreenData)this.data;
            d.setName(name);
            d.setDescription(this.descriptionArea.getText().trim());
            this.data = d;
        } else if (this.data instanceof TagAnnotationData) {
            TagAnnotationData d = (TagAnnotationData)this.data;
            d.setContent((Object)name);
            String text = this.descriptionArea.getText().trim();
            if (text.length() > 0) {
                d.setTagDescription(text);
            }
            this.data = d;
        }
        if (this.withParent) {
            this.firePropertyChange(CREATE_PROPERTY, null, this.data);
        } else {
            this.firePropertyChange(CREATE_NO_PARENT_PROPERTY, null, this.data);
        }
        this.close();
    }

    private void checkData(DataObject object) {
        if (object == null) {
            throw new IllegalArgumentException("No object to create.");
        }
        if (object instanceof ProjectData) {
            return;
        }
        if (object instanceof DatasetData) {
            return;
        }
        if (object instanceof ScreenData) {
            return;
        }
        if (object instanceof TagAnnotationData) {
            return;
        }
        throw new IllegalArgumentException("Object not supported.");
    }

    private String getDataName() {
        if (this.data instanceof ProjectData) {
            return ((ProjectData)this.data).getName();
        }
        if (this.data instanceof DatasetData) {
            return ((DatasetData)this.data).getName();
        }
        if (this.data instanceof ScreenData) {
            return ((ScreenData)this.data).getName();
        }
        if (this.data instanceof TagAnnotationData) {
            return ((TagAnnotationData)this.data).getTagValue();
        }
        return "";
    }

    private String getDataDescription() {
        if (this.data instanceof ProjectData) {
            return ((ProjectData)this.data).getDescription();
        }
        if (this.data instanceof DatasetData) {
            return ((DatasetData)this.data).getDescription();
        }
        if (this.data instanceof ScreenData) {
            return ((ScreenData)this.data).getDescription();
        }
        if (this.data instanceof TagAnnotationData) {
            return "";
        }
        return "";
    }

    private void enableSave() {
        String name = this.nameArea.getText();
        String desc = this.descriptionArea.getText();
        if (this.type == 0) {
            if (name == null) {
                this.saveButton.setEnabled(false);
            } else {
                int l = (name = name.trim()).length();
                this.saveButton.setEnabled(l > 0 && l < 256);
            }
        } else if (!this.originalText.equals(name)) {
            int l = (name = name.trim()).length();
            this.saveButton.setEnabled(l > 0 && l < 256);
        } else {
            this.saveButton.setEnabled(!this.originalDescription.equals(desc = desc.trim()));
        }
    }

    public EditorDialog(JFrame owner, DataObject data, boolean withParent, int type) {
        super(owner);
        switch (type) {
            case 1: {
                this.type = type;
                this.setTitle(TITLE_EDIT);
                break;
            }
            default: {
                this.type = 0;
                this.setTitle(TITLE);
            }
        }
        this.checkData(data);
        this.data = data;
        this.withParent = withParent;
        this.initComponents();
        this.buildGUI();
        this.setSize(WIN_DIM);
    }

    public EditorDialog(JFrame owner, DataObject data, boolean withParent) {
        this(owner, data, withParent, 0);
    }

    public void setOriginalDescription(String description) {
        if (description == null) {
            return;
        }
        this.originalDescription = description;
        this.descriptionArea.getDocument().removeDocumentListener(this);
        this.descriptionArea.setText(description);
        this.descriptionArea.getDocument().addDocumentListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.save();
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.enableSave();
    }

    public void removeUpdate(DocumentEvent e) {
        this.enableSave();
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

