/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.util.ui.ColorListRenderer;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.TextualTwoKnobsSlider;

public class MovieExportDialog
extends JDialog
implements ActionListener,
DocumentListener {
    public static final String CREATE_MOVIE_PROPERTY = "createMovie";
    public static final int CLOSE = 0;
    public static final int SAVE = 1;
    private static final int SCALE_BAR = 2;
    private static final int Z_INTERVAL = 3;
    private static final int T_INTERVAL = 4;
    private static final String TITLE = "Movie Creation";
    private static final int DEFAULT_SCALE = 5;
    private JButton closeButton;
    private JButton saveButton;
    private JTextField nameField;
    private JComboBox formats;
    private NumericalTextField scaleBar;
    private JCheckBox showScaleBar;
    private JCheckBox timeInterval;
    private JCheckBox zInterval;
    private JCheckBox labelVisible;
    private JComboBox colorBox;
    private JSpinner fps;
    private TextualTwoKnobsSlider timeRange;
    private TextualTwoKnobsSlider zRange;
    private int option;
    private MovieExportParam param;
    private JSpinner zSpinner;
    private JSpinner tSpinner;
    private int maxZ;
    private int maxT;

    private void initComponents(String name, int defaultZ, int defaultT) {
        this.closeButton = new JButton("Cancel");
        this.closeButton.setToolTipText(UIUtilities.formatToolTipText("Close the window."));
        this.closeButton.setActionCommand("0");
        this.closeButton.addActionListener(this);
        this.saveButton = new JButton("Create");
        this.saveButton.setEnabled(false);
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText("Create a movie."));
        this.saveButton.setActionCommand("1");
        this.saveButton.addActionListener(this);
        this.nameField = new JTextField();
        String s = UIUtilities.removeFileExtension(name);
        if (s != null) {
            this.nameField.setText(s);
            this.saveButton.setEnabled(true);
        }
        this.nameField.getDocument().addDocumentListener(this);
        Map<Integer, String> map = MovieExportParam.FORMATS;
        String[] f = new String[map.size()];
        Iterator<Map.Entry<Serializable, String>> i = map.entrySet().iterator();
        int index = 0;
        boolean isMac = UIUtilities.isMacOS();
        while (i.hasNext()) {
            Map.Entry<Integer, String> entry = i.next();
            int key = entry.getKey();
            f[key] = entry.getValue();
            if (!isMac || key != 1) continue;
            index = key;
        }
        this.formats = new JComboBox<String>(f);
        this.formats.setSelectedIndex(index);
        this.timeRange = new TextualTwoKnobsSlider(1, this.maxT, 1, this.maxT);
        this.timeRange.layoutComponents();
        this.timeRange.setEnabled(this.maxT > 1);
        this.zRange = new TextualTwoKnobsSlider(1, this.maxZ, 1, this.maxZ);
        this.zRange.layoutComponents();
        this.zRange.setEnabled(false);
        this.timeInterval = new JCheckBox("Time Interval");
        this.timeInterval.setFont(this.timeInterval.getFont().deriveFont(1));
        this.zInterval = new JCheckBox("Z-section Interval");
        this.zInterval.setFont(this.zInterval.getFont().deriveFont(1));
        if (this.maxT > 1) {
            this.timeInterval.setSelected(true);
        } else {
            this.timeInterval.setEnabled(false);
        }
        if (this.maxZ > 1 && this.maxT <= 1) {
            this.zInterval.setEnabled(false);
            this.zInterval.setSelected(true);
            this.zRange.setEnabled(true);
        }
        SpinnerNumberModel sp = new SpinnerNumberModel(defaultZ, 1, this.maxZ, 1);
        this.zSpinner = new JSpinner(sp);
        sp = new SpinnerNumberModel(defaultT, 1, this.maxT, 1);
        this.tSpinner = new JSpinner(sp);
        if (this.maxT <= 1) {
            this.tSpinner.setEnabled(false);
        }
        if (this.maxZ <= 1 || this.zInterval.isSelected()) {
            this.zSpinner.setEnabled(false);
        }
        this.zInterval.addActionListener(this);
        this.zInterval.setActionCommand("3");
        this.timeInterval.addActionListener(this);
        this.timeInterval.setActionCommand("4");
        this.showScaleBar = new JCheckBox("Scale Bar");
        this.showScaleBar.setFont(this.showScaleBar.getFont().deriveFont(1));
        this.showScaleBar.setSelected(true);
        this.showScaleBar.setActionCommand("2");
        this.showScaleBar.addActionListener(this);
        this.scaleBar = new NumericalTextField();
        this.scaleBar.setText("5");
        this.fps = new JSpinner();
        this.fps.setValue(25);
        this.labelVisible = new JCheckBox("Show Labels");
        this.getRootPane().setDefaultButton(this.saveButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MovieExportDialog.this.close();
            }
        });
        this.colorBox = new JComboBox();
        Map<Color, String> colors = EditorUtil.COLORS_BAR;
        Object[][] cols = new Object[colors.size()][2];
        index = 0;
        for (Map.Entry<Serializable, String> entry : colors.entrySet()) {
            cols[index] = new Object[]{entry.getKey(), entry.getValue()};
            ++index;
        }
        this.colorBox.setModel(new DefaultComboBoxModel((E[])cols));
        this.colorBox.setRenderer(new ColorListRenderer());
    }

    private void enabledControls() {
        this.saveButton.setEnabled(true);
        if (this.zInterval.isSelected()) {
            this.zRange.setEnabled(this.maxZ > 1);
            this.zSpinner.setEnabled(false);
        } else {
            this.zRange.setEnabled(false);
            this.zSpinner.setEnabled(this.maxZ > 1);
        }
        if (this.timeInterval.isSelected()) {
            this.timeRange.setEnabled(this.maxT > 1);
            this.tSpinner.setEnabled(false);
        } else {
            this.timeRange.setEnabled(false);
            this.tSpinner.setEnabled(this.maxT > 1);
        }
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.closeButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.saveButton);
        bar.add(Box.createHorizontalStrut(20));
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        return p;
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, "Create a movie.", "The movie will be saved to the server and attached to the image.", icons.getIcon(129));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(5, 5));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildBody(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private JPanel buildBody() {
        JPanel content = new JPanel();
        double[][] tl = new double[][]{{-2.0, -2.0, -1.0}, {-2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, -2.0, 5.0, -2.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 10.0}};
        TableLayout layout = new TableLayout((double[][])tl);
        content.setLayout((LayoutManager)layout);
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        int i = 0;
        content.add((Component)UIUtilities.setTextFont("Name"), "0, " + i + "");
        content.add((Component)this.nameField, "1, " + i + ", 2, " + i);
        content.add((Component)UIUtilities.setTextFont("Format"), "0, " + (i += 2) + "");
        content.add((Component)this.formats, "1, " + i);
        content.add((Component)UIUtilities.setTextFont("Frame Rate"), "0, " + (i += 2) + "");
        content.add((Component)this.fps, "1, " + i);
        content.add((Component)new JLabel("fps"), "2, " + i);
        content.add((Component)this.timeInterval, "0, " + (i += 2) + ", l, t");
        content.add((Component)UIUtilities.buildComponentPanel(this.timeRange), "1, " + i + ", 2, " + i);
        ++i;
        JLabel l = new JLabel();
        JPanel p = new JPanel();
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(UIUtilities.setTextFont("If interval not selected, select the time-point", 2, l.getFont().getSize() - 2));
        p.add(this.tSpinner);
        content.add((Component)UIUtilities.buildComponentPanel(p), "0, " + i + ", 2, " + i);
        content.add((Component)this.zInterval, "0, " + (i += 2) + ", l, t");
        content.add((Component)UIUtilities.buildComponentPanel(this.zRange), "1, " + i + ", 2, " + i);
        ++i;
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(UIUtilities.setTextFont("If interval not selected, select the z-section", 2, l.getFont().getSize() - 2));
        p.add(this.zSpinner);
        content.add((Component)UIUtilities.buildComponentPanel(p), "0, " + i + ", 2, " + i);
        content.add((Component)this.showScaleBar, "0, " + (i += 2));
        content.add((Component)this.scaleBar, "1, " + i);
        content.add((Component)new JLabel("microns"), "2, " + i);
        content.add((Component)UIUtilities.buildComponentPanel(this.colorBox), "1, " + (i += 2));
        content.add((Component)this.labelVisible, "0, " + (i += 2));
        return content;
    }

    private void close() {
        this.option = 0;
        this.setVisible(false);
        this.dispose();
    }

    private void save() {
        Number n;
        String name = this.nameField.getText();
        int format = this.formats.getSelectedIndex();
        int scale = -1;
        int f = (Integer)this.fps.getValue();
        if (this.showScaleBar.isSelected() && (n = this.scaleBar.getValueAsNumber()) != null) {
            scale = n.intValue();
        }
        int type = 2;
        if (!this.timeInterval.isSelected() && this.zInterval.isSelected()) {
            type = 0;
        } else if (this.timeInterval.isSelected() && !this.zInterval.isSelected()) {
            type = 1;
        }
        this.param = new MovieExportParam(name, f, format, scale, type);
        if (type == 1 || type == 2) {
            this.param.setTimeInterval((int)this.timeRange.getStartValue() - 1, (int)this.timeRange.getEndValue() - 1);
        }
        if (type == 0 || type == 2) {
            this.param.setZsectionInterval((int)this.zRange.getStartValue() - 1, (int)this.zRange.getEndValue() - 1);
        }
        this.param.setLabelVisible(this.labelVisible.isSelected());
        if (!this.timeInterval.isSelected()) {
            int t = (Integer)this.tSpinner.getValue() - 1;
            this.param.setTimeInterval(t, t);
        }
        if (!this.zInterval.isSelected()) {
            int z = (Integer)this.zSpinner.getValue() - 1;
            this.param.setZsectionInterval(z, z);
        }
        int index = this.colorBox.getSelectedIndex();
        Map<Color, String> m = EditorUtil.COLORS_BAR;
        Iterator<Map.Entry<Color, String>> i = m.entrySet().iterator();
        int j = 0;
        String c = null;
        while (i.hasNext()) {
            Map.Entry<Color, String> entry = i.next();
            if (j == index) {
                c = entry.getValue();
            }
            ++j;
        }
        this.param.setColor(c);
        this.option = 1;
        this.close();
        this.firePropertyChange(CREATE_MOVIE_PROPERTY, null, this.param);
    }

    private void handleText() {
        String text = this.nameField.getText();
        this.saveButton.setEnabled(text != null && text.trim().length() != 0);
    }

    private boolean isSameColor(Color c1, Color c2) {
        if (c1.getRed() != c2.getRed()) {
            return false;
        }
        if (c1.getGreen() != c2.getGreen()) {
            return false;
        }
        return c1.getBlue() == c2.getBlue();
    }

    public MovieExportDialog(JFrame owner, String name, int maxT, int maxZ, int defaultZ, int defaultT) {
        super(owner);
        this.setModal(true);
        this.param = null;
        this.maxT = maxT;
        this.maxZ = maxZ;
        this.initComponents(name, defaultZ, defaultT);
        this.buildGUI();
        this.pack();
    }

    public void setBinaryAvailable(boolean available) {
        this.saveButton.setEnabled(available);
    }

    public void setScaleBarDefault(int value, Color color) {
        if (color != null) {
            Map.Entry<Color, String> entry;
            Color c;
            Map<Color, String> m = EditorUtil.COLORS_BAR;
            int index = 0;
            Iterator<Map.Entry<Color, String>> i = m.entrySet().iterator();
            while (i.hasNext() && !this.isSameColor(c = (entry = i.next()).getKey(), color)) {
                ++index;
            }
            this.colorBox.setSelectedIndex(index);
        }
        if (value > 0) {
            this.scaleBar.setText("" + value);
        }
    }

    public int showDialog() {
        this.setLocation(this.getParent().getLocation());
        this.setVisible(true);
        return this.option;
    }

    public int centerDialog() {
        UIUtilities.centerAndShow(this);
        return this.option;
    }

    public MovieExportParam getParameters() {
        return this.param;
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.save();
                break;
            }
            case 2: {
                this.scaleBar.setEnabled(this.showScaleBar.isSelected());
                break;
            }
            case 3: 
            case 4: {
                this.enabledControls();
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.handleText();
    }

    public void removeUpdate(DocumentEvent e) {
        this.handleText();
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

