/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.PermissionData;

public class PermissionsPane
extends JPanel
implements ChangeListener {
    public static final String PERMISSIONS_CHANGE_PROPERTY = "permissionsChange";
    private static final String WARNING = "Upgrading the permissions cannot be undone.";
    private JRadioButton groupBox;
    private JRadioButton privateBox;
    private JRadioButton publicBox;
    private JCheckBox readOnlyGroupBox;
    private JCheckBox readOnlyPublicBox;
    private JLabel label;

    private void initComponents(int permissions) {
        this.label = new JLabel();
        Font f = this.label.getFont();
        this.label.setFont(f.deriveFont(2, f.getSize() - 2));
        this.readOnlyGroupBox = new JCheckBox("Read Only");
        this.readOnlyGroupBox.setEnabled(false);
        this.readOnlyPublicBox = new JCheckBox("Read Only");
        this.readOnlyPublicBox.setEnabled(false);
        this.groupBox = new JRadioButton("Collaborative");
        this.privateBox = new JRadioButton("Private");
        this.publicBox = new JRadioButton("Public");
        ButtonGroup group = new ButtonGroup();
        group.add(this.privateBox);
        group.add(this.groupBox);
        group.add(this.publicBox);
        switch (permissions) {
            case 100: {
                this.privateBox.setSelected(true);
                break;
            }
            case 101: {
                this.privateBox.setEnabled(false);
                this.groupBox.setSelected(true);
                this.readOnlyGroupBox.setSelected(true);
                this.readOnlyGroupBox.setEnabled(true);
                break;
            }
            case 102: {
                this.privateBox.setEnabled(false);
                this.groupBox.setSelected(true);
                this.readOnlyGroupBox.setSelected(false);
                this.readOnlyGroupBox.setEnabled(true);
                break;
            }
            case 103: {
                this.privateBox.setEnabled(false);
                this.groupBox.setEnabled(false);
                this.readOnlyPublicBox.setSelected(true);
                this.publicBox.setSelected(true);
                this.readOnlyPublicBox.setEnabled(true);
                break;
            }
            case 104: {
                this.privateBox.setEnabled(false);
                this.groupBox.setEnabled(false);
                this.readOnlyPublicBox.setSelected(false);
                this.publicBox.setSelected(true);
                this.readOnlyPublicBox.setEnabled(true);
            }
        }
        this.readOnlyGroupBox.setBackground(this.getBackground());
        this.readOnlyPublicBox.setBackground(this.getBackground());
        this.privateBox.setBackground(this.getBackground());
        this.groupBox.setBackground(this.getBackground());
        this.publicBox.setBackground(this.getBackground());
        this.label.setBackground(this.getBackground());
        this.readOnlyGroupBox.addChangeListener(this);
        this.readOnlyPublicBox.addChangeListener(this);
        this.groupBox.addChangeListener(this);
        this.publicBox.addChangeListener(this);
        this.privateBox.addChangeListener(this);
    }

    private void buildGUI() {
        JPanel p = new JPanel();
        p.setBackground(this.getBackground());
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        p.add((Component)this.privateBox, c);
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)this.groupBox, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        p.add((Component)this.readOnlyGroupBox, c);
        JPanel content = new JPanel();
        content.setBackground(this.getBackground());
        content.setLayout(new BoxLayout(content, 1));
        JPanel lp = UIUtilities.buildComponentPanel(this.label);
        lp.setBackground(this.getBackground());
        content.add(lp);
        content.add(p);
        this.setLayout(new FlowLayout(0));
        this.add(content);
    }

    public PermissionsPane() {
        this(100);
    }

    public PermissionsPane(Color background) {
        this(100, background);
    }

    public PermissionsPane(int permissions) {
        this(permissions, null);
    }

    public PermissionsPane(int permissions, Color background) {
        if (background != null) {
            this.setBackground(background);
        }
        this.initComponents(permissions);
        this.buildGUI();
    }

    public PermissionsPane(PermissionData permissions) {
        this(permissions, null);
    }

    public PermissionsPane(PermissionData permissions, Color background) {
        int level = 100;
        if (permissions != null) {
            if (permissions.isGroupRead()) {
                level = permissions.isGroupWrite() ? 102 : 101;
            } else if (permissions.isWorldRead()) {
                level = permissions.isGroupWrite() ? 104 : 103;
            }
        }
        if (background != null) {
            this.setBackground(background);
        }
        this.initComponents(level);
        this.buildGUI();
    }

    public int getPermissions() {
        if (this.privateBox.isSelected()) {
            return 100;
        }
        if (this.groupBox.isSelected()) {
            if (this.readOnlyGroupBox.isSelected()) {
                return 101;
            }
            return 102;
        }
        if (this.readOnlyPublicBox.isSelected()) {
            return 103;
        }
        return 104;
    }

    public void displayWarningText() {
        this.label.setText(WARNING);
        this.repaint();
    }

    public void disablePermissions() {
        this.publicBox.removeChangeListener(this);
        this.groupBox.removeChangeListener(this);
        this.readOnlyGroupBox.setEnabled(false);
        this.readOnlyPublicBox.setEnabled(false);
        this.groupBox.setEnabled(false);
        this.privateBox.setEnabled(false);
        this.publicBox.setEnabled(false);
        this.groupBox.addChangeListener(this);
        this.publicBox.addChangeListener(this);
        this.removeAll();
        switch (this.getPermissions()) {
            case 100: {
                this.add(this.privateBox);
                break;
            }
            case 101: 
            case 102: {
                JPanel p = new JPanel();
                p.setBackground(this.getBackground());
                p.add(this.groupBox);
                p.add(this.readOnlyGroupBox);
                this.add(p);
                break;
            }
            case 103: 
            case 104: {
                JPanel p = new JPanel();
                p.setBackground(this.getBackground());
                p.add(this.publicBox);
                p.add(this.readOnlyPublicBox);
                this.add(p);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (this.readOnlyGroupBox == src || this.readOnlyPublicBox == src) {
            this.firePropertyChange(PERMISSIONS_CHANGE_PROPERTY, -1, this.getPermissions());
        } else {
            this.readOnlyGroupBox.setEnabled(false);
            this.readOnlyPublicBox.setEnabled(false);
            if (this.groupBox == src) {
                this.readOnlyGroupBox.setEnabled(true);
            } else if (this.publicBox == src) {
                this.readOnlyPublicBox.setEnabled(true);
            }
            this.firePropertyChange(PERMISSIONS_CHANGE_PROPERTY, -1, this.getPermissions());
        }
    }
}

