/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.openmicroscopy.shoola.env.config.OMEROInfo;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class OMEROEntry
extends Entry {
    private static final String PORT_TAG = "port";
    private static final String PORT_SSL_TAG = "portSSL";
    private static final String HOST_NAME_TAG = "hostName";
    private OMEROInfo value;

    private static OMEROInfo parseTag(Node tag) throws DOMException, ConfigException {
        String port = null;
        String portSSL = null;
        String hostName = null;
        NodeList children = tag.getChildNodes();
        int n = children.getLength();
        while (0 < n) {
            Node child;
            if ((child = children.item(--n)).getNodeType() != 1) continue;
            String tagName = child.getNodeName();
            Node c = child.getFirstChild();
            if (c == null) continue;
            String tagValue = c.getNodeValue();
            if (PORT_TAG.equals(tagName)) {
                port = tagValue;
                continue;
            }
            if (PORT_SSL_TAG.equals(tagName)) {
                portSSL = tagValue;
                continue;
            }
            if (HOST_NAME_TAG.equals(tagName)) {
                hostName = tagValue;
                continue;
            }
            throw new ConfigException("Unrecognized tag within the conf entry: " + tagName + ".");
        }
        if (port == null || port.trim().length() == 0) {
            throw new ConfigException("Missing port tag within omeds-conf entry.");
        }
        if (portSSL == null || portSSL.trim().length() == 0) {
            portSSL = port;
        }
        return new OMEROInfo(port, portSSL, hostName);
    }

    OMEROEntry() {
    }

    Object getValue() {
        return this.value;
    }

    protected void setContent(Node node) throws ConfigException {
        try {
            if (node.hasChildNodes()) {
                this.value = OMEROEntry.parseTag(node);
            }
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse OMERO entry.", dex);
        }
    }
}

