/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.login;

import Glacier2.PermissionDeniedException;
import Ice.ConnectionRefusedException;
import Ice.DNSException;
import Ice.FileException;
import java.awt.Toolkit;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import omero.SecurityViolation;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationRequest;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationResponse;
import org.openmicroscopy.shoola.env.data.login.LoginConfig;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class LoginServiceImpl
implements LoginService {
    private int state;
    private Container container;
    private Timer timer;
    private boolean connAttempt;
    private int failureIndex;
    protected LoginConfig config;

    private void pause() {
        try {
            Thread.sleep(this.config.getRetryInterval());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int attempt() {
        UserCredentials uc = this.config.getCredentials();
        try {
            if (uc == null) {
                throw new DSOutOfServiceException("No user's credentials have been entered yet.");
            }
            DataServicesFactory factory = DataServicesFactory.getInstance(this.container);
            if (factory.isConnected()) {
                return 1;
            }
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new LoginTask(), this.config.getTimeout());
            }
            factory.connect(uc);
            if (factory.isConnected() && this.connAttempt) {
                LogMessage msg = new LogMessage();
                msg.println("Logged onto OMERO at: " + uc.getHostName());
                msg.println(uc);
                Logger logger = this.container.getRegistry().getLogger();
                logger.info((Object)this, msg);
                this.timer.cancel();
                return 1;
            }
            if (!this.connAttempt) {
                this.timer.cancel();
                LogMessage msg = new LogMessage();
                msg.println("Cannot connect OMERO at: " + uc.getHostName());
                msg.println(uc);
                Logger logger = this.container.getRegistry().getLogger();
                logger.info((Object)this, msg);
                return 2;
            }
            this.timer.cancel();
            LogMessage msg = new LogMessage();
            msg.println("Cannot connect OMERO at: " + uc.getHostName());
            msg.println(uc);
            Logger logger = this.container.getRegistry().getLogger();
            logger.info((Object)this, msg);
            return 0;
        }
        catch (DSOutOfServiceException dsose) {
            if (dsose != null) {
                Throwable cause = dsose.getCause();
                if (cause instanceof ConnectionRefusedException) {
                    this.failureIndex = 102;
                } else if (cause instanceof DNSException) {
                    this.failureIndex = 100;
                } else if (cause instanceof PermissionDeniedException) {
                    this.failureIndex = 101;
                } else if (cause instanceof FileException) {
                    this.failureIndex = 104;
                } else if (cause instanceof DSOutOfServiceException && cause.getCause() instanceof SecurityViolation) {
                    this.failureIndex = 103;
                }
                LogMessage msg = new LogMessage();
                msg.println("Failed to log onto OMERO.");
                msg.println("Reason: " + dsose.getMessage());
                if (uc != null) {
                    msg.println("OMERO address: " + uc.getHostName());
                    msg.println(uc);
                }
                Logger logger = this.container.getRegistry().getLogger();
            }
            return 0;
        }
    }

    protected void askForCredentials() {
    }

    public LoginServiceImpl(Container c) {
        if (c == null) {
            throw new NullPointerException("No container.");
        }
        this.config = new LoginConfig(c.getRegistry());
        this.container = c;
        EventBus bus = c.getRegistry().getEventBus();
        bus.register((AgentEventListener)this, ServiceActivationRequest.class);
        this.state = 0;
        this.connAttempt = true;
        this.failureIndex = 0;
    }

    public int getState() {
        return this.state;
    }

    public void login() {
        this.state = 1;
        int max = this.config.getMaxRetry();
        while (0 < max--) {
            if (this.attempt() == 1) {
                this.state = 0;
                return;
            }
            this.pause();
        }
        this.askForCredentials();
    }

    public int login(UserCredentials uc) {
        if (uc == null) {
            return 0;
        }
        String name = uc.getUserName();
        if (name == null || name.trim().length() == 0) {
            return 0;
        }
        String password = uc.getPassword();
        if (password == null || password.trim().length() == 0) {
            return 0;
        }
        this.state = 1;
        this.config.setCredentials(uc);
        int succeeded = this.attempt();
        this.state = 0;
        return succeeded;
    }

    public void eventFired(AgentEvent ae) {
        ServiceActivationRequest sar = (ServiceActivationRequest)ae;
        boolean connected = false;
        try {
            DataServicesFactory factory = DataServicesFactory.getInstance(this.container);
            connected = factory.isConnected();
        }
        catch (DSOutOfServiceException dsose) {
            // empty catch block
        }
        ServiceActivationResponse resp = new ServiceActivationResponse(sar, connected);
        EventBus bus = this.container.getRegistry().getEventBus();
        bus.post(resp);
    }

    public void notifyLoginFailure() {
        JFrame f = this.container.getRegistry().getTaskBar().getFrame();
        String text = "";
        switch (this.failureIndex) {
            case 100: {
                text = "Please check the server address\nor try again later.";
                break;
            }
            case 102: {
                text = "Please check the port\nor try again later.";
                break;
            }
            case 103: {
                text = "Your user account is no longer active.\nPlease contact your administrator.";
                break;
            }
            case 104: {
                text = "Please unset ICE_CONFIG.";
                break;
            }
            default: {
                text = "Please check your user name\nand/or password or try again later.";
            }
        }
        NotificationDialog dialog = new NotificationDialog(f, "Login Failure", "Failed to log onto OMERO.\n" + text, IconManager.getDefaultErrorIcon());
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    public void notifyLoginTimeout() {
        JFrame f = this.container.getRegistry().getTaskBar().getFrame();
        NotificationDialog dialog = new NotificationDialog(f, "Login Failure", "Failed to log onto OMERO.\nThe server entered is not responding.\nPlease check the server address or try again later.", IconManager.getDefaultErrorIcon());
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    class LoginTask
    extends TimerTask {
        LoginTask() {
        }

        public void run() {
            Toolkit.getDefaultToolkit().beep();
            LoginServiceImpl.this.connAttempt = false;
            LoginServiceImpl.this.timer.cancel();
        }
    }
}

