/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.util.List;
import java.util.Map;
import omero.IllegalArgumentException;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import pojos.ExperimenterData;
import pojos.GroupData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminObject {
    public static final int CREATE_GROUP = 0;
    public static final int CREATE_EXPERIMENTER = 1;
    public static final int UPDATE_GROUP = 2;
    public static final int UPDATE_EXPERIMENTER = 3;
    public static final int RESET_PASSWORD = 4;
    public static final int PERMISSIONS_PRIVATE = 100;
    public static final int PERMISSIONS_GROUP_READ = 101;
    public static final int PERMISSIONS_GROUP_READ_LINK = 102;
    public static final int PERMISSIONS_PUBLIC_READ = 103;
    public static final int PERMISSIONS_PUBLIC_READ_WRITE = 104;
    public static final String PERMISSIONS_PRIVATE_TEXT = "Private Group";
    public static final String PERMISSIONS_GROUP_READ_TEXT = "Collaborative Read-Only Group";
    public static final String PERMISSIONS_GROUP_READ_LINK_TEXT = "Collaborative Group";
    public static final String PERMISSIONS_PUBLIC_READ_TEXT = "Public";
    public static final String PERMISSIONS_PUBLIC_READ_WRITE_TEXT = "Public";
    private GroupData group;
    private List<GroupData> groups;
    private Map<ExperimenterData, UserCredentials> experimenters;
    private int index;
    private int permissions;

    private void checkIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported");
    }

    public AdminObject(GroupData group, Map<ExperimenterData, UserCredentials> experimenters, int index) {
        this.checkIndex(index);
        this.group = group;
        this.experimenters = experimenters;
        this.index = index;
        this.permissions = -1;
    }

    public AdminObject(Map<ExperimenterData, UserCredentials> experimenters, int index) {
        this(null, experimenters, index);
    }

    public void setPermissions(int permissions) {
        switch (permissions) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                this.permissions = permissions;
                break;
            }
            default: {
                this.permissions = 100;
            }
        }
    }

    public int getPermissions() {
        return this.permissions;
    }

    public Map<ExperimenterData, UserCredentials> getExperimenters() {
        return this.experimenters;
    }

    public GroupData getGroup() {
        return this.group;
    }

    public void setGroups(List<GroupData> groups) {
        this.groups = groups;
    }

    public List<GroupData> getGroups() {
        return this.groups;
    }

    public int getIndex() {
        return this.index;
    }
}

