/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigureParam {
    public static final String ROI_SCRIPT = "/omero/figure_scripts/ROI_Split_Figure.py";
    public static final String THUMBNAIL_SCRIPT = "/omero/figure_scripts/Thumbnail_Figure.py";
    public static final String MOVIE_SCRIPT = "/omero/figure_scripts/Movie_Figure.py";
    public static final String SPLIT_VIEW_SCRIPT = "/omero/figure_scripts/Split_View_Figure.py";
    public static final String MERGED_TEXT = "Merged";
    public static final int SPLIT_VIEW = 0;
    public static final int SPLIT_VIEW_ROI = 1;
    public static final int THUMBNAILS = 2;
    public static final int MOVIE = 3;
    public static final int IMAGE_NAME = 0;
    public static final int DATASET_NAME = 1;
    public static final int TAG_NAME = 2;
    public static final int JPEG = 0;
    public static final int PNG = 1;
    public static final int TIME_SECS = 0;
    public static final int TIME_MINS = 1;
    public static final int TIME_HOURS = 2;
    public static final int TIME_MINS_SECS = 3;
    public static final int TIME_HOURS_MINS = 4;
    public static final Map<Integer, String> FORMATS = new LinkedHashMap<Integer, String>(2);
    public static final Map<Integer, String> TIMES;
    private int format;
    private int projectionType;
    private int zStart;
    private int zEnd;
    private int stepping;
    private String name;
    private int scaleBar;
    private String color;
    private int width;
    private int height;
    private boolean splitGrey;
    private int label;
    private Map<Integer, String> splitChannels;
    private Map<Integer, Integer> mergeChannels;
    private List<Integer> splitActive;
    private List<Long> tags;
    private int index;
    private double magnificationFactor;
    private List<Integer> timepoints;
    private boolean selectedObjects;
    private int time;
    private boolean mergedLabel;
    private boolean includeUntagged;
    private DataObject anchor;

    private void setDefault() {
        this.time = 0;
        this.label = 0;
        this.format = 1;
        this.projectionType = ProjectionParam.MAXIMUM_INTENSITY;
        this.stepping = 1;
        this.scaleBar = 1;
        this.height = -1;
        this.width = -1;
        this.zStart = 0;
        this.zEnd = 0;
        this.splitGrey = false;
        this.index = 0;
        this.selectedObjects = true;
        this.tags = null;
    }

    private void checkFormat(int format) {
        switch (format) {
            case 0: 
            case 1: {
                this.format = format;
                break;
            }
            default: {
                this.format = 1;
            }
        }
    }

    private void checkLabel(int label) {
        switch (label) {
            case 0: 
            case 1: 
            case 2: {
                this.label = label;
                break;
            }
            default: {
                this.label = 0;
            }
        }
    }

    public FigureParam(int format, String name, int label) {
        this(format, name, new HashMap<Integer, String>(), new HashMap<Integer, Color>(), label);
    }

    public FigureParam(int format, String name) {
        this(format, name, new HashMap<Integer, String>(), new HashMap<Integer, Color>(), 0);
    }

    public FigureParam(int format, String name, Map<Integer, String> splitChannels, Map<Integer, Color> channels, int label) {
        this.setDefault();
        if (channels == null) {
            throw new IllegalArgumentException("No channels");
        }
        if (splitChannels == null) {
            throw new IllegalArgumentException("No splitChannels.");
        }
        this.splitChannels = splitChannels;
        this.checkFormat(format);
        this.checkLabel(label);
        this.name = name;
        Iterator<Integer> i = channels.keySet().iterator();
        this.mergeChannels = new LinkedHashMap<Integer, Integer>(channels.size());
        while (i.hasNext()) {
            Integer index = i.next();
            Color c = channels.get(index);
            int value = (c.getAlpha() & 0xFF) << 24 | (c.getRed() & 0xFF) << 16 | (c.getGreen() & 0xFF) << 8 | (c.getBlue() & 0xFF) << 0;
            this.mergeChannels.put(index, value);
        }
    }

    public void setSplitActive(List<Integer> splitActive) {
        this.splitActive = splitActive;
    }

    public List<Integer> getSplitActive() {
        return this.splitActive;
    }

    public void setMergedLabel(boolean mergedLabel) {
        this.mergedLabel = mergedLabel;
    }

    public boolean getMergedLabel() {
        return this.mergedLabel;
    }

    public void setTime(int time) {
        switch (time) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.time = time;
                break;
            }
            default: {
                this.time = 0;
            }
        }
    }

    public String getTimeAsString() {
        switch (this.time) {
            default: {
                return "SECS";
            }
            case 1: {
                return "MINS";
            }
            case 2: {
                return "HOURS";
            }
            case 3: {
                return "MINS SECS";
            }
            case 4: 
        }
        return "HOURS MINS";
    }

    public void setIndex(int index) {
        switch (index) {
            case 1: 
            case 2: 
            case 3: {
                this.index = index;
                break;
            }
            default: {
                this.index = 0;
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Map<Integer, Integer> getMergeChannels() {
        return this.mergeChannels;
    }

    public Map<Integer, String> getSplitChannels() {
        return this.splitChannels;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setScaleBar(int scaleBar) {
        this.scaleBar = scaleBar;
    }

    public void setProjectionType(int type) {
        ProjectionParam.checkProjectionAlgorithm(type);
        this.projectionType = type;
    }

    public void setSplitGrey(boolean splitGrey) {
        this.splitGrey = splitGrey;
    }

    public boolean isSplitGrey() {
        return this.splitGrey;
    }

    public void setZStart(int zStart) {
        this.zStart = zStart;
    }

    public void setZEnd(int zEnd) {
        this.zEnd = zEnd;
    }

    public void setStepping(int stepping) {
        if (stepping < 1) {
            stepping = 1;
        }
        this.stepping = stepping;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public int getScaleBar() {
        return this.scaleBar;
    }

    public boolean isScaleBarVisible() {
        return this.scaleBar <= 0;
    }

    public int getStartZ() {
        return this.zStart;
    }

    public int getEndZ() {
        return this.zEnd;
    }

    public int getFormat() {
        return this.format;
    }

    public void setColor(String c) {
        if (c == null || c.trim().length() == 0) {
            return;
        }
        this.color = c;
    }

    public String getColor() {
        return this.color;
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public int getStepping() {
        return this.stepping;
    }

    public String getLabelAsString() {
        switch (this.label) {
            default: {
                return "Image Name";
            }
            case 1: {
                return "Datasets";
            }
            case 2: 
        }
        return "Tags";
    }

    public String getFormatAsString() {
        switch (this.format) {
            default: {
                return "JPEG";
            }
            case 1: 
        }
        return "PNG";
    }

    public String getProjectionTypeAsString() {
        if (this.projectionType == ProjectionParam.MAXIMUM_INTENSITY) {
            return "Maximum Intensity";
        }
        if (this.projectionType == ProjectionParam.MEAN_INTENSITY) {
            return "Mean Intensity";
        }
        return "";
    }

    public void setMagnificationFactor(double magnificationFactor) {
        this.magnificationFactor = magnificationFactor;
    }

    public double getMagnificationFactor() {
        return this.magnificationFactor;
    }

    public boolean isSelectedObjects() {
        return this.selectedObjects;
    }

    public void setSelectedObjects(boolean value) {
        this.selectedObjects = value;
    }

    public List<Long> getTags() {
        return this.tags;
    }

    public void setTags(List<Long> tags) {
        this.tags = tags;
    }

    public void setTimepoints(List<Integer> timepoints) {
        this.timepoints = timepoints;
    }

    public List<Integer> getTimepoints() {
        return this.timepoints;
    }

    public void setIncludeUntagged(boolean includeUntagged) {
        this.includeUntagged = includeUntagged;
    }

    public boolean isIncludeUntagged() {
        return this.includeUntagged;
    }

    public void setAnchor(DataObject anchor) {
        this.anchor = anchor;
    }

    public DataObject getAnchor() {
        return this.anchor;
    }

    public String getScriptName() {
        switch (this.getIndex()) {
            case 1: {
                return ROI_SCRIPT;
            }
            case 2: {
                return THUMBNAIL_SCRIPT;
            }
            case 3: {
                return MOVIE_SCRIPT;
            }
        }
        return SPLIT_VIEW_SCRIPT;
    }

    static {
        FORMATS.put(0, "JPEG");
        FORMATS.put(1, "PNG");
        TIMES = new LinkedHashMap<Integer, String>(6);
        TIMES.put(0, "Seconds (e.g. 2)");
        TIMES.put(1, "Minutes");
        TIMES.put(2, "Hours");
        TIMES.put(3, "Minutes and Seconds");
        TIMES.put(4, "Hours and Minutes");
    }
}

