/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.util.List;
import org.openmicroscopy.shoola.env.data.model.DataObject;
import org.openmicroscopy.shoola.env.data.model.ImportMetadataContext;
import org.openmicroscopy.shoola.env.data.model.ImportObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportContext {
    public static final int FOLDER_AS_DATASET = 0;
    public static final int FOLDER_AS_SCREEN = 1;
    private DataObject container;
    private int folderAs;
    private int depth;
    private List<ImportObject> files;
    private ImportMetadataContext metadata;

    private void checkType(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return;
            }
        }
        throw new IllegalArgumentException("Folder Type not supported.");
    }

    public ImportContext(DataObject container, List<ImportObject> files) {
        if (files == null || files.size() == 0) {
            throw new IllegalArgumentException("No files to import");
        }
        this.container = container;
        this.folderAs = -1;
    }

    public ImportContext(int folderAs, int depth, List<ImportObject> files) {
        if (files == null || files.size() == 0) {
            throw new IllegalArgumentException("No files to import");
        }
        this.checkType(folderAs);
        this.folderAs = folderAs;
        if (depth < 0) {
            depth = 0;
        }
        this.depth = depth;
    }

    public List<ImportObject> getFiles() {
        return this.files;
    }

    public DataObject getContainer() {
        return this.container;
    }

    public int getFolderAs() {
        return this.folderAs;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setMetadata(ImportMetadataContext metadata) {
        this.metadata = metadata;
    }

    public ImportMetadataContext getMetadata() {
        return this.metadata;
    }
}

