/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.openmicroscopy.shoola.env.data.model.DataObject;
import pojos.ImageData;

public class ThumbnailData
implements DataObject {
    private long userID;
    private long imageID;
    private BufferedImage thumbnail;
    private boolean validImage;
    private ImageData image;
    private pojos.DataObject refObject;

    public ThumbnailData(long imageID, BufferedImage thumbnail, long userID, boolean validImage) {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("Non-positive image id: " + imageID + ".");
        }
        if (thumbnail == null) {
            throw new NullPointerException("No thumbnail.");
        }
        this.imageID = imageID;
        this.thumbnail = thumbnail;
        this.userID = userID;
        this.validImage = validImage;
    }

    public ThumbnailData(long imageID, BufferedImage thumbnail, boolean validImage) {
        this(imageID, thumbnail, -1L, validImage);
    }

    public ThumbnailData(pojos.DataObject refOjbect, BufferedImage thumbnail, boolean validImage) {
        if (thumbnail == null) {
            throw new NullPointerException("No thumbnail.");
        }
        if (refOjbect == null) {
            throw new IllegalArgumentException("No object.");
        }
        if (!(refOjbect instanceof ImageData)) {
            throw new IllegalArgumentException("Type not valid.");
        }
        this.refObject = refOjbect;
        this.validImage = validImage;
        this.thumbnail = thumbnail;
    }

    public ThumbnailData(pojos.DataObject refOjbect, BufferedImage thumbnail) {
        this(refOjbect, thumbnail, true);
    }

    public void setImage(ImageData image) {
        this.image = image;
    }

    public DataObject makeNew() {
        BufferedImage pixClone = new BufferedImage(this.thumbnail.getWidth(), this.thumbnail.getHeight(), this.thumbnail.getType());
        Graphics2D g2D = pixClone.createGraphics();
        g2D.drawImage(this.thumbnail, null, 0, 0);
        ThumbnailData data = this.refObject != null ? new ThumbnailData(this.refObject, pixClone, this.validImage) : new ThumbnailData(this.imageID, pixClone, this.validImage);
        data.setImage(this.image);
        return data;
    }

    public boolean isValidImage() {
        return this.validImage;
    }

    public long getUserID() {
        return this.userID;
    }

    public long getImageID() {
        return this.imageID;
    }

    public BufferedImage getThumbnail() {
        return this.thumbnail;
    }

    public ImageData getImage() {
        return this.image;
    }

    public pojos.DataObject getRefObject() {
        return this.refObject;
    }
}

