/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import pojos.ChannelData;

public class ChannelMetadataLoader
extends BatchCallTree {
    private Object results;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final long pixelsID, final long userID) {
        return new BatchCall("Loading channel Metadata: "){

            public void doCall() throws Exception {
                OmeroDataService os = ChannelMetadataLoader.this.context.getDataService();
                List l = os.getChannelsMetadata(pixelsID);
                if (userID >= 0L) {
                    OmeroImageService svc = ChannelMetadataLoader.this.context.getImageService();
                    List rnd = svc.getRenderingSettingsFor(pixelsID, userID);
                    HashMap<Object, Color> channels = new HashMap<Object, Color>();
                    Iterator i = l.iterator();
                    if (rnd != null && rnd.size() > 0) {
                        RndProxyDef ref = (RndProxyDef)rnd.get(0);
                        while (i.hasNext()) {
                            ChannelData channel = (ChannelData)i.next();
                            channels.put(channel, ref.getChannelColor(channel.getIndex()));
                        }
                    } else {
                        while (i.hasNext()) {
                            channels.put(i.next(), null);
                        }
                    }
                    ChannelMetadataLoader.this.results = channels;
                } else {
                    ChannelMetadataLoader.this.results = l;
                }
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.results;
    }

    public ChannelMetadataLoader(long pixelsID, long userID) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.loadCall = this.makeBatchCall(pixelsID, userID);
    }
}

