/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMRefreshLoader
extends BatchCallTree {
    private Object results;
    private BatchCall loadCall;

    private void retrieveData(Class rootNodeType, Map<Long, List> nodes, Map<Long, Object> mapResult) throws Exception {
        OmeroDataService os = this.context.getDataService();
        Iterator<Map.Entry<Long, List>> users = nodes.entrySet().iterator();
        long groupID = -1L;
        while (users.hasNext()) {
            Object result;
            Map.Entry<Long, List> entry = users.next();
            long userID = entry.getKey();
            List containers = entry.getValue();
            if (containers == null || containers.size() == 0) {
                result = os.loadContainerHierarchy(rootNodeType, null, false, userID, groupID);
                if (mapResult.containsKey(userID)) {
                    Set s = (Set)mapResult.get(userID);
                    s.addAll(result);
                    continue;
                }
                mapResult.put(userID, result);
                continue;
            }
            Set set = os.loadContainerHierarchy(rootNodeType, null, false, userID, groupID);
            Iterator i = containers.iterator();
            ArrayList<Long> ids = new ArrayList<Long>(containers.size());
            while (i.hasNext()) {
                ids.add(new Long(((DataObject)i.next()).getId()));
            }
            Iterator j = set.iterator();
            HashSet<DataObject> children = null;
            Class<DatasetData> klass = null;
            HashMap topNodes = new HashMap(set.size());
            while (j.hasNext()) {
                HashSet newChildren = new HashSet();
                DataObject parent = (DataObject)j.next();
                if (parent instanceof ProjectData) {
                    children = ((ProjectData)parent).getDatasets();
                    klass = DatasetData.class;
                } else if (parent instanceof ScreenData) {
                    children = null;
                    klass = ScreenData.class;
                } else if (parent instanceof DatasetData) {
                    children = new HashSet<DataObject>(1);
                    children.add(parent);
                    klass = DatasetData.class;
                }
                topNodes.put(parent, newChildren);
                if (children == null) continue;
                for (DataObject child : children) {
                    Long id = new Long(child.getId());
                    if (ids.contains(id)) {
                        ArrayList<Long> cIds = new ArrayList<Long>(1);
                        cIds.add(id);
                        Set r = os.loadContainerHierarchy(klass, cIds, true, userID, groupID);
                        Iterator k = r.iterator();
                        while (k.hasNext()) {
                            newChildren.add(k.next());
                        }
                        continue;
                    }
                    newChildren.add(child);
                }
            }
            result = topNodes;
            if (mapResult.containsKey(userID)) {
                Map map = (Map)mapResult.get(userID);
                map.putAll((Map)result);
                continue;
            }
            mapResult.put(userID, result);
        }
    }

    private BatchCall makeBatchCall(final Class rootNodeType, final Map<Long, List> nodes) {
        return new BatchCall("Loading container tree: "){

            public void doCall() throws Exception {
                HashMap r = new HashMap(nodes.size());
                DMRefreshLoader.this.results = r;
                DMRefreshLoader.this.retrieveData(rootNodeType, nodes, r);
            }
        };
    }

    private BatchCall makeImagesBatchCall(final Map<Long, List> nodes) {
        return new BatchCall("Loading images: "){

            public void doCall() throws Exception {
                OmeroDataService os = DMRefreshLoader.this.context.getDataService();
                for (Map.Entry entry : nodes.entrySet()) {
                    long userID = (Long)entry.getKey();
                    List containers = (List)entry.getValue();
                    for (TimeRefObject ref : containers) {
                        ref.setResults(os.getImagesPeriod(ref.getStartTime(), ref.getEndTime(), userID, true));
                    }
                }
                DMRefreshLoader.this.results = nodes;
            }
        };
    }

    private BatchCall makeGroupsBatchCall(final Map<Long, List> nodes) {
        return new BatchCall("Loading groups: "){

            public void doCall() throws Exception {
                AdminService svc = DMRefreshLoader.this.context.getAdminService();
                Iterator i = nodes.entrySet().iterator();
                Boolean admin = (Boolean)DMRefreshLoader.this.context.lookup("/users/administrator");
                if (admin != null && admin.booleanValue()) {
                    List<GroupData> groups = svc.loadGroups(-1L);
                    ArrayList<GroupData> r = new ArrayList<GroupData>();
                    ArrayList<Long> toRemove = new ArrayList<Long>();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        List list = (List)entry.getValue();
                        Iterator j = list.iterator();
                        while (j.hasNext()) {
                            long groupID = (Long)j.next();
                            List<GroupData> l = svc.loadGroups(groupID);
                            toRemove.add(groupID);
                            if (l.size() != 1) continue;
                            r.add(l.get(0));
                        }
                    }
                    for (GroupData g : groups) {
                        if (toRemove.contains(g.getId())) continue;
                        r.add(g);
                    }
                    DMRefreshLoader.this.results = r;
                } else {
                    ExperimenterData exp = (ExperimenterData)DMRefreshLoader.this.context.lookup("/current_user/details");
                    List<GroupData> groups = svc.reloadPIGroups(exp);
                    Iterator<GroupData> g = groups.iterator();
                    ArrayList<GroupData> toKeep = new ArrayList<GroupData>();
                    while (g.hasNext()) {
                        GroupData gd = g.next();
                        Set leaders = gd.getLeaders();
                        if (leaders == null) continue;
                        for (ExperimenterData leader : leaders) {
                            if (leader.getId() != exp.getId()) continue;
                            toKeep.add(gd);
                        }
                    }
                    DMRefreshLoader.this.results = toKeep;
                }
            }
        };
    }

    private BatchCall makeFilesBatchCall(final Map<Long, List> nodes) {
        return new BatchCall("Loading files: "){

            public void doCall() throws Exception {
                OmeroMetadataService os = DMRefreshLoader.this.context.getMetadataService();
                Iterator users = nodes.keySet().iterator();
                while (users.hasNext()) {
                    long userID = (Long)users.next();
                    List containers = (List)nodes.get(userID);
                    for (TimeRefObject ref : containers) {
                        ref.setResults(os.loadFiles(ref.getFileType(), userID));
                    }
                }
                DMRefreshLoader.this.results = nodes;
            }
        };
    }

    private BatchCall makeTagsBatchCall(final Map<Long, List> nodes) {
        return new BatchCall("Loading files: "){

            public void doCall() throws Exception {
                OmeroMetadataService os = DMRefreshLoader.this.context.getMetadataService();
                Iterator users = nodes.keySet().iterator();
                HashMap<Long, Collection> r = new HashMap<Long, Collection>(nodes.size());
                while (users.hasNext()) {
                    long userID = (Long)users.next();
                    Collection result = os.loadTags(-1L, false, true, userID, -1L);
                    r.put(userID, result);
                }
                DMRefreshLoader.this.results = r;
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.results;
    }

    public DMRefreshLoader(Class rootNodeType, Map<Long, List> nodes) {
        if (rootNodeType == null) {
            throw new IllegalArgumentException("No root node type.");
        }
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No container with images.");
        }
        if (ImageData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeImagesBatchCall(nodes);
        } else if (ProjectData.class.equals((Object)rootNodeType) || ScreenData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeBatchCall(rootNodeType, nodes);
        } else if (FileAnnotationData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeFilesBatchCall(nodes);
        } else if (TagAnnotationData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeTagsBatchCall(nodes);
        } else if (GroupData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeGroupsBatchCall(nodes);
        }
    }
}

