/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import pojos.DataObject;
import pojos.ImageData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailLoader
extends BatchCallTree {
    private Collection<DataObject> images;
    private int maxWidth;
    private int maxHeight;
    private Object currentThumbnail;
    private boolean pixelsCall;
    private long pixelsID;
    private Set<Long> userIDs;
    private OmeroImageService service;
    private boolean asImage;

    private void loadThumbail(ImageData image, long userID) {
        PixelsData pxd = null;
        boolean valid = true;
        try {
            pxd = image.getDefaultPixels();
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedImage thumbPix = null;
        if (pxd == null) {
            valid = false;
            thumbPix = Factory.createDefaultImageThumbnail(-1);
        } else {
            int sizeX = this.maxWidth;
            int sizeY = this.maxHeight;
            if (this.asImage) {
                sizeX = pxd.getSizeX();
                sizeY = pxd.getSizeY();
            } else {
                Dimension d = Factory.computeThumbnailSize(sizeX, sizeY, pxd.getSizeX(), pxd.getSizeY());
                sizeX = d.width;
                sizeY = d.height;
            }
            try {
                thumbPix = this.service.getThumbnail(pxd.getId(), sizeX, sizeY, userID);
            }
            catch (RenderingServiceException e) {
                this.context.getLogger().error((Object)this, "Cannot retrieve thumbnail: " + e.getExtendedMessage());
            }
            if (thumbPix == null) {
                valid = false;
                thumbPix = Factory.createDefaultImageThumbnail(sizeX, sizeY);
            }
        }
        this.currentThumbnail = new ThumbnailData(image.getId(), thumbPix, userID, valid);
    }

    private BatchCall makeBatchCall() {
        return new BatchCall("Loading thumbnail for: " + this.pixelsID){

            public void doCall() throws Exception {
                BufferedImage thumbPix = null;
                try {
                    thumbPix = ThumbnailLoader.this.service.getThumbnail(ThumbnailLoader.this.pixelsID, ThumbnailLoader.this.maxWidth, ThumbnailLoader.this.maxHeight, -1L);
                }
                catch (RenderingServiceException e) {
                    ThumbnailLoader.this.context.getLogger().error((Object)this, "Cannot retrieve thumbnail from ID: " + e.getExtendedMessage());
                }
                if (thumbPix == null) {
                    thumbPix = Factory.createDefaultImageThumbnail(-1);
                }
                ThumbnailLoader.this.currentThumbnail = thumbPix;
            }
        };
    }

    @Override
    protected void buildTree() {
        if (this.pixelsCall) {
            this.add(this.makeBatchCall());
            return;
        }
        for (Long id : this.userIDs) {
            final long userID = id;
            for (ImageData imageData : this.images) {
                String description = "Loading thumbnail: " + imageData.getName();
                final ImageData index = imageData;
                this.add(new BatchCall(description){

                    public void doCall() {
                        ThumbnailLoader.this.loadThumbail(index, userID);
                    }
                });
            }
        }
    }

    @Override
    protected Object getPartialResult() {
        return this.currentThumbnail;
    }

    @Override
    protected Object getResult() {
        return null;
    }

    public ThumbnailLoader(Set<DataObject> imgs, int maxWidth, int maxHeight, Set<Long> userIDs) {
        if (imgs == null) {
            throw new NullPointerException("No images.");
        }
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + maxWidth + ".");
        }
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxHeight + ".");
        }
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.images = imgs;
        this.userIDs = userIDs;
        this.asImage = false;
        this.service = this.context.getImageService();
    }

    public ThumbnailLoader(Collection<DataObject> imgs, long userID) {
        if (imgs == null) {
            throw new NullPointerException("No images.");
        }
        this.asImage = true;
        this.images = imgs;
        this.userIDs = new HashSet<Long>(1);
        this.userIDs.add(userID);
        this.service = this.context.getImageService();
    }

    public ThumbnailLoader(Collection<DataObject> imgs, int maxWidth, int maxHeight, long userID) {
        if (imgs == null) {
            throw new NullPointerException("No images.");
        }
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + maxWidth + ".");
        }
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxHeight + ".");
        }
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.images = imgs;
        this.userIDs = new HashSet<Long>(1);
        this.userIDs.add(userID);
        this.asImage = false;
        this.service = this.context.getImageService();
    }

    public ThumbnailLoader(ImageData image, int maxWidth, int maxHeight, long userID) {
        if (image == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + maxWidth + ".");
        }
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxHeight + ".");
        }
        this.userIDs = new HashSet<Long>(1);
        this.userIDs.add(userID);
        this.images = new HashSet<DataObject>(1);
        this.images.add((DataObject)image);
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.asImage = false;
        this.service = this.context.getImageService();
    }

    public ThumbnailLoader(long pixelsID, int maxWidth, int maxHeight, long userID) {
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive id: " + pixelsID + ".");
        }
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + maxWidth + ".");
        }
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxHeight + ".");
        }
        this.pixelsCall = true;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.pixelsID = pixelsID;
        this.userIDs = new HashSet<Long>(1);
        this.userIDs.add(userID);
        this.service = this.context.getImageService();
    }

    public ThumbnailLoader(ImageData image, int maxWidth, int maxHeight, Set<Long> userIDs) {
        if (image == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + maxWidth + ".");
        }
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxHeight + ".");
        }
        this.images = new HashSet<DataObject>(1);
        this.images.add((DataObject)image);
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.userIDs = userIDs;
        this.asImage = false;
        this.service = this.context.getImageService();
    }
}

