/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.MonitorFactory;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.StartupException;

public final class DataServicesInit
extends InitializationTask {
    String getName() {
        return "Starting data management services";
    }

    void configure() {
    }

    void execute() throws StartupException {
        try {
            DataServicesFactory factory = DataServicesFactory.getInstance(this.container);
            OmeroImageService rds = factory.getIS();
            Registry reg = this.container.getRegistry();
            RegistryFactory.linkIS(rds, reg);
            RegistryFactory.linkOS(factory.getOS(), reg);
            RegistryFactory.linkMS(factory.getMS(), reg);
            RegistryFactory.linkAdmin(factory.getAdmin(), reg);
            MonitorFactory mf = new MonitorFactory();
            reg.bind("/services/data/views/MonitorFactory", mf);
        }
        catch (DSOutOfServiceException e) {
            throw new StartupException("Can't connect to OMERO", e);
        }
    }

    void rollback() {
        try {
            DataServicesFactory factory = DataServicesFactory.getInstance(this.container);
            factory.shutdown();
        }
        catch (DSOutOfServiceException dSOutOfServiceException) {
            // empty catch block
        }
    }
}

