/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import omero.api.delete.DeleteReport;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.ProjectData;

class ActivityResultRow
extends JPanel
implements ActionListener {
    static final String ACTION_PROPERTY = "action";
    private static final int DOWNLOAD = 0;
    private static final int VIEW = 1;
    private static final int PLOT = 2;
    private ActivityComponent activity;
    private Object row;
    private String name;

    private void buildGUI() {
        String text = "";
        if (this.row instanceof ImageData) {
            ImageData data = (ImageData)this.row;
            text = data.isLoaded() ? text + data.getName() : text + "Image";
            text = text + " ID:" + data.getId();
        } else if (this.row instanceof DatasetData) {
            DatasetData data = (DatasetData)this.row;
            text = data.isLoaded() ? text + data.getName() : text + "Dataset";
            text = text + " ID:" + data.getId();
        } else if (this.row instanceof ProjectData) {
            ProjectData data = (ProjectData)this.row;
            text = data.isLoaded() ? text + data.getName() : text + "Project";
            text = text + " ID:" + data.getId();
        } else if (this.row instanceof FileAnnotationData) {
            FileAnnotationData data = (FileAnnotationData)this.row;
            text = data.isLoaded() ? text + data.getFileName() : text + "Annotation";
            text = text + " ID:" + data.getId();
        } else if (this.row instanceof OriginalFile) {
            OriginalFile data = (OriginalFile)this.row;
            if (data.isLoaded()) {
                if (data.getName() != null) {
                    text = text + data.getName().getValue();
                }
            } else {
                text = text + "File";
            }
            text = text + " ID:" + data.getId().getValue();
        } else if (this.row instanceof DeleteReport) {
            DeleteReport report = (DeleteReport)this.row;
            Map undeletedFiles = report.undeletedFiles;
            int count = 0;
            Iterator i = undeletedFiles.keySet().iterator();
            while (i.hasNext()) {
                count += ((long[])undeletedFiles.get(i.next())).length;
            }
            text = this.convertReport(report.error);
            if (count > 0) {
                text = text + " Unable to delete " + count + " file";
                if (count > 1) {
                    text = text + "s";
                }
            }
        } else {
            text = this.row.toString();
        }
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(text));
        if (this.activity.isDownloadable(this.row)) {
            this.add(Box.createHorizontalStrut(5));
            this.add(this.activity.createButton("Download", 0, this));
        }
        if (this.activity.isViewable(this.row)) {
            this.add(Box.createHorizontalStrut(5));
            this.add(this.activity.createButton(this.activity.getViewText(this.row), 1, this));
        }
        if (this.activity.canPlotResult(this.row)) {
            this.add(Box.createHorizontalStrut(5));
            this.add(this.activity.createButton("Plot", 2, this));
        }
    }

    private String convertReport(String error) {
        if (error == null) {
            return "";
        }
        if (error.startsWith("ConstraintViolation")) {
            return "Object used by others.";
        }
        return error;
    }

    ActivityResultRow(Object row, ActivityComponent activity) {
        this("", row, activity);
    }

    ActivityResultRow(String name, Object row, ActivityComponent activity) {
        this.activity = activity;
        this.row = row;
        this.name = name;
        this.buildGUI();
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange(ACTION_PROPERTY, (Object)false, (Object)true);
                this.activity.download(this.name, this.row);
                break;
            }
            case 1: {
                this.firePropertyChange(ACTION_PROPERTY, (Object)false, (Object)true);
                this.activity.view(this.row);
                break;
            }
            case 2: {
                this.firePropertyChange(ACTION_PROPERTY, (Object)false, (Object)true);
                this.activity.plotResult(this.row);
            }
        }
    }
}

