/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFrame;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.AnalysisActivityParam;
import org.openmicroscopy.shoola.env.data.model.AnalysisParam;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.Analyser;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import pojos.FileAnnotationData;

public class AnalysisActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATION = "Analysing";
    private static final String DESCRIPTION_CREATED = "Analysis finished";
    private static final String DESCRIPTION_CANCEL = "Analysis cancelled";
    private AnalysisActivityParam parameters;

    public AnalysisActivity(UserNotifier viewer, Registry registry, AnalysisActivityParam parameters) {
        super(viewer, registry, DESCRIPTION_CREATION, parameters.getIcon());
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
    }

    protected UserNotifierLoader createLoader() {
        AnalysisParam param = (AnalysisParam)this.parameters.getParameters();
        this.loader = new Analyser(this.viewer, this.registry, param, param.getIds(), param.getNodeType(), param.getIndex(), this);
        return this.loader;
    }

    protected void notifyActivityEnd() {
        this.type.setText(DESCRIPTION_CREATED);
    }

    protected void notifyDownload() {
        if (!(this.result instanceof FileAnnotationData)) {
            this.downloadButton.setEnabled(false);
            return;
        }
        final FileAnnotationData data = (FileAnnotationData)this.result;
        JFrame f = this.registry.getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 1, "Download", "Select where to download the results.", null, true);
        IconManager icons = IconManager.getInstance(this.registry);
        chooser.setTitleIcon(icons.getIcon(18));
        chooser.setSelectedFileFull(data.getFileName());
        chooser.setApproveButtonText("Download");
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    File folder = (File)evt.getNewValue();
                    if (data == null) {
                        return;
                    }
                    OriginalFile f = (OriginalFile)data.getContent();
                    IconManager icons = IconManager.getInstance(AnalysisActivity.this.registry);
                    DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(17));
                    activity.setLegend(data.getDescription());
                    activity.setLegendExtension("_legend.csv");
                    AnalysisActivity.this.viewer.notifyActivity(activity);
                }
            }
        });
        chooser.centerDialog();
    }

    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    protected void notifyActivityError() {
    }
}

