/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ProcessCallback;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovieCreator
extends UserNotifierLoader {
    private CallHandle handle;
    private ImageData image;
    private MovieExportParam param;
    private List<Integer> channels;
    private ProcessCallback callBack;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to create movie", message, ex);
    }

    public MovieCreator(UserNotifier viewer, Registry registry, MovieExportParam param, List<Integer> channels, ImageData image, ActivityComponent activity) {
        super(viewer, registry, activity);
        if (image == null) {
            throw new IllegalArgumentException("Image not valid.");
        }
        if (param == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        this.param = param;
        if (channels == null) {
            channels = new ArrayList<Integer>();
        }
        this.channels = channels;
        this.image = image;
    }

    @Override
    public void load() {
        long pixelsID = this.image.getDefaultPixels().getId();
        this.handle = this.ivView.createMovie(this.image.getId(), pixelsID, this.channels, this.param, this);
    }

    @Override
    public void cancel() {
        try {
            if (this.callBack != null) {
                this.callBack.cancel();
                this.activity.onActivityCancelled();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                if (!b.booleanValue()) {
                    this.onException("Unable to start the script.", null);
                }
            } else {
                this.callBack = (ProcessCallback)o;
                this.callBack.setAdapter(this);
                this.activity.onCallBackSet();
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (result instanceof Boolean) {
            Boolean b = (Boolean)result;
            if (!b.booleanValue()) {
                this.onException("Unable to start the script.", null);
            }
        } else if (!(result instanceof Boolean)) {
            this.activity.endActivity(result);
        }
    }
}

