/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TaskBarManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class TaskBarView
extends JFrame
implements TaskBar {
    static final int EXIT_MI = 0;
    static final int CONNECT_MI = 1;
    static final int DISCONNECT_MI = 2;
    static final int WELCOME_MI = 3;
    static final int HELP_MI = 4;
    static final int HOWTO_MI = 5;
    static final int UPDATES_MI = 6;
    static final int ABOUT_MI = 7;
    static final int EXIT_BTN = 8;
    static final int CONNECT_BTN = 9;
    static final int DISCONNECT_BTN = 10;
    static final int HELP_BTN = 11;
    static final int COMMENT_MI = 12;
    static final int FORUM_MI = 13;
    static final int ACTIVITY_MI = 14;
    static final int LOG_FILE_MI = 15;
    private static final int MAX_ID = 15;
    private static final String TITLE = "Open Microscopy Environment";
    private AbstractButton[] buttons;
    private JMenu[] menus;
    private JToolBar[] toolbars;
    private IconManager iconManager;
    private Set<JMenu> windowMenus;
    private Set<JMenu> helpMenus;
    private Set<JMenuBar> menubars;
    private JMenuBar originalBar;
    private TaskBarManager manager;

    private void createMenuItems() {
        this.buttons[0] = new JMenuItem("Exit", this.iconManager.getIcon(3));
        this.buttons[1] = new JMenuItem("Connect to OMEDS", this.iconManager.getIcon(1));
        this.buttons[2] = new JMenuItem("Disconnect from OMEDS", this.iconManager.getIcon(2));
        this.buttons[3] = new JMenuItem("Welcome...", this.iconManager.getIcon(7));
        this.buttons[4] = new JMenuItem("Help Contents", this.iconManager.getIcon(0));
        this.buttons[5] = new JMenuItem("How To...", this.iconManager.getIcon(8));
        String aboutName = "About " + this.manager.getSoftwareName() + "...";
        this.buttons[6] = new JMenuItem(aboutName, this.iconManager.getIcon(9));
        this.buttons[7] = new JMenuItem("About OMERO", IconManager.getOMEIcon());
        this.buttons[12] = new JMenuItem("Send Feedback...", this.iconManager.getIcon(11));
        this.buttons[13] = new JMenuItem("Forum", this.iconManager.getIcon(16));
        this.buttons[15] = new JMenuItem("Show Log File", this.iconManager.getIcon(20));
        this.buttons[14] = new JMenuItem("Activities...", this.iconManager.getIcon(19));
    }

    private JMenu copyItemsFromMenu(JMenu original) {
        Component[] comps = original.getPopupMenu().getComponents();
        JMenu menu = new JMenu();
        menu.setText(original.getText());
        menu.setToolTipText(original.getToolTipText());
        ActionListener[] al = original.getActionListeners();
        for (int j = 0; j < al.length; ++j) {
            menu.addActionListener(al[j]);
        }
        MenuKeyListener[] mkl = original.getMenuKeyListeners();
        for (int j = 0; j < mkl.length; ++j) {
            menu.addMenuKeyListener(mkl[j]);
        }
        MenuListener[] ml = original.getMenuListeners();
        for (int j = 0; j < ml.length; ++j) {
            menu.addMenuListener(ml[j]);
        }
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof JMenu) {
                menu.add(this.copyItemsFromMenu((JMenu)comps[i]));
                continue;
            }
            if (!(comps[i] instanceof JMenuItem)) continue;
            menu.add(this.copyItem((JMenuItem)comps[i]));
        }
        return menu;
    }

    private JMenuItem copyItem(JMenuItem original) {
        JMenuItem item = new JMenuItem(original.getAction());
        item.setIcon(original.getIcon());
        item.setText(original.getText());
        item.setToolTipText(original.getToolTipText());
        ActionListener[] al = original.getActionListeners();
        for (int j = 0; j < al.length; ++j) {
            item.addActionListener(al[j]);
        }
        return item;
    }

    private JMenu createFileMenu() {
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        file.add(this.buttons[0]);
        return file;
    }

    private JMenu createConnectMenu() {
        JMenu connect = new JMenu("Connect");
        connect.setMnemonic(67);
        connect.add(this.buttons[1]);
        connect.add(this.buttons[2]);
        return connect;
    }

    private JMenu createTasksMenu() {
        JMenu tasks = new JMenu("Tasks");
        tasks.setMnemonic(84);
        return tasks;
    }

    private JMenu createWindowMenu() {
        JMenu window = new JMenu("Window");
        window.setMnemonic(87);
        window.add(this.buttons[14]);
        return window;
    }

    private JMenu createHelpMenu() {
        JMenu help = new JMenu("Help");
        help.setMnemonic(72);
        help.add(this.buttons[12]);
        help.add(this.buttons[4]);
        help.add(this.buttons[13]);
        help.add(this.buttons[15]);
        help.add(this.buttons[6]);
        return help;
    }

    private JMenuBar createMenuBar() {
        this.createMenuItems();
        this.menus[0] = this.createWindowMenu();
        this.menus[1] = this.createHelpMenu();
        JMenuBar bar = new JMenuBar();
        for (int i = 0; i < this.menus.length; ++i) {
            bar.add(this.menus[i]);
        }
        return bar;
    }

    private void createButtons() {
        this.buttons[9] = new JButton(this.iconManager.getIcon(1));
        this.buttons[9].setToolTipText(UIUtilities.formatToolTipText("Connect to OMERO."));
        this.buttons[10] = new JButton(this.iconManager.getIcon(2));
        this.buttons[10].setToolTipText(UIUtilities.formatToolTipText("Disconnect from OMERO."));
        this.buttons[11] = new JButton(this.iconManager.getIcon(0));
        this.buttons[11].setToolTipText(UIUtilities.formatToolTipText("Bring up help contents."));
        this.buttons[8] = new JButton(this.iconManager.getIcon(3));
        this.buttons[8].setToolTipText(UIUtilities.formatToolTipText("Exit the application."));
    }

    private JToolBar createToolBar() {
        JToolBar bar = new JToolBar();
        bar.setBorder(BorderFactory.createEtchedBorder());
        bar.setFloatable(false);
        bar.putClientProperty("JToolBar.isRollover", true);
        return bar;
    }

    private JPanel createToolBarsPanel() {
        this.createButtons();
        JToolBar file = this.createToolBar();
        JToolBar connect = this.createToolBar();
        JToolBar help = this.createToolBar();
        file.add(this.buttons[8]);
        connect.add(this.buttons[9]);
        connect.add(this.buttons[10]);
        help.add(this.buttons[11]);
        JPanel bars = new JPanel();
        JPanel outerPanel = new JPanel();
        bars.setBorder(null);
        bars.setLayout(new BoxLayout(bars, 0));
        bars.add(file);
        bars.add(connect);
        bars.add(help);
        outerPanel.setBorder(null);
        outerPanel.setLayout(new BoxLayout(outerPanel, 0));
        outerPanel.add(bars);
        outerPanel.add(Box.createRigidArea(new Dimension(100, 16)));
        outerPanel.add(Box.createHorizontalGlue());
        return outerPanel;
    }

    private void buildGUI() {
        this.setIconImage(IconManager.getOMEImageIcon());
        this.originalBar = this.createMenuBar();
        this.menubars.add(this.originalBar);
        this.createToolBarsPanel();
    }

    private JMenuBar copyMenuBar() {
        JMenuBar bar = new JMenuBar();
        for (int i = 0; i < this.originalBar.getMenuCount(); ++i) {
            JMenu menu = this.originalBar.getMenu(i);
            JMenu copy = this.copyItemsFromMenu(menu);
            bar.add(copy);
            if (menu == this.menus[0]) {
                this.windowMenus.add(copy);
                continue;
            }
            if (menu != this.menus[1]) continue;
            this.helpMenus.add(copy);
        }
        return bar;
    }

    TaskBarView(TaskBarManager manager, IconManager im) {
        super(TITLE);
        this.manager = manager;
        this.buttons = new AbstractButton[16];
        this.menus = new JMenu[2];
        this.iconManager = im;
        this.windowMenus = new HashSet<JMenu>();
        this.helpMenus = new HashSet<JMenu>();
        this.menubars = new HashSet<JMenuBar>();
        this.buildGUI();
    }

    AbstractButton getButton(int id) {
        return this.buttons[id];
    }

    public void addToMenu(int menuID, JMenuItem entry) {
        block7: {
            block6: {
                if (menuID < 0 || this.menus.length <= menuID) {
                    throw new IllegalArgumentException("Invalid menu id: " + menuID + ".");
                }
                if (entry == null) {
                    throw new NullPointerException("No entry");
                }
                this.menus[menuID].add(entry);
                if (menuID != 0) break block6;
                for (JMenu menu : this.windowMenus) {
                    if (entry instanceof JMenu) {
                        menu.add(this.copyItemsFromMenu((JMenu)entry));
                        continue;
                    }
                    menu.add(this.copyItem(entry));
                }
                break block7;
            }
            if (menuID != 1) break block7;
            for (JMenu menu : this.helpMenus) {
                if (entry instanceof JMenu) {
                    menu.add(this.copyItemsFromMenu((JMenu)entry));
                    continue;
                }
                menu.add(this.copyItem(entry));
            }
        }
    }

    public void removeFromMenu(int menuID, JMenuItem entry) {
        if (menuID < 0 || this.menus.length <= menuID) {
            throw new IllegalArgumentException("Invalid menu id: " + menuID + ".");
        }
        if (menuID == 0 && entry instanceof JMenu) {
            for (JMenu menu : this.windowMenus) {
                Component[] comps = menu.getPopupMenu().getComponents();
                for (int j = 0; j < comps.length; ++j) {
                    Component c = comps[j];
                    if (!(c instanceof JMenu) || !((JMenu)c).getText().equals(entry.getText())) continue;
                    menu.remove(c);
                }
            }
        } else if (menuID == 1 && entry instanceof JMenu) {
            for (JMenu menu : this.helpMenus) {
                Component[] comps = menu.getPopupMenu().getComponents();
                for (int j = 0; j < comps.length; ++j) {
                    Component c = comps[j];
                    if (!(c instanceof JMenu) || ((JMenu)c).getText() != entry.getText()) continue;
                    menu.remove(c);
                }
            }
        }
        this.menus[menuID].remove(entry);
    }

    public void addToToolBar(int toolBarID, AbstractButton entry) {
        if (toolBarID < 0 || this.toolbars.length <= toolBarID) {
            throw new IllegalArgumentException("Invalid menu id: " + toolBarID + ".");
        }
        if (entry == null) {
            throw new NullPointerException("No entry");
        }
        this.toolbars[toolBarID].add(entry);
    }

    public void removeFromToolBar(int toolBarID, AbstractButton entry) {
        if (toolBarID < 0 || this.toolbars.length <= toolBarID) {
            throw new IllegalArgumentException("Invalid menu id: " + toolBarID + ".");
        }
        this.toolbars[toolBarID].remove(entry);
    }

    public void setVisible(boolean b) {
        super.setVisible(false);
    }

    public JFrame getFrame() {
        return this;
    }

    public JMenuBar getTaskBarMenuBar() {
        return this.copyMenuBar();
    }

    public JMenu getWindowsMenu() {
        JMenu menu = this.createWindowMenu();
        Component[] comps = this.menus[0].getPopupMenu().getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof JMenu) {
                menu.add(this.copyItemsFromMenu((JMenu)comps[i]));
                continue;
            }
            if (!(comps[i] instanceof JMenuItem)) continue;
            menu.add(this.copyItem((JMenuItem)comps[i]));
        }
        this.windowMenus.add(menu);
        return menu;
    }

    public JMenu getHelpMenu() {
        JMenu menu = this.createHelpMenu();
        Component[] comps = this.menus[1].getPopupMenu().getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof JMenu) {
                menu.add(this.copyItemsFromMenu((JMenu)comps[i]));
                continue;
            }
            if (!(comps[i] instanceof JMenuItem)) continue;
            menu.add(this.copyItem((JMenuItem)comps[i]));
        }
        this.helpMenus.add(menu);
        return menu;
    }

    public JMenuItem getCopyMenuItem(int index) {
        switch (index) {
            case 100: {
                return this.copyItem((JMenuItem)this.buttons[12]);
            }
            case 101: {
                return this.copyItem((JMenuItem)this.buttons[4]);
            }
        }
        return null;
    }

    public boolean login() {
        return this.manager.login();
    }

    public void openURL(String path) {
        this.manager.openURL(path);
    }
}

