/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui.flim;

import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openmicroscopy.shoola.env.ui.flim.FLIMResultsDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class TableIntervals
extends JTable {
    private static final int COLUMNS = 3;
    private static final int INDEX_PERCENTAGE = 2;
    private static final int INDEX_NUMBER_OF_PIXELS = 1;
    private static final int INDEX_INTERVAL = 0;
    private FLIMResultsDialog parent;
    private TableIntervalsModel model;
    private TableModelListener listener;

    private void populateRow(int row) {
        Double number;
        String value = (String)this.getValueAt(row, 0);
        if (value == null) {
            return;
        }
        String[] values = value.split("-");
        Double lowerBound = null;
        Double upperBound = null;
        int n = values.length;
        if (n == 0) {
            return;
        }
        if (n == 1) {
            try {
                lowerBound = Double.parseDouble(values[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (n > 1) {
            try {
                lowerBound = Double.parseDouble(values[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                upperBound = Double.parseDouble(values[1]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((number = this.parent.getValueInInterval(lowerBound, upperBound)) != null) {
            this.model.removeTableModelListener(this.listener);
            this.model.setValueAt(number.intValue(), row, 1);
            Double total = this.parent.getTotalValue();
            if (total == 0.0) {
                this.model.setValueAt(0, row, 2);
            } else {
                double v = UIUtilities.roundTwoDecimals(number / total * 100.0);
                this.model.setValueAt(v, row, 2);
            }
            this.model.addTableModelListener(this.listener);
        }
    }

    private void initComponents(String nameYAxis) {
        Object[] names = new String[]{"Interval e.g. 1-3", nameYAxis, "Percentage %"};
        this.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        this.setSurrendersFocusOnKeystroke(true);
        this.setSelectionMode(0);
        Object[][] objects = new Object[1][3];
        for (int i = 0; i < 3; ++i) {
            objects[0][i] = null;
        }
        this.model = new TableIntervalsModel(objects, names);
        this.setModel(this.model);
        this.getTableHeader().setReorderingAllowed(false);
        this.highlightRow(this.model.getRowCount() - 1);
        this.listener = new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                if (evt.getType() == 0) {
                    TableIntervals.this.populateRow(evt.getFirstRow());
                    TableIntervals.this.addEmptyRow();
                }
            }
        };
        this.model.addTableModelListener(this.listener);
    }

    private void highlightRow(int row) {
        int n = this.model.getRowCount();
        int v = row == n - 1 ? n - 1 : row + 1;
        this.setRowSelectionInterval(v, v);
        this.setColumnSelectionInterval(0, 0);
    }

    private void addEmptyRow() {
        Object[] objects = new Object[3];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = null;
        }
        ((DefaultTableModel)this.getModel()).addRow(objects);
        this.highlightRow(this.model.getRowCount() - 1);
    }

    TableIntervals(FLIMResultsDialog parent, String nameYAxis) {
        this.parent = parent;
        this.initComponents(nameYAxis);
    }

    void populateTable() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.populateRow(i);
        }
    }

    class TableIntervalsModel
    extends DefaultTableModel {
        public TableIntervalsModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }
    }
}

