/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.file;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

class SheetInfo {
    private HSSFSheet sheet;
    private String name;
    private int index;
    private int currentRow;
    private HSSFPatriarch drawingPatriarch;

    SheetInfo(String name, int sheetIndex, HSSFSheet sheet) {
        this.sheet = sheet;
        this.name = name;
        this.index = sheetIndex;
        this.currentRow = 0;
    }

    HSSFCell getCell(int rowIndex, int columnIndex) {
        HSSFRow row = this.sheet.getRow(rowIndex);
        if (row == null) {
            row = this.sheet.createRow(rowIndex);
            return row.createCell(columnIndex);
        }
        HSSFCell cell = row.getCell(columnIndex);
        if (cell == null) {
            return row.createCell(columnIndex);
        }
        return cell;
    }

    void sizeColumnToFit(int columnIndex) {
        this.sheet.autoSizeColumn((int)((short)columnIndex));
    }

    void sizeAllColumnsToFit() {
        HashMap<Integer, Integer> colMap = new HashMap<Integer, Integer>();
        for (HSSFRow row : this.sheet) {
            Iterator k = row.cellIterator();
            while (k.hasNext()) {
                HSSFCell cell = (HSSFCell)k.next();
                colMap.put(cell.getColumnIndex(), cell.getRowIndex());
            }
        }
        Iterator colIterator = colMap.keySet().iterator();
        while (colIterator.hasNext()) {
            int col = (Integer)colIterator.next();
            this.sizeColumnToFit(col);
        }
    }

    void setRowHeight(int rowStart, int rowEnd, int rowHeight) {
        for (int index = rowStart; index <= rowEnd; ++index) {
            this.setRowHeight(index, rowHeight);
        }
    }

    void setRowHeight(int rowIndex, int rowHeight) {
        HSSFRow row = this.sheet.getRow(rowIndex);
        if (row == null) {
            row = this.sheet.createRow(rowIndex);
        }
        row.setHeight((short)rowHeight);
    }

    int getMaxColumn(int rowIndex) {
        HSSFRow row = this.sheet.getRow(rowIndex);
        if (row == null) {
            return 0;
        }
        return row.getLastCellNum();
    }

    int getIndex() {
        return this.index;
    }

    int getCurrentRow() {
        return this.currentRow;
    }

    void setCurrentRow(int row) {
        this.currentRow = row;
    }

    HSSFPatriarch getDrawingPatriarch() {
        if (this.drawingPatriarch == null) {
            this.drawingPatriarch = this.sheet.createDrawingPatriarch();
        }
        return this.drawingPatriarch;
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }
}

