/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class GIFFilter
extends CustomizedFileFilter {
    public static final String MIMETYPE = "image/gif";
    public static final String GIF = "gif";
    public static final String[] extensions = new String[1];
    private static final String description;

    public String getExtension() {
        return GIF;
    }

    public String getMIMEType() {
        return MIMETYPE;
    }

    public String getDescription() {
        return description;
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        GIFFilter.extensions[0] = GIF;
        String s = "GIF (";
        for (int i = 0; i < extensions.length; ++i) {
            s = s + "*." + extensions[i];
            if (i >= extensions.length - 1) continue;
            s = s + ", ";
        }
        description = s = s + ")";
    }
}

