/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class WordFilter
extends CustomizedFileFilter {
    public static final String WORD = "doc";
    public static final String WORD_X = "docx";
    public static final String WORD_T = "doct";
    public static final String[] extensions = new String[3];
    private static final String description;

    public String getMIMEType() {
        return "application/msword";
    }

    public String getExtension() {
        return WORD;
    }

    public String getDescription() {
        return description;
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        WordFilter.extensions[0] = WORD;
        WordFilter.extensions[1] = WORD_X;
        WordFilter.extensions[2] = WORD_T;
        String s = "Microsoft Word (";
        for (int i = 0; i < extensions.length; ++i) {
            s = s + "*." + extensions[i];
            if (i >= extensions.length - 1) continue;
            s = s + ", ";
        }
        description = s = s + ")";
    }
}

