/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi;

import java.awt.Color;
import java.awt.Component;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.io.IOConstants;
import org.openmicroscopy.shoola.util.roi.io.ServerROIStrategy;
import org.openmicroscopy.shoola.util.roi.io.XMLFileIOStrategy;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROICollection;
import org.openmicroscopy.shoola.util.roi.model.ROIRelationship;
import org.openmicroscopy.shoola.util.roi.model.ROIRelationshipList;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ROIShapeRelationship;
import org.openmicroscopy.shoola.util.roi.model.ROIShapeRelationshipList;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import pojos.ImageData;
import pojos.ROIData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROIComponent
extends Component {
    private static final Color TEXT_COLOR = IOConstants.DEFAULT_TEXT_COLOUR;
    private static final Color MEASUREMENT_COLOR = IOConstants.DEFAULT_MEASUREMENT_TEXT_COLOUR;
    private static final Color FILL_COLOR = IOConstants.DEFAULT_FILL_COLOUR;
    private static final Color FILL_COLOR_ALPHA = IOConstants.DEFAULT_FILL_COLOUR_ALPHA;
    private static final double FONT_SIZE = 12.0;
    private static final double STROKE_WIDTH = 1.0;
    private static final Color STROKE_COLOR = IOConstants.DEFAULT_STROKE_COLOUR;
    private static final Color STROKE_COLOR_ALPHA = IOConstants.DEFAULT_STROKE_COLOUR_ALPHA;
    private ROICollection roiCollection = new ROICollection();
    private XMLFileIOStrategy ioStrategy;
    private ServerROIStrategy serverStrategy;
    private MeasurementUnits units = new MeasurementUnits(0.0, 0.0, 0.0, false);
    private Map<Long, List<ROI>> roiResult = new LinkedHashMap<Long, List<ROI>>();

    private void setFigureAttributes(ROIFigure fig) {
        AttributeKeys.FONT_SIZE.set((Figure)fig, (Object)12.0);
        AttributeKeys.TEXT_COLOR.set((Figure)fig, (Object)TEXT_COLOR);
        AttributeKeys.STROKE_WIDTH.set((Figure)fig, (Object)1.0);
        MeasurementAttributes.SHOWID.set((Figure)fig, (Object)false);
        if (fig instanceof MeasureLineFigure) {
            MeasurementAttributes.SHOWMEASUREMENT.set((Figure)fig, (Object)true);
        } else {
            MeasurementAttributes.SHOWMEASUREMENT.set((Figure)fig, (Object)false);
        }
        MeasurementAttributes.MEASUREMENTTEXT_COLOUR.set((Figure)fig, (Object)MEASUREMENT_COLOR);
        DrawingAttributes.SHOWTEXT.set((Figure)fig, (Object)false);
        if (fig instanceof MeasurePointFigure) {
            AttributeKeys.FILL_COLOR.set((Figure)fig, (Object)FILL_COLOR_ALPHA);
            AttributeKeys.STROKE_COLOR.set((Figure)fig, (Object)STROKE_COLOR_ALPHA);
        } else {
            AttributeKeys.FILL_COLOR.set((Figure)fig, (Object)FILL_COLOR);
            AttributeKeys.STROKE_COLOR.set((Figure)fig, (Object)STROKE_COLOR);
        }
    }

    private void setShapeAnnotations(ROIShape shape) {
    }

    void removeROI(ROIFigure figure) throws NoSuchROIException {
        if (figure == null) {
            return;
        }
        long id = figure.getROI().getID();
        Coord3D coord = figure.getROIShape().getCoord3D();
        this.deleteShape(id, coord);
    }

    ROI createROI(ROIFigure figure, Coord3D currentPlane) throws ROICreationException, NoSuchROIException {
        ROI roi = this.createROI();
        ROIShape newShape = new ROIShape(roi, currentPlane, figure, figure.getBounds());
        this.addShape(roi.getID(), currentPlane, newShape);
        return roi;
    }

    public void setMicronsPixelX(double x) {
        this.units.setMicronsPixelX(x);
    }

    public double getMicronsPixelX() {
        return this.units.getMicronsPixelX();
    }

    public void setMicronsPixelY(double y) {
        this.units.setMicronsPixelY(y);
    }

    public double getMicronsPixelY() {
        return this.units.getMicronsPixelY();
    }

    public void setMicronsPixelZ(double z) {
        this.units.setMicronsPixelZ(z);
    }

    public double getMicronsPixelZ() {
        return this.units.getMicronsPixelZ();
    }

    public ROI addROI(ROIFigure figure, Coord3D currentPlane, boolean addAttribs) throws ROICreationException, NoSuchROIException {
        if (figure == null) {
            throw new NullPointerException("Figure param null.");
        }
        figure.setMeasurementUnits(this.units);
        if (addAttribs) {
            this.setFigureAttributes(figure);
        }
        ROI roi = null;
        roi = this.createROI(figure, currentPlane);
        if (roi == null) {
            throw new ROICreationException("Unable to create ROI.");
        }
        ROIShape shape = figure.getROIShape();
        this.setShapeAnnotations(shape);
        return roi;
    }

    public void saveROI(OutputStream output) throws ParsingException {
        if (output == null) {
            throw new NullPointerException("No input stream specified.");
        }
        if (this.ioStrategy == null) {
            this.ioStrategy = new XMLFileIOStrategy();
        }
        this.ioStrategy.write(output, this);
    }

    public List<ROIData> saveROI(ImageData image, long ownerID) throws Exception {
        if (this.serverStrategy == null) {
            this.serverStrategy = new ServerROIStrategy();
        }
        return this.serverStrategy.write(this, image, ownerID);
    }

    public List<ROI> loadROI(InputStream input) throws NoSuchROIException, ParsingException, ROICreationException {
        if (input == null) {
            throw new NullPointerException("No input stream specified.");
        }
        if (this.ioStrategy == null) {
            this.ioStrategy = new XMLFileIOStrategy();
        }
        return this.ioStrategy.read(input, this);
    }

    public List<ROI> loadROI(long fileID, Collection rois, boolean readOnly, long userID) throws NoSuchROIException, ROICreationException {
        if (rois == null) {
            throw new NullPointerException("No rois to transform.");
        }
        if (this.serverStrategy == null) {
            this.serverStrategy = new ServerROIStrategy();
        }
        List<ROI> l = this.serverStrategy.read(rois, this, readOnly, userID);
        if (fileID > 0L) {
            this.roiResult.put(fileID, l);
        }
        return l;
    }

    public List<ROI> getROIList(long fileID) {
        return this.roiResult.get(fileID);
    }

    public long getNextID() {
        return this.roiCollection.getNextID();
    }

    public ROI createROI(long id) throws ROICreationException {
        return this.roiCollection.createROI(id, true);
    }

    public ROI createROI(long id, boolean clientSideObject) throws ROICreationException {
        return this.roiCollection.createROI(id, clientSideObject);
    }

    public ROI createROI() throws ROICreationException {
        return this.roiCollection.createROI();
    }

    public ROI cloneROI(long id) throws ROICreationException, NoSuchROIException {
        ROI newROI = this.roiCollection.createROI();
        newROI.setAnnotations(this.roiCollection.getROI(id).getAnnotation());
        return newROI;
    }

    public TreeMap<Long, ROI> getROIMap() {
        return this.roiCollection.getROIMap();
    }

    public ROI getROI(long id) throws NoSuchROIException {
        return this.roiCollection.getROI(id);
    }

    public boolean containsROI(long id) {
        return this.roiCollection.containsROI(id);
    }

    public ROIShape getShape(long id, Coord3D coord) throws NoSuchROIException {
        return this.roiCollection.getShape(id, coord);
    }

    public boolean containsShape(long id, Coord3D coord) {
        if (!this.containsROI(id)) {
            return false;
        }
        try {
            ROI roi = this.getROI(id);
            return roi.containsShape(coord);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ShapeList getShapeList(Coord3D coord) throws NoSuchROIException {
        return this.roiCollection.getShapeList(coord);
    }

    public void deleteROI(long id) throws NoSuchROIException {
        this.roiCollection.deleteROI(id);
    }

    public void deleteShape(long id, Coord3D coord) throws NoSuchROIException {
        this.roiCollection.deleteShape(id, coord);
    }

    public void addShape(long id, Coord3D coord, ROIShape shape) throws ROICreationException, NoSuchROIException {
        this.roiCollection.addShape(id, coord, shape);
    }

    public List<ROIShape> propagateShape(long id, Coord3D selectedShape, Coord3D start, Coord3D end) throws ROICreationException, NoSuchROIException {
        return this.roiCollection.propagateShape(id, selectedShape, start, end);
    }

    public void deleteShape(long id, Coord3D start, Coord3D end) throws NoSuchROIException {
        this.roiCollection.deleteShape(id, start, end);
    }

    public void addROIRelationship(ROIRelationship relationship) {
        this.roiCollection.addROIRelationship(relationship);
    }

    public void addROIShapeRelationship(ROIShapeRelationship relationship) {
        this.roiCollection.addROIShapeRelationship(relationship);
    }

    public void removeROIRelationship(long relationship) {
        this.roiCollection.removeROIRelationship(relationship);
    }

    public void removeROIShapeRelationship(long relationship) {
        this.roiCollection.removeROIShapeRelationship(relationship);
    }

    public boolean containsROIRelationship(long relationship) {
        return this.roiCollection.containsROIRelationship(relationship);
    }

    public boolean containsROIShapeRelationship(long relationship) {
        return this.roiCollection.containsROIShapeRelationship(relationship);
    }

    public ROIRelationshipList getROIRelationshipList(long roiID) {
        return this.roiCollection.getROIRelationshipList(roiID);
    }

    public ROIShapeRelationshipList getROIShapeRelationshipList(long roiID) {
        return this.roiCollection.getROIShapeRelationshipList(roiID);
    }

    public void showMeasurementsInMicrons(boolean inMicrons) {
        this.units.setInMicrons(inMicrons);
    }

    public MeasurementUnits getMeasurementUnits() {
        return this.units;
    }
}

