/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureListener;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.LineConnectionTextFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureLineConnectionFigure
extends LineConnectionTextFigure
implements ROIFigure {
    private boolean readOnly;
    private boolean clientObject;
    private boolean dirty;
    private List<Rectangle2D> boundsArray;
    private List<Double> lengthArray = new ArrayList<Double>();
    private List<Double> angleArray = new ArrayList<Double>();
    private List<Double> pointArrayX = new ArrayList<Double>();
    private List<Double> pointArrayY = new ArrayList<Double>();
    protected ROI roi = null;
    protected ROIShape shape = null;
    private MeasurementUnits units;
    private int status = 0;

    public MeasureLineConnectionFigure() {
        this("Text", false);
    }

    public MeasureLineConnectionFigure(String text, boolean readOnly) {
        super(text);
        this.boundsArray = new ArrayList<Rectangle2D>();
        this.setReadOnly(readOnly);
    }

    public void draw(Graphics2D g) {
        super.draw(g);
        this.boundsArray.clear();
        this.lengthArray.clear();
        this.angleArray.clear();
        if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue() || ((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
            Rectangle2D rect;
            double sz;
            int x;
            Rectangle2D.Double bounds;
            if (this.getPointCount() == 2) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                double angle = this.getAngle(0, 1);
                if (angle > 90.0) {
                    angle = Math.abs(angle - 180.0);
                }
                this.angleArray.add(angle);
                String lineAngle = formatter.format(angle);
                lineAngle = this.addDegrees(lineAngle);
                double sz2 = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz2));
                Rectangle2D rect2 = g.getFontMetrics().getStringBounds(lineAngle, g);
                Point2D.Double lengthPoint = this.getLengthPosition(0, 1);
                bounds = new Rectangle2D.Double(lengthPoint.x, lengthPoint.y + rect2.getHeight() * 2.0, rect2.getWidth(), rect2.getHeight());
                g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(lineAngle, (int)((RectangularShape)bounds).getX(), (int)((RectangularShape)bounds).getY());
                this.boundsArray.add(bounds);
            }
            for (x = 1; x < this.getPointCount() - 1; ++x) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                double angle = this.getAngle(x - 1, x, x + 1);
                this.angleArray.add(angle);
                String lineAngle = formatter.format(angle);
                lineAngle = this.addDegrees(lineAngle);
                sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                rect = g.getFontMetrics().getStringBounds(lineAngle, g);
                bounds = new Rectangle2D.Double(this.getPoint((int)x).x, this.getPoint((int)x).y, rect.getWidth(), rect.getHeight());
                g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(lineAngle, (int)((RectangularShape)bounds).getX(), (int)((RectangularShape)bounds).getY());
                this.boundsArray.add(bounds);
            }
            for (x = 1; x < this.getPointCount(); ++x) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                double length = this.getLength(x - 1, x);
                this.lengthArray.add(length);
                String lineLength = formatter.format(length);
                lineLength = this.addUnits(lineLength);
                sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                rect = g.getFontMetrics().getStringBounds(lineLength, g);
                bounds = new Rectangle2D.Double(this.getPoint((int)x).x - 15.0, this.getPoint((int)x).y - 15.0, rect.getWidth() + 30.0, rect.getHeight() + 30.0);
                Point2D.Double lengthPoint = this.getLengthPosition(x - 1, x);
                g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(lineLength, (int)lengthPoint.x, (int)lengthPoint.y);
                this.boundsArray.add(bounds);
            }
            if (((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
                g.setColor(this.getTextColor());
                g.drawString(this.getROI().getID() + "", (int)this.path.getCenter().getX(), (int)this.path.getCenter().getY());
            }
        }
    }

    public void transform(AffineTransform tx) {
        if (!this.readOnly) {
            super.transform(tx);
        }
    }

    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly) {
            super.setBounds(anchor, lead);
        }
    }

    public List<Double> getLengthArray() {
        return this.lengthArray;
    }

    public List<Double> getAngleArray() {
        return this.angleArray;
    }

    public String addDegrees(String str) {
        return str + "\u00b0";
    }

    public String addUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m";
        }
        return str + "px";
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.boundsArray != null) {
            for (int i = 0; i < this.boundsArray.size(); ++i) {
                double diff;
                Rectangle2D bounds = this.boundsArray.get(i);
                if (newBounds.getX() > bounds.getX()) {
                    diff = newBounds.x - bounds.getX();
                    newBounds.x = bounds.getX();
                    newBounds.width += diff;
                }
                if (newBounds.getY() > bounds.getY()) {
                    diff = newBounds.y - bounds.getY();
                    newBounds.y = bounds.getY();
                    newBounds.height += diff;
                }
                if (bounds.getX() + bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                    diff = bounds.getX() + bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                    newBounds.width += diff;
                }
                if (!(bounds.getY() + bounds.getHeight() > newBounds.getY() + newBounds.getHeight())) continue;
                diff = bounds.getY() + bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public Point2D.Double getLengthPosition(int i, int j) {
        Point2D.Double p0 = this.getPoint(i);
        Point2D.Double p1 = this.getPoint(j);
        double lx = (p0.x - p1.x) / 2.0;
        double ly = (p0.y - p1.y) / 2.0;
        double x = p0.x - lx;
        double y = p0.y - ly;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double getPt(int i) {
        if (this.shape != null) {
            if (this.units.isInMicrons()) {
                Point2D.Double pt = this.getPoint(i);
                return new Point2D.Double(pt.getX() * this.units.getMicronsPixelX(), pt.getY() * this.units.getMicronsPixelY());
            }
            return this.getPoint(i);
        }
        return this.getPoint(i);
    }

    public double getLength(int i, int j) {
        Point2D.Double pt1 = this.getPt(i);
        Point2D.Double pt2 = this.getPt(j);
        return pt1.distance(pt2);
    }

    public double getAngle(int i, int j, int k) {
        Point2D.Double p0 = this.getPoint(i);
        Point2D.Double p1 = this.getPoint(j);
        Point2D.Double p2 = this.getPoint(k);
        Point2D.Double v0 = new Point2D.Double(((Point2D)p0).getX() - ((Point2D)p1).getX(), ((Point2D)p0).getY() - ((Point2D)p1).getY());
        Point2D.Double v1 = new Point2D.Double(((Point2D)p2).getX() - ((Point2D)p1).getX(), ((Point2D)p2).getY() - ((Point2D)p1).getY());
        return Math.toDegrees(Math.acos(this.dotProd(v0, v1)));
    }

    public double getAngle(int i, int j) {
        Point2D.Double p0 = this.getPoint(i);
        Point2D.Double p1 = this.getPoint(j);
        Point2D.Double v0 = new Point2D.Double(((Point2D)p0).getX() - ((Point2D)p1).getX(), ((Point2D)p0).getY() - ((Point2D)p1).getY());
        Point2D.Double v1 = new Point2D.Double(1.0, 0.0);
        return Math.toDegrees(Math.acos(this.dotProd(v0, v1)));
    }

    public double dotProd(Point2D p0, Point2D p1) {
        double adotb = p0.getX() * p1.getX() + p0.getY() * p1.getY();
        double normab = Math.sqrt(p0.getX() * p0.getX() + p0.getY() * p0.getY()) * Math.sqrt(p1.getX() * p1.getX() + p1.getY() * p1.getY());
        return adotb / normab;
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        this.pointArrayX.clear();
        this.pointArrayY.clear();
        this.lengthArray.clear();
        this.angleArray.clear();
        for (int i = 0; i < this.getPointCount(); ++i) {
            Point2D.Double pt = this.getPt(i);
            this.pointArrayX.add(pt.getX());
            this.pointArrayY.add(pt.getY());
        }
        if (this.getPointCount() == 2) {
            double angle = this.getAngle(0, 1);
            if (angle > 90.0) {
                angle = Math.abs(angle - 180.0);
            }
            this.angleArray.add(angle);
            AnnotationKeys.ANGLE.set(this.shape, this.angleArray);
            this.lengthArray.add(this.getLength(0, 1));
            AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
        } else {
            int x;
            for (x = 1; x < this.getPointCount() - 1; ++x) {
                this.angleArray.add(this.getAngle(x - 1, x, x + 1));
            }
            for (x = 1; x < this.getPointCount(); ++x) {
                this.lengthArray.add(this.getLength(x - 1, x));
            }
            AnnotationKeys.ANGLE.set(this.shape, this.angleArray);
            AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
        }
        AnnotationKeys.STARTPOINTX.set(this.shape, (Double)this.getPt(0).getX());
        AnnotationKeys.STARTPOINTX.set(this.shape, (Double)this.getPt(0).getY());
        AnnotationKeys.ENDPOINTX.set(this.shape, (Double)this.getPt(this.getPointCount() - 1).getX());
        AnnotationKeys.ENDPOINTY.set(this.shape, (Double)this.getPt(this.getPointCount() - 1).getY());
        AnnotationKeys.POINTARRAYX.set(this.shape, this.pointArrayX);
        AnnotationKeys.POINTARRAYY.set(this.shape, this.pointArrayY);
    }

    @Override
    public String getType() {
        return "LineConnection";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        Rectangle r = this.path.getBounds();
        ArrayList<Point> vector = new ArrayList<Point>();
        int yEnd = r.y + r.height;
        int index = 0;
        for (int y = r.y; y < yEnd; ++y) {
            int x = r.x + index;
            if (r.contains(x, y)) {
                vector.add(new Point(x, y));
            }
            ++index;
        }
        return vector;
    }

    public int getPointCount() {
        return this.getNodeCount();
    }

    public void removeAllNodes() {
        super.removeAllNodes();
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasureLineConnectionFigure clone() {
        MeasureLineConnectionFigure that = (MeasureLineConnectionFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        return that;
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }
}

