/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ButtonMenu
extends AbstractButton
implements ActionListener {
    private static final int ARROW_BUTTON_WIDTH = 18;
    private JButton arrowButton;
    private JButton iconButton;
    private JPopupMenu menu;
    private AbstractButton lastClickedItem;

    private void buildGUI() {
        this.setLayout(new DefaultLayoutManager());
        this.setBorder(null);
        this.setMargin(null);
        this.add(this.iconButton);
        this.add(this.arrowButton);
    }

    private void handleIconButtonClick() {
        if (this.lastClickedItem != null) {
            this.lastClickedItem.doClick();
        }
    }

    private void handleArrowButtonClick() {
        if (this.menu.getComponents().length == 0) {
            return;
        }
        Dimension d = this.iconButton.getPreferredSize();
        this.menu.show(this.iconButton, 0, d.height);
    }

    private void handleMenuButtonClick(AbstractButton src) {
        this.lastClickedItem = src;
        this.iconButton.setToolTipText(UIUtilities.formatToolTipText(src.getText()));
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp == this.iconButton || comp == this.arrowButton) {
            super.addImpl(comp, constraints, index);
        }
    }

    public ButtonMenu(Icon icon) {
        if (icon == null) {
            throw new NullPointerException("No icon.");
        }
        this.iconButton = new JButton(icon);
        this.iconButton.addActionListener(this);
        this.arrowButton = new BasicArrowButton(5);
        this.arrowButton.addActionListener(this);
        this.menu = new JPopupMenu();
        this.setModel(new DefaultButtonModel());
        this.buildGUI();
    }

    public void addToMenu(Component item) {
        if (item != null) {
            this.menu.add(item);
        }
    }

    public void addToMenu(AbstractButton btn, boolean trackClick) {
        if (btn != null) {
            this.menu.add(btn);
        }
        if (trackClick) {
            btn.addActionListener(this);
        }
    }

    public void addSeparator() {
        this.menu.addSeparator();
    }

    public void removeFromMenu(Component item) {
        if (item == null) {
            return;
        }
        this.menu.remove(item);
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).removeActionListener(this);
            if (item == this.lastClickedItem) {
                this.lastClickedItem = null;
                this.iconButton.setToolTipText("");
            }
        }
    }

    public void clearMenu() {
        Component[] items = this.menu.getComponents();
        for (int i = 0; i < items.length; ++i) {
            this.removeFromMenu(items[i]);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.iconButton) {
            this.handleIconButtonClick();
        } else if (src == this.arrowButton) {
            this.handleArrowButtonClick();
        } else {
            this.handleMenuButtonClick((AbstractButton)src);
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = this.iconButton.getPreferredSize();
        return new Dimension(d.width + 18, d.height);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doClick() {
        this.arrowButton.doClick();
    }

    public void doClick(int pressTime) {
        this.arrowButton.doClick(pressTime);
    }

    public void setBorder(Border b) {
        this.iconButton.setBorder(b);
        this.arrowButton.setBorder(b);
    }

    public void setRolloverEnabled(boolean enable) {
        super.setRolloverEnabled(enable);
        this.iconButton.setRolloverEnabled(enable);
        this.arrowButton.setRolloverEnabled(enable);
    }

    static /* synthetic */ JButton access$000(ButtonMenu x0) {
        return x0.iconButton;
    }

    static /* synthetic */ JButton access$100(ButtonMenu x0) {
        return x0.arrowButton;
    }

    private class DefaultLayoutManager
    implements LayoutManager {
        private DefaultLayoutManager() {
        }

        public void layoutContainer(Container parent) {
            Dimension d = ButtonMenu.this.iconButton.getPreferredSize();
            ButtonMenu.this.iconButton.setBounds(0, 0, d.width, d.height);
            ButtonMenu.this.arrowButton.setBounds(d.width, 0, 18, d.height);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return ButtonMenu.this.getPreferredSize();
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }
    }
}

