/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourObject;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBModel;
import org.openmicroscopy.shoola.util.ui.colourpicker.TabbedPaneUI;

public class ColourPicker
extends JDialog {
    public static final int DEFAULT_WIDTH = 240;
    public static final int DEFAULT_HEIGHT = 310;
    public static final String COLOUR_PROPERTY = "colour";
    private static final String TITLE = "Colour Picker Window";
    private static final Color DEFAULT_COLOR = Color.red;
    private RGBModel model;
    private TabbedPaneUI tabbedPane;

    private void setWindowProperties() {
        this.setTitle(TITLE);
        this.setSize(240, 310);
        this.setModal(true);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
    }

    static void invalidColorValue() {
        IconManager icons = IconManager.getInstance();
        NotificationDialog dialog = new NotificationDialog("Invalid color component value", "The value must be in the interval [0, 255].", icons.getIcon(29));
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    void accept() {
        Color c = this.model.getColour();
        String description = this.tabbedPane.getDescription();
        if (this.model.isOriginalColor(this.model.getColour()) && description == null) {
            return;
        }
        if (description == null) {
            this.firePropertyChange(COLOUR_PROPERTY, this.model.getOriginalColor(), c);
        } else {
            this.firePropertyChange(COLOUR_PROPERTY, null, new ColourObject(c, description));
        }
        this.cancel();
    }

    public ColourPicker(JFrame owner, Color color, boolean field) {
        super(owner);
        if (color == null) {
            color = DEFAULT_COLOR;
        }
        this.setWindowProperties();
        float[] vals = new float[4];
        vals = color.getComponents(vals);
        this.model = new RGBModel(vals[0], vals[1], vals[2], vals[3]);
        RGBControl control = new RGBControl(this.model);
        this.tabbedPane = new TabbedPaneUI(this, control, field);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 80.0;
        gbc.weighty = 30.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.tabbedPane, gbc);
        this.pack();
    }

    public ColourPicker(JFrame owner, Color color) {
        this(owner, color, false);
    }

    public ColourPicker(JFrame owner) {
        this(owner, null, false);
    }

    public ColourPicker(JFrame owner, boolean field) {
        this(owner, null, field);
    }

    public void setColorDescription(String description) {
        this.tabbedPane.setColorDescription(description);
    }
}

