/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.creationtools;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.util.ResourceBundleUtil;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.BezierTextFigure;

public class BezierTool
extends AbstractTool {
    private static final boolean DEBUG = false;
    private final boolean clickOnly = true;
    private final double error = 1.0;
    private Boolean finishWhenMouseReleased;
    protected Map<AttributeKey, Object> attributes;
    private BezierTextFigure prototype;
    protected BezierTextFigure createdFigure;
    private int nodeCountBeforeDrag;
    private String presentationName;

    public BezierTool(BezierTextFigure prototype) {
        this(prototype, null);
    }

    public BezierTool(BezierTextFigure prototype, Map attributes) {
        this(prototype, attributes, null);
    }

    public BezierTool(BezierTextFigure prototype, Map attributes, String name) {
        this.prototype = prototype;
        this.attributes = attributes;
        if (name == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle((String)"org.jhotdraw.draw.Labels");
            name = labels.getString("createFigure");
        }
        this.presentationName = name;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.getView().clearSelection();
        this.getView().setCursor(Cursor.getPredefinedCursor(1));
    }

    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        this.getView().setCursor(Cursor.getDefaultCursor());
        if (this.createdFigure != null) {
            this.finishCreation(this.createdFigure);
            this.createdFigure = null;
        }
    }

    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        if (this.createdFigure == null) {
            this.finishWhenMouseReleased = null;
            this.createdFigure = this.createFigure();
            this.createdFigure.addNode(new BezierPath.Node(this.getView().getConstrainer().constrainPoint(this.getView().viewToDrawing(this.anchor))));
            this.getDrawing().add((Figure)this.createdFigure);
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
        } else {
            if (evt.getClickCount() == 1) {
                this.addPointToFigure(this.getView().getConstrainer().constrainPoint(this.getView().viewToDrawing(this.anchor)));
            }
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
        }
    }

    protected BezierTextFigure createFigure() {
        BezierTextFigure f = this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo((Figure)f);
        if (this.attributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
                f.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    protected void addPointToFigure(Point2D.Double newPoint) {
        int pointCount = this.createdFigure.getNodeCount();
        this.createdFigure.willChange();
        if (pointCount < 2) {
            this.createdFigure.addNode(new BezierPath.Node(newPoint));
        } else {
            Point2D.Double secondLastPoint;
            Point2D.Double endPoint = this.createdFigure.getEndPoint();
            Point2D.Double double_ = secondLastPoint = pointCount <= 1 ? endPoint : this.createdFigure.getPoint(pointCount - 2, 0);
            if (!newPoint.equals(endPoint)) {
                if (pointCount > 1 && Geom.lineContainsPoint((double)newPoint.x, (double)newPoint.y, (double)secondLastPoint.x, (double)secondLastPoint.y, (double)endPoint.x, (double)endPoint.y, (double)((double)0.9f / this.getView().getScaleFactor()))) {
                    this.createdFigure.setPoint(pointCount - 1, 0, newPoint);
                } else {
                    this.createdFigure.addNode(new BezierPath.Node(newPoint));
                }
            }
        }
        this.createdFigure.changed();
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.createdFigure != null) {
            switch (evt.getClickCount()) {
                case 1: {
                    if (this.createdFigure.getNodeCount() <= 2) break;
                    Rectangle r = new Rectangle(this.getView().drawingToView(this.createdFigure.getStartPoint()));
                    r.grow(2, 2);
                    if (!r.contains(evt.getX(), evt.getY())) break;
                    this.createdFigure.setClosed(true);
                    this.finishCreation(this.createdFigure);
                    this.createdFigure = null;
                    this.fireToolDone();
                    break;
                }
                case 2: {
                    this.finishWhenMouseReleased = null;
                    this.finishCreation(this.createdFigure);
                    this.createdFigure = null;
                    this.fireToolDone();
                }
            }
        }
    }

    protected void fireUndoEvent(Figure createdFigure) {
        Figure addedFigure = createdFigure;
        Drawing addedDrawing = this.getDrawing();
        DrawingView addedView = this.getView();
        this.getDrawing().fireUndoableEditHappened((UndoableEdit)new AbstractUndoableEdit(){

            public String getPresentationName() {
                return BezierTool.this.presentationName;
            }

            public void undo() throws CannotUndoException {
                super.undo();
                addedDrawing.remove(addedFigure);
            }

            public void redo() throws CannotRedoException {
                super.redo();
                addedView.clearSelection();
                addedDrawing.add(addedFigure);
                addedView.addToSelection(addedFigure);
            }
        });
    }

    public void mouseReleased(MouseEvent evt) {
    }

    protected void finishCreation(BezierTextFigure createdFigure) {
        this.getView().addToSelection((Figure)createdFigure);
        this.fireUndoEvent((Figure)createdFigure);
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.createdFigure != null && this.finishWhenMouseReleased == null) {
            this.finishWhenMouseReleased = Boolean.TRUE;
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    static /* synthetic */ String access$000(BezierTool x0) {
        return x0.presentationName;
    }
}

