/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.openmicroscopy.shoola.util.ui.graphutils.ChartObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinePlot
extends ChartObject {
    private DefaultXYDataset dataset;
    private List<double[][]> data;

    private void initialize() {
        this.data = new ArrayList<double[][]>();
        this.dataset = new DefaultXYDataset();
    }

    public LinePlot() {
        super("");
        this.initialize();
    }

    public LinePlot(String title, List<String> newLegends, List<double[][]> newData, List<Color> newColours) {
        super(title);
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.initialize();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i));
        }
        this.setDefaultAxis();
    }

    public LinePlot(String title, List<String> newLegends, List<double[][]> newData, List<Color> newColours, double minValue, double maxValue) {
        super(title);
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.initialize();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i));
        }
        this.setDefaultAxis();
        this.rangeAxis.setRange(minValue, maxValue);
    }

    public int addSeries(String legend, double[][] newData, Color color) {
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.dataset.addSeries((Comparable)((Object)legend), newData);
        return this.dataset.getSeriesCount();
    }

    @Override
    void createChart() {
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        for (int i = 0; i < this.colours.size(); ++i) {
            renderer.setSeriesPaint(i, (Paint)this.colours.get(i));
        }
        XYPlot plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)this.domainAxis, (ValueAxis)this.rangeAxis, (XYItemRenderer)renderer);
        this.chart = new JFreeChart(this.title, (Plot)plot);
    }
}

