/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TwoKnobsSliderModel {
    private int absoluteMin;
    private int absoluteMax;
    private int maximum;
    private int minimum;
    private int startValue;
    private int endValue;
    private boolean enabled;
    private boolean paintLabels;
    private boolean paintTicks;
    private boolean paintCurrentValues;
    private boolean paintEndLabels;
    private int majorTickSpacing;
    private int minorTickSpacing;
    private int increment;
    private Map<Integer, String> labels;
    private int orientation;
    private int partialMin;
    private int partialMax;

    private void createEndLabels() {
        this.labels.put(this.minimum, this.render(this.minimum));
        this.labels.put(this.maximum, this.render(this.maximum));
    }

    private void createLabels() {
        for (int i = this.minimum; i <= this.maximum; i += this.increment) {
            this.labels.put(i, this.render(i));
        }
    }

    private void installDefaults() {
        this.paintTicks = true;
        this.enabled = true;
        this.increment = (this.maximum - this.minimum) / 10;
        this.minorTickSpacing = 1;
        this.majorTickSpacing = 10;
        this.labels = new HashMap<Integer, String>();
        this.setPaintLabels(false);
        this.setPaintEndLabels(true);
        this.setOrientation(100);
    }

    TwoKnobsSliderModel(int absoluteMax, int absoluteMin, int maximum, int minimum, int startValue, int endValue) {
        this.checkValues(absoluteMax, absoluteMin, maximum, minimum, startValue, endValue);
        this.installDefaults();
    }

    void checkValues(int absoluteMax, int absoluteMin, int maximum, int minimum, int startValue, int endValue) {
        if (maximum >= minimum && startValue <= endValue && absoluteMax >= absoluteMin && maximum <= absoluteMax && minimum >= absoluteMin) {
            this.startValue = startValue;
            this.endValue = endValue;
            this.minimum = minimum;
            this.maximum = maximum;
            this.absoluteMax = absoluteMax;
            this.absoluteMin = absoluteMin;
        }
        if (startValue < absoluteMin) {
            startValue = minimum;
        }
        if (endValue > absoluteMax) {
            endValue = absoluteMax;
        }
        this.increment = (maximum - minimum) / 10;
        this.partialMin = startValue < minimum ? startValue : minimum;
        this.partialMax = endValue > maximum ? endValue : maximum;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    int getEndValue() {
        return this.endValue;
    }

    int getStartValue() {
        return this.startValue;
    }

    int getMaximum() {
        return this.maximum;
    }

    int getMinimum() {
        return this.minimum;
    }

    int getAbsoluteMaximum() {
        return this.absoluteMax;
    }

    int getAbsoluteMinimum() {
        return this.absoluteMin;
    }

    int getPartialMinimum() {
        return this.absoluteMin;
    }

    int getPartialMaximum() {
        return this.absoluteMax;
    }

    void setStartValue(int startValue) {
        if (startValue >= this.endValue) {
            return;
        }
        if (startValue < this.absoluteMin) {
            startValue = this.absoluteMin;
        }
        if (startValue <= this.partialMin) {
            this.partialMin = startValue;
        }
        this.startValue = startValue;
    }

    void setEndValue(int endValue) {
        if (endValue <= this.startValue) {
            return;
        }
        if (endValue > this.absoluteMax) {
            endValue = this.absoluteMax;
        }
        if (endValue >= this.partialMax) {
            this.partialMax = endValue;
        }
        this.endValue = endValue;
    }

    void setInterval(int start, int end) {
        if (end > this.absoluteMax) {
            end = this.absoluteMax;
        }
        if (end >= this.partialMax) {
            this.partialMax = end;
        }
        if (start < this.absoluteMin) {
            start = this.absoluteMin;
        }
        if (start <= this.partialMin) {
            this.partialMin = start;
        }
        this.startValue = start;
        this.endValue = end;
    }

    void setPaintCurrentValues(boolean paintCurrentValues) {
        this.paintCurrentValues = paintCurrentValues;
    }

    void setPaintLabels(boolean paintLabels) {
        this.paintLabels = paintLabels;
        if (paintLabels) {
            this.createLabels();
        }
    }

    void setPaintTicks(boolean paintTicks) {
        this.paintTicks = paintTicks;
    }

    void setPaintEndLabels(boolean b) {
        this.paintEndLabels = b;
        if (this.paintEndLabels) {
            this.createEndLabels();
        }
    }

    boolean isPaintLabels() {
        return this.paintLabels;
    }

    boolean isPaintCurrentValues() {
        return this.paintCurrentValues;
    }

    boolean isPaintTicks() {
        return this.paintTicks;
    }

    boolean isPaintEndLabels() {
        return this.paintEndLabels;
    }

    int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    void setMajorTickSpacing(int v) {
        this.majorTickSpacing = v;
    }

    int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    void setMinorTickSpacing(int v) {
        this.minorTickSpacing = v;
    }

    int getIncrement() {
        return this.increment;
    }

    Map<Integer, String> getLabels() {
        return this.labels;
    }

    String render(double value) {
        return new DecimalFormat().format(value);
    }

    int getOrientation() {
        return this.orientation;
    }

    void setOrientation(int v) {
        this.orientation = v;
    }
}

