/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tpane;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.openmicroscopy.shoola.util.ui.tpane.Painter;

class TitlePainter
extends Painter {
    private String title;
    private Font font;

    private boolean isFontSuitable(int availHeight, Graphics2D g2D) {
        FontMetrics fm = g2D.getFontMetrics(this.font);
        int maxH = fm.getMaxAscent() + fm.getMaxDescent();
        return maxH <= availHeight;
    }

    private void ensureSuitableFont(int availHeight, Graphics2D g2D) {
        float size = this.font.getSize2D();
        while (1.0f < size && !this.isFontSuitable(availHeight, g2D)) {
            this.font = this.font.deriveFont(size -= 0.5f);
        }
    }

    private String getDisplayTitle(int availWidth, Graphics2D g2D) {
        Rectangle2D bounds;
        int i;
        FontMetrics fm = g2D.getFontMetrics();
        int len = this.title.length();
        for (i = 0; i < len && !((double)availWidth < (bounds = fm.getStringBounds(this.title.substring(0, i), g2D)).getWidth()); ++i) {
        }
        if (i == len) {
            return this.title;
        }
        if (i <= 3) {
            return "...";
        }
        return this.title.substring(0, i - 3) + "...";
    }

    TitlePainter(Font fontProto) {
        if (fontProto == null) {
            throw new NullPointerException("No font proto.");
        }
        this.font = fontProto;
        this.title = "";
    }

    void setTitle(String t) {
        if (t == null) {
            t = "";
        }
        this.title = t;
    }

    void setFontStyle(int style) {
        this.font = this.font.deriveFont(style);
    }

    protected void doPaint(Graphics2D g2D, int width, int height) {
        this.ensureSuitableFont(height, g2D);
        g2D.setColor(Color.BLACK);
        g2D.setFont(this.font);
        FontMetrics fm = g2D.getFontMetrics();
        int baseline = (height + fm.getAscent() - fm.getDescent()) / 2;
        g2D.drawString(this.getDisplayTitle(width, g2D), 0, baseline);
    }
}

