/*
 * Decompiled with CFR 0.152.
 */
package ome.formats;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import ome.util.LSID;
import omero.model.DetectorSettings;
import omero.model.IObject;
import omero.model.LightPath;
import omero.model.LightSettings;
import omero.model.ObjectiveSettings;
import omero.model.Pixels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEXMLModelComparator
implements Comparator<LSID> {
    private RuleBasedCollator stringComparator = (RuleBasedCollator)Collator.getInstance(Locale.ENGLISH);

    @Override
    public int compare(LSID x, LSID y) {
        int yVal;
        if (x.equals((Object)y)) {
            return 0;
        }
        Class xClass = x.getJavaClass();
        Class yClass = y.getJavaClass();
        int[] xIndexes = x.getIndexes();
        int[] yIndexes = y.getIndexes();
        if (xClass == null || yClass == null) {
            return this.stringComparator.compare(x.toString(), y.toString());
        }
        int xVal = this.getValue(xClass, xIndexes.length);
        int retval = xVal - (yVal = this.getValue(yClass, yIndexes.length));
        if (retval == 0) {
            if (!xClass.equals(yClass)) {
                return this.stringComparator.compare(x.toString(), y.toString());
            }
            if (xIndexes.length != yIndexes.length) {
                return this.stringComparator.compare(x.toString(), y.toString());
            }
            for (int i = 0; i < xIndexes.length; ++i) {
                int difference = xIndexes[i] - yIndexes[i];
                if (difference == 0) continue;
                return difference;
            }
            return 0;
        }
        return retval;
    }

    public int getValue(Class<? extends IObject> klass, int indexes) {
        if (klass.equals(Pixels.class)) {
            return 1;
        }
        if (klass.equals(ObjectiveSettings.class) || klass.equals(DetectorSettings.class) || klass.equals(LightSettings.class) || klass.equals(LightPath.class)) {
            return 3;
        }
        return indexes;
    }
}

