/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.MissingLibraryException;
import loci.formats.UnknownFormatException;
import loci.formats.in.MIASReader;
import loci.formats.meta.MetadataStore;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.OverlayMetadataStore;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportSize;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.Plane2D;
import ome.formats.importer.util.ErrorHandler;
import ome.formats.model.InstanceProvider;
import omero.ServerError;
import omero.api.ServiceFactoryPrx;
import omero.model.Annotation;
import omero.model.Dataset;
import omero.model.FileAnnotation;
import omero.model.IObject;
import omero.model.Image;
import omero.model.OriginalFile;
import omero.model.Pixels;
import omero.model.Plate;
import omero.model.Screen;
import omero.model.WellSample;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportLibrary
implements IObservable {
    private static Log log = LogFactory.getLog(ImportLibrary.class);
    public static final int DEFAULT_ARRAYBUF_SIZE = 0x100000;
    private final ArrayList<IObserver> observers = new ArrayList();
    private final OMEROMetadataStoreClient store;
    private final OMEROWrapper reader;
    private byte[] arrayBuf = new byte[0x100000];
    private boolean isMetadataOnly = false;

    public ImportLibrary(OMEROMetadataStoreClient client2, OMEROWrapper reader) {
        if (client2 == null || reader == null) {
            throw new NullPointerException("All arguments to ImportLibrary() must be non-null.");
        }
        this.store = client2;
        this.reader = reader;
    }

    public void setMetadataOnly(boolean isMetadataOnly) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting metadata only flag: " + isMetadataOnly));
        }
        this.isMetadataOnly = isMetadataOnly;
    }

    public boolean isMetadataOnly() {
        return this.isMetadataOnly;
    }

    public long getExperimenterID() {
        return this.store.getExperimenterID();
    }

    public InstanceProvider getInstanceProvider() {
        return this.store.getInstanceProvider();
    }

    public void prepare(Map<Integer, Image> existingMetadata) {
        this.store.prepare(existingMetadata);
    }

    @Override
    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    @Override
    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    @Override
    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }

    public boolean importCandidates(ImportConfig config, ImportCandidates candidates) {
        List<ImportContainer> containers = candidates.getContainers();
        if (containers != null) {
            int numDone = 0;
            for (int index = 0; index < containers.size(); ++index) {
                ImportContainer ic = containers.get(index);
                if (config.targetClass.get() == "omero.model.Dataset") {
                    ic.setTarget((IObject)this.store.getTarget(Dataset.class, (Long)config.targetId.get()));
                } else if (config.targetClass.get() == "omero.model.Screen") {
                    ic.setTarget((IObject)this.store.getTarget(Screen.class, (Long)config.targetId.get()));
                }
                try {
                    this.importImage(ic, index, numDone, containers.size());
                    ++numDone;
                    continue;
                }
                catch (Throwable t) {
                    if (!((Boolean)config.contOnError.get()).booleanValue()) {
                        log.info((Object)"Exiting on error");
                        return false;
                    }
                    log.info((Object)"Continuing after error");
                }
            }
        }
        return true;
    }

    private void open(String fileName) throws IOException, FormatException {
        this.reader.close();
        this.reader.setMetadataStore(this.store);
        this.reader.setMinMaxStore(this.store);
        this.store.setReader((IFormatReader)this.reader.getImageReader());
        this.reader.setId(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Image Count: " + this.reader.getImageCount()));
        }
    }

    private List<Pixels> importMetadata(int index, ImportContainer container) throws FormatException, IOException {
        IObject target = container.getTarget();
        this.notifyObservers(new ImportEvent.BEGIN_POST_PROCESS(index, null, target, null, 0, null));
        this.store.setUserSpecifiedPlateName(container.getCustomPlateName());
        this.store.setUserSpecifiedPlateDescription(container.getCustomPlateDescription());
        this.store.setUserSpecifiedImageName(container.getCustomImageName());
        this.store.setUserSpecifiedImageDescription(container.getCustomImageDescription());
        Double[] userPixels = container.getUserPixels();
        if (userPixels != null) {
            this.store.setUserSpecifiedPhysicalPixelSizes(userPixels[0], userPixels[1], userPixels[2]);
        }
        this.store.setUserSpecifiedTarget(container.getTarget());
        this.store.setUserSpecifiedAnnotations(container.getCustomAnnotationList());
        this.store.postProcess();
        this.notifyObservers(new ImportEvent.END_POST_PROCESS(index, null, target, null, 0, null));
        this.notifyObservers(new ImportEvent.BEGIN_SAVE_TO_DB(index, null, target, null, 0, null));
        List<Pixels> pixelsList = this.store.saveToDB();
        this.notifyObservers(new ImportEvent.END_SAVE_TO_DB(index, null, target, null, 0, null));
        return pixelsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importOverlays(List<Pixels> pixelsList, List<Long> plateIds) throws ServerError, FormatException, IOException {
        IFormatReader baseReader = this.reader.getImageReader().getReader();
        if (baseReader instanceof MIASReader) {
            try {
                MIASReader miasReader = (MIASReader)baseReader;
                String currentFile = miasReader.getCurrentFile();
                this.reader.close();
                miasReader.setAutomaticallyParseMasks(true);
                ServiceFactoryPrx sf = this.store.getServiceFactory();
                OverlayMetadataStore s = new OverlayMetadataStore();
                s.initialize(sf, pixelsList, plateIds);
                this.reader.setMetadataStore((MetadataStore)s);
                miasReader.close();
                miasReader.setAutomaticallyParseMasks(true);
                miasReader.setId(currentFile);
                s.complete();
            }
            catch (ServerError e) {
                log.warn((Object)"Error while populating MIAS overlays.", (Throwable)e);
            }
            finally {
                this.reader.close();
                this.reader.setMetadataStore(this.store);
            }
        }
    }

    @Deprecated
    public List<Pixels> importImage(File file, int index, int numDone, int total, String userSpecifiedImageName, String userSpecifiedImageDescription, boolean archive, boolean useMetadataFile, Double[] userPixels, IObject userSpecifiedTarget) throws FormatException, IOException, Throwable {
        return this.importImage(file, index, numDone, total, userSpecifiedImageName, userSpecifiedImageDescription, archive, useMetadataFile, userPixels, userSpecifiedTarget, new ArrayList<Annotation>());
    }

    @Deprecated
    public List<Pixels> importImage(File file, int index, int numDone, int total, String userSpecifiedImageName, String userSpecifiedImageDescription, boolean archive, boolean useMetadataFile, Double[] userPixels, IObject userSpecifiedTarget, List<Annotation> userSpecifiedAnnotations) throws FormatException, IOException, Throwable {
        ImportContainer container = new ImportContainer(file, null, userSpecifiedTarget, archive, userPixels, null, null, null);
        container.setCustomImageName(userSpecifiedImageName);
        container.setCustomImageDescription(userSpecifiedImageDescription);
        container.setCustomAnnotationList(userSpecifiedAnnotations);
        container.setUseMetadataFile(useMetadataFile);
        return this.importImage(container, index, numDone, total);
    }

    public List<Pixels> importImage(ImportContainer container, int index, int numDone, int total) throws FormatException, IOException, Throwable {
        File file = container.getFile();
        String fileName = file.getAbsolutePath();
        String shortName = file.getName();
        String format = null;
        String[] domains = null;
        String[] usedFiles = new String[1];
        boolean isScreeningDomain = false;
        boolean archive = container.getArchive();
        boolean useMetadataFile = container.getUseMetadataFile();
        IObject userSpecifiedTarget = container.getTarget();
        usedFiles[0] = file.getAbsolutePath();
        if (log.isInfoEnabled()) {
            log.info((Object)("Metadata only import? " + this.isMetadataOnly));
        }
        try {
            List<File> metadataFiles;
            this.notifyObservers(new ImportEvent.LOADING_IMAGE(shortName, index, numDone, total));
            this.open(file.getAbsolutePath());
            format = this.reader.getFormat();
            domains = this.reader.getDomains();
            if (this.reader.getUsedFiles() != null) {
                usedFiles = this.reader.getUsedFiles();
            }
            for (String domain : domains) {
                if (!domain.equals("High-Content Screening (HCS)")) continue;
                isScreeningDomain = true;
                break;
            }
            this.notifyObservers(new ImportEvent.LOADED_IMAGE(shortName, index, numDone, total));
            String formatString = this.reader.getImageReader().getReader().getClass().toString();
            formatString = formatString.replace("class loci.formats.in.", "");
            formatString = formatString.replace("Reader", "");
            if (isScreeningDomain) {
                log.info((Object)"Reader is of HCS domain, disabling metafile.");
                metadataFiles = this.store.setArchiveScreeningDomain(archive);
            } else {
                log.info((Object)("Reader is not of HCS domain, use metafile: " + useMetadataFile));
                metadataFiles = this.store.setArchive(archive, useMetadataFile);
            }
            List<Pixels> pixList = this.importMetadata(index, container);
            ArrayList<Long> plateIds = new ArrayList<Long>();
            Image image = pixList.get(0).getImage();
            if (image.sizeOfWellSamples() > 0) {
                Plate plate = ((WellSample)image.copyWellSamples().get(0)).getWell().getPlate();
                plateIds.add(plate.getId().getValue());
            }
            ArrayList<Long> pixelsIds = new ArrayList<Long>(pixList.size());
            for (Pixels pixels : pixList) {
                pixelsIds.add(pixels.getId().getValue());
            }
            if (this.isMetadataOnly) {
                List<Pixels> i$ = pixList;
                return i$;
            }
            this.store.preparePixelsStore(pixelsIds);
            int seriesCount = this.reader.getSeriesCount();
            boolean saveSha1 = false;
            for (int series = 0; series < seriesCount; ++series) {
                ImportSize size = new ImportSize(fileName, pixList.get(series), this.reader.getDimensionOrder());
                Pixels pixels = pixList.get(series);
                long pixId = pixels.getId().getValue();
                this.notifyObservers(new ImportEvent.DATASET_STORED(index, fileName, userSpecifiedTarget, pixId, series, size, numDone, total));
                MessageDigest md = this.importData(pixId, fileName, series, size);
                if (md != null) {
                    String s = OMEROMetadataStoreClient.byteArrayToHexString(md.digest());
                    pixels.setSha1(this.store.toRType(s));
                    saveSha1 = true;
                }
                this.notifyObservers(new ImportEvent.DATA_STORED(index, fileName, userSpecifiedTarget, pixId, series, size));
            }
            HashMap<String, OriginalFile> originalFileMap = new HashMap<String, OriginalFile>();
            for (Pixels pixels : pixList) {
                Image i = pixels.getImage();
                for (Annotation annotation : i.linkedAnnotationList()) {
                    if (!(annotation instanceof FileAnnotation)) continue;
                    FileAnnotation fa = (FileAnnotation)annotation;
                    OriginalFile of = fa.getFile();
                    String fullPath = of.getPath().getValue() + of.getName().getValue();
                    originalFileMap.put(fullPath, of);
                }
                for (OriginalFile of : pixels.linkedOriginalFileList()) {
                    String fullPath = of.getPath().getValue() + of.getName().getValue();
                    originalFileMap.put(fullPath, of);
                }
                for (WellSample ws : i.copyWellSamples()) {
                    Plate plate = ws.getWell().getPlate();
                    for (Annotation annotation : plate.linkedAnnotationList()) {
                        if (!(annotation instanceof FileAnnotation)) continue;
                        FileAnnotation fa = (FileAnnotation)annotation;
                        OriginalFile of = fa.getFile();
                        String fullPath = of.getPath().getValue() + of.getName().getValue();
                        originalFileMap.put(fullPath, of);
                    }
                }
            }
            ArrayList<File> fileNameList = new ArrayList<File>();
            if (archive) {
                for (String filename : this.reader.getUsedFiles()) {
                    fileNameList.add(new File(filename));
                }
            } else {
                for (String filename : this.store.getFilteredCompanionFiles()) {
                    fileNameList.add(new File(filename));
                }
            }
            fileNameList.addAll(metadataFiles);
            if (fileNameList.size() != originalFileMap.size()) {
                log.warn((Object)String.format("Original file number mismatch, %d!=%d.", fileNameList.size(), originalFileMap.size()));
            }
            if (archive) {
                this.notifyObservers(new ImportEvent.IMPORT_ARCHIVING(index, null, userSpecifiedTarget, null, 0, null));
            }
            this.store.writeFilesToFileStore(fileNameList, originalFileMap);
            if (saveSha1) {
                this.store.updatePixels(pixList);
            }
            if (!this.reader.isMinMaxSet()) {
                this.store.populateMinMax();
            }
            this.notifyObservers(new ImportEvent.IMPORT_OVERLAYS(index, null, userSpecifiedTarget, null, 0, null));
            this.importOverlays(pixList, plateIds);
            this.notifyObservers(new ImportEvent.IMPORT_THUMBNAILING(index, null, userSpecifiedTarget, null, 0, null));
            this.store.resetDefaultsAndGenerateThumbnails(plateIds, pixelsIds);
            this.store.launchProcessing();
            this.notifyObservers(new ImportEvent.IMPORT_DONE(index, null, userSpecifiedTarget, null, 0, null, pixList));
            List<Pixels> list = pixList;
            return list;
        }
        catch (MissingLibraryException mle) {
            this.notifyObservers(new ErrorHandler.MISSING_LIBRARY(fileName, mle, usedFiles, format));
            throw mle;
        }
        catch (IOException io) {
            this.notifyObservers(new ErrorHandler.FILE_EXCEPTION(fileName, io, usedFiles, format));
            throw io;
        }
        catch (UnknownFormatException ufe) {
            this.notifyObservers(new ErrorHandler.UNKNOWN_FORMAT(fileName, (Exception)((Object)ufe), this));
            throw ufe;
        }
        catch (FormatException fe) {
            this.notifyObservers(new ErrorHandler.FILE_EXCEPTION(fileName, (Exception)((Object)fe), usedFiles, format));
            throw fe;
        }
        catch (Exception e) {
            this.notifyObservers(new ErrorHandler.INTERNAL_EXCEPTION(fileName, e, usedFiles, format));
            throw e;
        }
        catch (Throwable t) {
            this.notifyObservers(new ErrorHandler.INTERNAL_EXCEPTION(fileName, new RuntimeException(t), usedFiles, format));
            throw t;
        }
        finally {
            this.store.createRoot();
        }
    }

    public MessageDigest importData(Long pixId, String fileName, int series, ImportSize size) throws FormatException, IOException, ServerError {
        MessageDigest md;
        this.reader.setSeries(series);
        int bytesPerPixel = this.getBytesPerPixel(this.reader.getPixelType());
        int maximumPixelCount = this.arrayBuf.length / bytesPerPixel;
        int maximumRowCount = maximumPixelCount / size.sizeX;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        int planeNo = 1;
        boolean offset = false;
        for (int t = 0; t < size.sizeT; ++t) {
            for (int c = 0; c < size.sizeC; ++c) {
                for (int z = 0; z < size.sizeZ; ++z) {
                    this.writeDataPlanarBased(pixId, size, z, c, t, bytesPerPixel, fileName, md);
                    this.notifyObservers(new ImportEvent.IMPORT_STEP(planeNo, series, this.reader.getSeriesCount()));
                    ++planeNo;
                }
            }
        }
        return md;
    }

    private int writeDataBlockBased(long pixId, ImportSize size, int z, int c, int t, int offset, int maximumRowCount, int maximumPixelCount, int bytesPerPixel, String fileName, MessageDigest md) throws FormatException, IOException, ServerError {
        int width = size.sizeX;
        int posY = 0;
        int bytesToRead = size.sizeX * size.sizeY;
        while (bytesToRead > 0) {
            int planeNumber = this.reader.getIndex(z, c, t);
            int height = maximumRowCount;
            if (posY + height > size.sizeY) {
                height = size.sizeY - posY;
            }
            int arrayBufSize = bytesPerPixel * height * width;
            log.debug((Object)String.format("ToRead:%d Size:%d Offset: %d Width:%d Height: %d PosY:%d", bytesToRead, arrayBufSize, offset, width, height, posY));
            Plane2D data = this.reader.openPlane2D(fileName, planeNumber, this.arrayBuf, 0, posY, width, height);
            ByteBuffer buf = data.getData();
            this.arrayBuf = this.swapIfRequired(buf, fileName);
            try {
                md.update(this.arrayBuf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.store.setRegion(pixId, this.arrayBuf, arrayBufSize, offset);
            posY += height;
            bytesToRead -= height * width;
            offset += arrayBufSize;
        }
        return offset;
    }

    private void writeDataPlanarBased(long pixId, ImportSize size, int z, int c, int t, int bytesPerPixel, String fileName, MessageDigest md) throws FormatException, IOException, ServerError {
        int bytesToRead = size.sizeX * size.sizeY * bytesPerPixel;
        if (this.arrayBuf.length != bytesToRead) {
            this.arrayBuf = new byte[bytesToRead];
        }
        int planeNumber = this.reader.getIndex(z, c, t);
        Plane2D data = this.reader.openPlane2D(fileName, planeNumber, this.arrayBuf);
        ByteBuffer buf = data.getData();
        this.arrayBuf = this.swapIfRequired(buf, fileName);
        try {
            md.update(this.arrayBuf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.store.setPlane(pixId, this.arrayBuf, z, c, t);
    }

    private boolean isLittleEndian(String fileName) throws FormatException, IOException {
        return this.reader.isLittleEndian();
    }

    private byte[] swapIfRequired(ByteBuffer buffer, String fileName) throws FormatException, IOException {
        int pixelType = this.reader.getPixelType();
        int bytesPerPixel = this.getBytesPerPixel(pixelType);
        if (bytesPerPixel == 1) {
            return buffer.array();
        }
        if (this.isLittleEndian(fileName)) {
            if (bytesPerPixel == 2) {
                ShortBuffer buf = buffer.asShortBuffer();
                int length = buffer.capacity() / 2;
                for (int i = 0; i < length; ++i) {
                    short x = buf.get(i);
                    buf.put(i, (short)(x << 8 | x >> 8 & 0xFF));
                }
            } else if (bytesPerPixel == 4) {
                IntBuffer buf = buffer.asIntBuffer();
                int length = buffer.capacity() / 4;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((int)buf.get(i)));
                }
            } else if (bytesPerPixel == 8) {
                LongBuffer buf = buffer.asLongBuffer();
                int length = buffer.capacity() / 8;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((long)buf.get(i)));
                }
            } else {
                throw new FormatException(String.format("Unsupported sample bit width: %d", bytesPerPixel));
            }
        }
        return buffer.array();
    }

    private int getBytesPerPixel(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new RuntimeException("Unknown type with id: '" + type + "'");
    }

    public void clear() {
        this.store.createRoot();
    }
}

