/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.cli;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.cli.ErrorHandler;
import ome.formats.importer.cli.LoggingImportMonitor;
import omero.model.Dataset;
import omero.model.Screen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CommandLineImporter {
    private static Log log = LogFactory.getLog(CommandLineImporter.class);
    private static final String APP_NAME = "importer-cli";
    public final ImportConfig config;
    public final ImportLibrary library;
    public final ErrorHandler handler;
    private final OMEROWrapper reader;
    private final OMEROMetadataStoreClient store;
    private final ImportCandidates candidates;
    private final boolean getUsedFiles;

    public CommandLineImporter(ImportConfig config, String[] paths, boolean getUsedFiles) throws Exception {
        this.config = config;
        config.loadAll();
        this.getUsedFiles = getUsedFiles;
        this.reader = new OMEROWrapper(config);
        this.handler = new ErrorHandler(config);
        this.candidates = new ImportCandidates(this.reader, paths, this.handler);
        if (paths == null || paths.length == 0 || getUsedFiles) {
            this.store = null;
            this.library = null;
        } else {
            if (!config.canLogin()) {
                CommandLineImporter.usage();
            }
            this.store = config.createStore();
            this.reader.setMetadataOptions((MetadataOptions)new DefaultMetadataOptions(MetadataLevel.ALL));
            this.library = new ImportLibrary(this.store, this.reader);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                CommandLineImporter.this.cleanup();
            }
        });
    }

    public int start() {
        boolean successful = true;
        if (this.getUsedFiles) {
            try {
                this.candidates.print();
                this.report();
                return 0;
            }
            catch (Throwable t) {
                log.error((Object)"Error retrieving used files.", t);
                return 1;
            }
        }
        if (this.candidates.size() < 1) {
            if (this.handler.errorCount() > 0) {
                System.err.println("No imports due to errors!");
                this.report();
            } else {
                System.err.println("No imports found");
                CommandLineImporter.usage();
            }
        } else {
            this.library.addObserver(new LoggingImportMonitor());
            this.library.addObserver(new ErrorHandler(this.config));
            successful = this.library.importCandidates(this.config, this.candidates);
            this.report();
        }
        return successful ? 0 : 2;
    }

    void report() {
        boolean report = (Boolean)this.config.sendReport.get();
        boolean files = (Boolean)this.config.sendFiles.get();
        boolean logs = (Boolean)this.config.sendLogFile.get();
        if (report) {
            this.handler.update(null, new ImportEvent.DEBUG_SEND(files, logs));
        }
    }

    public void cleanup() {
        if (this.store != null) {
            this.store.logout();
        }
    }

    public static void usage() {
        System.err.println(String.format("\n Usage:  %s [OPTION]... [DIR|FILE]... \n   or:   %s [OPTION]... - \n\nImport any number of files into an OMERO instance.\nIf \"-\" is the only path, a list of files or directories \nis read from standard in. Directories will be searched for \nall valid imports.\n\nMandatory arguments:\n  -s\tOMERO server hostname\n  -u\tOMERO experimenter name (username)\n  -w\tOMERO experimenter password\n  -k\tOMERO session key (can be used in place of -u and -w)\n  -f\tDisplay the used files (does not require other mandatory arguments)\n\nOptional arguments:\n  -c\tContinue importing after errors\n  -a\tArchive the original file on the server\n  -l\tUse the list of readers rather than the default\n  -d\tOMERO dataset Id to import image into\n  -r\tOMERO screen Id to import plate into\n  -n\tImage name to use\n  -x\tImage description to use\n  -p\tOMERO server port [defaults to 4064]\n  -h\tDisplay this help and exit\n\n  --plate_name\t\tPlate name to use\n  --plate_description\tPlate description to use\n  --debug[=ALL|DEBUG|ERROR|FATAL|INFO|TRACE|WARN]\tTurn debug logging on (optional level)\n  --report\t\tReport errors to the OME team\n  --upload\t\tUpload broken files with report\n  --logs\t\tUpload log file with report\n  --email=...\t\tEmail for reported errors\n \nex. %s -s localhost -u bart -w simpson -d 50 foo.tiff\n\nReport bugs to <ome-users@lists.openmicroscopy.org.uk>", APP_NAME, APP_NAME, APP_NAME));
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int a;
        ImportConfig config = new ImportConfig();
        config.email.set("");
        config.sendFiles.set(false);
        config.sendLogFile.set(false);
        config.sendReport.set(false);
        config.contOnError.set(false);
        config.debug.set(false);
        config.encryptedConnection.set(false);
        LongOpt debug = new LongOpt("debug", 2, null, 1);
        LongOpt report = new LongOpt("report", 0, null, 2);
        LongOpt upload = new LongOpt("upload", 0, null, 3);
        LongOpt logs = new LongOpt("logs", 0, null, 4);
        LongOpt email = new LongOpt("email", 1, null, 5);
        LongOpt plateName = new LongOpt("plate_name", 1, null, 6);
        LongOpt plateDescription = new LongOpt("plate_description", 1, null, 7);
        Getopt g = new Getopt(APP_NAME, args, "acfl:s:u:w:d:r:k:x:n:p:h", new LongOpt[]{debug, report, upload, logs, email, plateName, plateDescription});
        boolean getUsedFiles = false;
        block28: while ((a = g.getopt()) != -1) {
            switch (a) {
                case 1: {
                    config.configureDebug(Level.toLevel((String)g.getOptarg()));
                    continue block28;
                }
                case 2: {
                    config.sendReport.set(true);
                    continue block28;
                }
                case 3: {
                    config.sendFiles.set(true);
                    continue block28;
                }
                case 4: {
                    config.sendLogFile.set(true);
                    continue block28;
                }
                case 5: {
                    config.email.set(g.getOptarg());
                    continue block28;
                }
                case 6: {
                    config.plateName.set(g.getOptarg());
                    continue block28;
                }
                case 7: {
                    config.plateDescription.set(g.getOptarg());
                    continue block28;
                }
                case 115: {
                    config.hostname.set(g.getOptarg());
                    continue block28;
                }
                case 117: {
                    config.username.set(g.getOptarg());
                    continue block28;
                }
                case 119: {
                    config.password.set(g.getOptarg());
                    continue block28;
                }
                case 107: {
                    config.sessionKey.set(g.getOptarg());
                    continue block28;
                }
                case 112: {
                    config.port.set(Integer.parseInt(g.getOptarg()));
                    continue block28;
                }
                case 100: {
                    config.targetClass.set(Dataset.class.getName());
                    config.targetId.set(Long.parseLong(g.getOptarg()));
                    continue block28;
                }
                case 114: {
                    config.targetClass.set(Screen.class.getName());
                    config.targetId.set(Long.parseLong(g.getOptarg()));
                    continue block28;
                }
                case 110: {
                    config.imageName.set(g.getOptarg());
                    continue block28;
                }
                case 120: {
                    config.imageDescription.set(g.getOptarg());
                    continue block28;
                }
                case 102: {
                    getUsedFiles = true;
                    continue block28;
                }
                case 99: {
                    config.contOnError.set(true);
                    continue block28;
                }
                case 97: {
                    config.archiveImage.set(true);
                    continue block28;
                }
                case 108: {
                    config.readersPath.set(g.getOptarg());
                    continue block28;
                }
                case 104: {
                    CommandLineImporter.usage();
                }
            }
            CommandLineImporter.usage();
        }
        log.info((Object)String.format("Log levels -- Bio-Formats: %s OMERO.importer: %s", Logger.getLogger((String)"loci").getLevel(), Logger.getLogger((String)"ome.formats").getLevel()));
        String[] rest = new String[args.length - g.getOptind()];
        System.arraycopy(args, g.getOptind(), rest, 0, args.length - g.getOptind());
        CommandLineImporter c = null;
        int rc = 0;
        try {
            if (rest.length == 1 && "-".equals(rest[0])) {
                rest = CommandLineImporter.stdin();
            }
            c = new CommandLineImporter(config, rest, getUsedFiles);
            rc = c.start();
        }
        catch (Throwable t) {
            log.error((Object)"Error during import process.", t);
            rc = 2;
        }
        finally {
            if (c != null) {
                c.cleanup();
            }
        }
        System.exit(rc);
    }

    static String[] stdin() throws IOException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        ArrayList<String> files = new ArrayList<String>();
        while ((str = in.readLine()) != null) {
            if ((str = str.trim()).length() <= 0) continue;
            files.add(str);
        }
        return files.toArray(new String[0]);
    }
}

