/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.gui.DebugItem;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.gui.LogAppender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;

public class OptionsDialog
extends JDialog
implements ActionListener {
    private ImportConfig config;
    private Integer dialogHeight = 300;
    private Integer dialogWidth = 374;
    private JTabbedPane tabbedPane;
    private JPanel mainPanel;
    private JPanel debugOptionsPanel;
    private JPanel otherOptionsPanel;
    private JPanel fileChooserPanel;
    private JPanel singlePanePanel;
    private JPanel triplePanePanel;
    private JRadioButton singlePaneBtn;
    private JRadioButton triplePaneBtn;
    public static final String SINGLE_PANE_IMAGE = "gfx/single_pane_fileChooser.png";
    public static final String TRIPLE_PANE_IMAGE = "gfx/triple_pane_fileChooser.png";
    private JButton cancelBtn;
    private JButton okBtn;
    public boolean cancelled = true;
    private boolean oldQuaquaLevel;
    private static Log log = LogFactory.getLog(OptionsDialog.class);
    private static final String allDescription = "This level of debugging turns on all logging. Use this option if you want to see all messages, but be mindful of the fact this can produce some very large log files.";
    private static final String debugDescription = "This level of debugging is useful when debugging the importer, and is primarily of interest  to developers. This can also produce very large files.";
    private static final String errorDescription = "This level of debugging captures 'minor' bugs which are unlikely to cause the importer to fail or fatally crash. This is the default setting.";
    private static final String fatalDescription = "This level of debugging only captures 'fatal' bugs which are likely to cause the importer to crash and fail.";
    private static final String infoDescription = "This level of debugging captures messages provided by the developer. Most metadata messages are provided to the log file through this level of debugging information.";
    private static final String offDescription = "This option turns off almost all debugging information, and any information that appears should be very brief.";
    final DebugItem[] debugItems = new DebugItem[]{new DebugItem("All", Integer.MIN_VALUE, "This level of debugging turns on all logging. Use this option if you want to see all messages, but be mindful of the fact this can produce some very large log files."), new DebugItem("Debug", 10000, "This level of debugging is useful when debugging the importer, and is primarily of interest  to developers. This can also produce very large files."), new DebugItem("Error (Default)", 40000, "This level of debugging captures 'minor' bugs which are unlikely to cause the importer to fail or fatally crash. This is the default setting."), new DebugItem("Fatal", 50000, "This level of debugging only captures 'fatal' bugs which are likely to cause the importer to crash and fail."), new DebugItem("Info", 20000, "This level of debugging captures messages provided by the developer. Most metadata messages are provided to the log file through this level of debugging information."), new DebugItem("Off", Integer.MAX_VALUE, "This option turns off almost all debugging information, and any information that appears should be very brief.")};
    public OMEROMetadataStoreClient store;
    Component owner;
    boolean debug = false;
    private JComboBox dBox;
    private JTextPane descriptionText;
    private JCheckBox companionFileCheckbox;

    OptionsDialog(ImportConfig config, JFrame owner, String title, boolean modal) {
        super(owner);
        this.owner = owner;
        this.setLocation(200, 200);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(false);
        this.setSize(new Dimension(this.dialogWidth, this.dialogHeight));
        this.setLocationRelativeTo(owner);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setOpaque(false);
        this.config = config;
        this.oldQuaquaLevel = config.getUseQuaqua();
        double[][] mainPanelTable = new double[][]{{-1.0, 120.0, 5.0, 120.0, -1.0}, {-1.0, 5.0, 30.0}};
        this.mainPanel = GuiCommonElements.addMainPanel(this, mainPanelTable, 10, 10, 10, 10, this.debug);
        this.cancelBtn = GuiCommonElements.addButton(this.mainPanel, "Cancel", 76, "Cancel", "1, 2, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.okBtn = GuiCommonElements.addButton(this.mainPanel, "OK", 81, "Import", "3, 2, f, c", this.debug);
        this.okBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okBtn);
        GuiCommonElements.enterPressesWhenFocused(this.okBtn);
        this.mainPanel.add((Component)this.tabbedPane, "0,0,4,0");
        double[][] debugOptionTable = new double[][]{{-1.0}, {10.0, -2.0, 20.0, 30.0, 15.0, -1.0}};
        this.debugOptionsPanel = GuiCommonElements.addMainPanel(this.tabbedPane, debugOptionTable, 0, 10, 10, 10, this.debug);
        String message = "Choose the level of detail for your log file's data.";
        GuiCommonElements.addTextPane(this.debugOptionsPanel, message, "0, 1, 0, 0", this.debug);
        this.dBox = GuiCommonElements.addComboBox(this.debugOptionsPanel, "Debug Level: ", this.debugItems, 68, "Choose the level of detail for your log file's data.", 95.0, "0,3,F,C", this.debug);
        int debugLevel = config.getDebugLevel();
        for (int i = 0; i < this.dBox.getItemCount(); ++i) {
            if (((DebugItem)this.dBox.getItemAt(i)).getLevel() != debugLevel) continue;
            this.dBox.setSelectedIndex(i);
        }
        this.dBox.addActionListener(this);
        String description = ((DebugItem)this.dBox.getSelectedItem()).getDescription();
        this.descriptionText = GuiCommonElements.addTextPane(this.debugOptionsPanel, description, "0, 5", this.debug);
        Font textFieldFont = (Font)UIManager.get("TextField.font");
        Font font = new Font(textFieldFont.getFamily(), 2, textFieldFont.getSize());
        this.descriptionText.setFont(font);
        double[][] otherOptionTable = new double[][]{{-1.0}, {10.0, -2.0, 20.0, 30.0, 15.0, -1.0}};
        this.otherOptionsPanel = GuiCommonElements.addMainPanel(this.tabbedPane, otherOptionTable, 0, 10, 10, 10, this.debug);
        this.companionFileCheckbox = GuiCommonElements.addCheckBox(this.otherOptionsPanel, "<html>Attached a text file to each imported file containing all collected metadata.</html>", "0,1", this.debug);
        this.companionFileCheckbox.setSelected((Boolean)config.companionFile.get());
        double[][] fileChooserTable = new double[][]{{-1.0, 120.0, 5.0, 120.0, -1.0}, {-2.0, 15.0, -1.0, 10.0}};
        this.fileChooserPanel = GuiCommonElements.addMainPanel(this.tabbedPane, fileChooserTable, 0, 10, 0, 10, this.debug);
        message = "Switch between single pane view and triple pane view. You will need to reboot the importer before your changes will take effect.";
        GuiCommonElements.addTextPane(this.fileChooserPanel, message, "0, 0, 4, 0", this.debug);
        double[][] singlePaneTable = new double[][]{{24.0, 5.0, -1.0}, {-1.0}};
        this.singlePanePanel = GuiCommonElements.addMainPanel(this.fileChooserPanel, singlePaneTable, 0, 0, 0, 0, this.debug);
        this.singlePaneBtn = GuiCommonElements.addRadioButton(this.singlePanePanel, null, 117, null, "0,0", this.debug);
        GuiCommonElements.addImagePanel(this.singlePanePanel, SINGLE_PANE_IMAGE, "2,0", this.debug);
        this.fileChooserPanel.add((Component)this.singlePanePanel, "0, 2, 1, 2");
        double[][] triplePaneTable = new double[][]{{24.0, 5.0, -1.0}, {-1.0}};
        this.triplePanePanel = GuiCommonElements.addMainPanel(this.fileChooserPanel, triplePaneTable, 0, 0, 0, 0, this.debug);
        this.triplePaneBtn = GuiCommonElements.addRadioButton(this.triplePanePanel, null, 117, null, "0,0", this.debug);
        GuiCommonElements.addImagePanel(this.triplePanePanel, TRIPLE_PANE_IMAGE, "2,0", this.debug);
        this.fileChooserPanel.add((Component)this.triplePanePanel, "3, 2, 4, 2");
        ButtonGroup group = new ButtonGroup();
        group.add(this.singlePaneBtn);
        group.add(this.triplePaneBtn);
        if (config.getUseQuaqua()) {
            this.triplePaneBtn.setSelected(true);
            this.singlePaneBtn.setSelected(false);
        } else {
            this.triplePaneBtn.setSelected(false);
            this.singlePaneBtn.setSelected(true);
        }
        this.tabbedPane.addTab("Debug", null, this.debugOptionsPanel, "Debug Settings");
        this.tabbedPane.addTab("Other", null, this.otherOptionsPanel, "Other Settings");
        this.add(this.mainPanel);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.cancelBtn) {
            this.cancelled = true;
            this.dispose();
        }
        if (event.getSource() == this.okBtn && this.isDisplayable()) {
            if (this.singlePaneBtn.isSelected()) {
                this.config.setUseQuaqua(false);
            } else {
                this.config.setUseQuaqua(true);
            }
            this.config.companionFile.set(this.companionFileCheckbox.isSelected());
            this.config.setDebugLevel(((DebugItem)this.dBox.getSelectedItem()).getLevel());
            Level level = Level.toLevel((int)((DebugItem)this.dBox.getSelectedItem()).getLevel());
            LogAppender.setLoggingLevel(level);
            this.dispose();
            if (this.config.getUseQuaqua() != this.oldQuaquaLevel) {
                GuiCommonElements.restartNotice(this.owner, null);
            }
        }
        if (event.getSource() == this.dBox) {
            this.descriptionText.setText(((DebugItem)this.dBox.getSelectedItem()).getDescription());
            this.repaint();
        }
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(laf + " not supported.");
        }
        ImportConfig config = new ImportConfig(null);
        OptionsDialog dialog = new OptionsDialog(config, null, "Optional Settings", true);
        if (dialog != null) {
            System.exit(0);
        }
    }
}

