/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.reactor;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Fileset {
    private static final Log log = LogFactory.getLog(Fileset.class);
    private File target;
    private File[] usedFiles;
    private long bytesToUpload;
    private String imageName;
    private String imageDescription;
    private String filesetUUID;
    private FilesetState state;

    Fileset(File target, String imageName, String imageDescription) {
        this.target = target;
        this.imageName = imageName;
        this.imageDescription = imageDescription;
        this.state = FilesetState.QUEUED;
    }

    public File getTarget() {
        return this.target;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageDescription() {
        return this.imageDescription;
    }

    public FilesetState getState() {
        return this.state;
    }

    public void promote() {
        switch (this.state) {
            case QUEUED: {
                this.state = FilesetState.ANALYZING;
                break;
            }
            case ANALYZING: {
                this.state = FilesetState.HANDLING;
                break;
            }
            case HANDLING: {
                this.state = FilesetState.FINISHED;
                break;
            }
            case FINISHED: {
                throw new IllegalStateException("Cannot promote context's in the FINISHED state.");
            }
            case FAILED: {
                throw new IllegalStateException("Cannot promote context's in the FAILED state.");
            }
        }
    }

    public String getStatusString() {
        switch (this.state) {
            case QUEUED: {
                return "queued";
            }
            case ANALYZING: {
                return "analyzing";
            }
            case HANDLING: {
                return "uploading";
            }
            case FINISHED: {
                return "finished";
            }
            case FAILED: {
                return "failed";
            }
        }
        return "unknown";
    }

    public void setFilesetUUID(String filesetUUID) {
        this.filesetUUID = filesetUUID;
    }

    public String getFilesetUUID() {
        return this.filesetUUID;
    }

    public void setUsedFiles(String[] usedFiles) {
        this.usedFiles = new File[usedFiles.length];
        for (int i = 0; i < usedFiles.length; ++i) {
            File f;
            this.usedFiles[i] = f = new File(usedFiles[i]);
            this.bytesToUpload += f.length();
        }
    }

    public File[] getUsedFiles() {
        return this.usedFiles;
    }

    public long getBytesToUpload() {
        return this.bytesToUpload;
    }

    public boolean isFailed() {
        return this.state.equals((Object)FilesetState.FAILED);
    }

    public void fail() {
        if (this.state == FilesetState.FAILED) {
            log.warn((Object)"Trying to fail context that's already failed.");
        }
        this.state = FilesetState.FAILED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FilesetState {
        QUEUED,
        ANALYZING,
        HANDLING,
        FINISHED,
        FAILED;

    }
}

