/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import loci.formats.MissingLibraryException;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.util.ErrorContainer;
import ome.formats.importer.util.FileUploader;
import ome.formats.importer.util.HtmlMessenger;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ErrorHandler
implements IObserver,
IObservable {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ArrayList<IObserver> observers = new ArrayList();
    protected final ArrayList<ErrorContainer> errors = new ArrayList();
    protected final ImportConfig config;
    protected boolean cancelUploads = false;
    protected boolean sendFiles = true;
    protected boolean sendLogs = true;
    public boolean fileUploadErrors = false;
    protected int totalErrors = 0;
    private FileUploader fileUploader;

    public ErrorHandler(ImportConfig config) {
        this.config = config;
    }

    public final void update(IObservable observable, ImportEvent event) {
        if (event instanceof MISSING_LIBRARY) {
            MISSING_LIBRARY ev = (MISSING_LIBRARY)event;
            this.log.warn((Object)ev.toLog(), (Throwable)ev.exception);
        } else if (event instanceof FILE_EXCEPTION) {
            FILE_EXCEPTION ev = (FILE_EXCEPTION)event;
            this.log.error((Object)ev.toLog(), (Throwable)ev.exception);
            this.addError(ev.exception, new File(ev.filename), ev.usedFiles, ev.reader);
        } else if (event instanceof INTERNAL_EXCEPTION) {
            INTERNAL_EXCEPTION ev = (INTERNAL_EXCEPTION)event;
            this.log.error((Object)event.toLog(), (Throwable)ev.exception);
            this.addError(ev.exception, new File(ev.filename), ev.usedFiles, ev.reader);
        } else if (event instanceof UNKNOWN_FORMAT) {
            UNKNOWN_FORMAT ev = (UNKNOWN_FORMAT)event;
            String[] usedFiles = new String[]{ev.filename};
            if (ev.source instanceof ImportLibrary) {
                this.addError(ev.exception, new File(ev.filename), usedFiles, "");
            }
            this.log.debug((Object)event.toLog());
        } else if (event instanceof EXCEPTION_EVENT) {
            EXCEPTION_EVENT ev = (EXCEPTION_EVENT)event;
            this.log.error((Object)ev.toLog(), (Throwable)ev.exception);
        }
        this.onUpdate(observable, event);
    }

    public int errorCount() {
        return this.errors.size();
    }

    protected abstract void onUpdate(IObservable var1, ImportEvent var2);

    protected void sendErrors() {
        for (int i = 0; i < this.errors.size(); ++i) {
            if (!this.isSend(i)) {
                this.onSent(i);
                continue;
            }
            if (this.cancelUploads) {
                this.onCancel();
                break;
            }
            ErrorContainer errorContainer = this.errors.get(i);
            if (errorContainer.getStatus() != -1) continue;
            ArrayList<Part> postList = new ArrayList<Part>();
            postList.add((Part)new StringPart("java_version", errorContainer.getJavaVersion()));
            postList.add((Part)new StringPart("java_classpath", errorContainer.getJavaClasspath()));
            postList.add((Part)new StringPart("app_version", errorContainer.getAppVersion()));
            postList.add((Part)new StringPart("comment_type", errorContainer.getCommentType()));
            postList.add((Part)new StringPart("os_name", errorContainer.getOSName()));
            postList.add((Part)new StringPart("os_arch", errorContainer.getOSArch()));
            postList.add((Part)new StringPart("os_version", errorContainer.getOSVersion()));
            postList.add((Part)new StringPart("extra", errorContainer.getExtra()));
            postList.add((Part)new StringPart("error", ErrorHandler.getStackTrace(errorContainer.getError())));
            postList.add((Part)new StringPart("comment", errorContainer.getComment()));
            postList.add((Part)new StringPart("email", errorContainer.getEmail()));
            postList.add((Part)new StringPart("app_name", "2"));
            postList.add((Part)new StringPart("import_session", "test"));
            postList.add((Part)new StringPart("absolute_path", errorContainer.getAbsolutePath() + "/"));
            String sendUrl = this.config.getTokenUrl();
            if (this.isSend(i)) {
                String[] files;
                postList.add((Part)new StringPart("selected_file", errorContainer.getSelectedFile().getName()));
                postList.add((Part)new StringPart("absolute_path", errorContainer.getAbsolutePath()));
                if (this.sendLogs) {
                    errorContainer.addFile(this.config.getLogFile());
                }
                if ((files = errorContainer.getFiles()) != null && files.length > 0) {
                    for (String f : errorContainer.getFiles()) {
                        File file = new File(f);
                        postList.add((Part)new StringPart("additional_files", file.getName()));
                        if (file.getParent() != null) {
                            postList.add((Part)new StringPart("additional_files_path", file.getParent() + "/"));
                        }
                        postList.add((Part)new StringPart("additional_files_size", Long.valueOf(file.length()).toString()));
                    }
                }
            }
            try {
                HtmlMessenger messenger = new HtmlMessenger(sendUrl, postList);
                String serverReply = messenger.executePost();
                if (this.sendFiles) {
                    this.onSending(i);
                    errorContainer.setToken(serverReply);
                    this.fileUploader = new FileUploader(messenger.getHttpClient());
                    this.fileUploader.addObserver(this);
                    this.fileUploader.uploadFiles(this.config.getUploaderUrl(), 2000, errorContainer);
                    this.onSent(i);
                    continue;
                }
                this.onNotSending(i, serverReply);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"Error while sending error information.", (Throwable)e);
                this.onException(e);
            }
        }
        if (this.cancelUploads) {
            this.finishCancelled();
        }
        if (this.fileUploadErrors) {
            this.finishWithErroredFiles();
            this.notifyObservers(new ImportEvent.ERRORS_COMPLETE());
        } else {
            this.finishComplete();
            this.notifyObservers(new ImportEvent.ERRORS_COMPLETE());
        }
    }

    protected void addError(Throwable error, File file, String[] files, String readerType) {
        ErrorContainer errorContainer = new ErrorContainer();
        errorContainer.setFiles(files);
        errorContainer.setSelectedFile(file);
        errorContainer.setReaderType(readerType);
        errorContainer.setCommentType("2");
        errorContainer.setJavaVersion(System.getProperty("java.version"));
        errorContainer.setJavaClasspath(System.getProperty("java.class.path"));
        errorContainer.setOSName(System.getProperty("os.name"));
        errorContainer.setOSArch(System.getProperty("os.arch"));
        errorContainer.setOSVersion(System.getProperty("os.version"));
        errorContainer.setAppVersion(this.config.getVersionNumber());
        errorContainer.setError(error);
        this.addError(errorContainer);
    }

    private void addError(ErrorContainer errorContainer) {
        String errorMessage = errorContainer.getError().toString();
        String[] splitMessage = errorMessage.split("\n");
        errorMessage = errorMessage.replaceAll("\n", "<br>&nbsp;&nbsp;");
        errorContainer.setIndex(this.totalErrors);
        ++this.totalErrors;
        errorContainer.setStatus(-1);
        this.errors.add(errorContainer);
        this.onAddError(errorContainer, splitMessage[0]);
        this.notifyObservers(new ImportEvent.ERRORS_PENDING());
    }

    public final boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public final boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public final void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }

    protected void onCancel() {
        this.fileUploader.cancel();
    }

    protected void onAddError(ErrorContainer errorContainer, String message) {
    }

    protected boolean isSend(int index) {
        return this.errors.get(index).getSelectedFile() != null;
    }

    protected void onSending(int index) {
    }

    protected void onSent(int index) {
    }

    protected void onNotSending(int index, String serverReply) {
    }

    protected void onException(Exception exception) {
        this.notifyObservers(new ImportEvent.ERRORS_FAILED());
    }

    protected void finishCancelled() {
        this.fileUploader.cancel();
    }

    protected void finishComplete() {
    }

    protected void finishWithErroredFiles() {
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        throwable.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }

    public static class MISSING_LIBRARY
    extends FILE_EXCEPTION {
        public MISSING_LIBRARY(String filename, MissingLibraryException exception, String[] usedFiles, String reader) {
            super(filename, (Exception)((Object)exception), usedFiles, reader);
        }
    }

    public static class FILE_EXCEPTION
    extends EXCEPTION_EVENT {
        public final String filename;
        public final String[] usedFiles;
        public final String reader;

        public FILE_EXCEPTION(String filename, Exception exception, String[] usedFiles, String reader) {
            super(exception);
            this.filename = filename;
            this.usedFiles = usedFiles;
            this.reader = reader;
        }

        public String toLog() {
            this.exception.printStackTrace();
            return super.toLog() + ": " + this.filename;
        }
    }

    public static class UNKNOWN_FORMAT
    extends EXCEPTION_EVENT {
        public final String filename;
        public final Object source;

        public UNKNOWN_FORMAT(String filename, Exception exception, Object source) {
            super(exception);
            this.filename = filename;
            this.source = source;
        }

        public String toLog() {
            return super.toLog() + ": " + this.filename;
        }
    }

    public static class INTERNAL_EXCEPTION
    extends EXCEPTION_EVENT {
        public final String filename;
        public final String[] usedFiles;
        public final String reader;

        public INTERNAL_EXCEPTION(String filename, Exception exception, String[] usedFiles, String reader) {
            super(exception);
            this.filename = filename;
            this.usedFiles = usedFiles;
            this.reader = reader;
        }

        public String toLog() {
            return String.format("%s: %s\n%s", super.toLog(), this.filename, ErrorHandler.getStackTrace(this.exception));
        }
    }

    public static abstract class EXCEPTION_EVENT
    extends ImportEvent {
        public final Exception exception;

        public EXCEPTION_EVENT(Exception exception) {
            this.exception = exception;
        }
    }
}

