/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import Ice.Identity;
import Ice.ObjectPrx;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.MimetypesFileTypeMap;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.conditions.InternalException;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.model.core.Image;
import ome.parameters.Parameters;
import ome.services.blitz.repo.ImportableFiles;
import ome.services.blitz.repo.RepoRawFileStoreI;
import ome.services.blitz.util.RegisterServantMessage;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.Filterable;
import ome.util.SqlAction;
import ome.util.messages.InternalMessage;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import omero.RString;
import omero.ServerError;
import omero.ValidationException;
import omero.api.RawFileStorePrx;
import omero.api.RawFileStorePrxHelper;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.ThumbnailStorePrx;
import omero.api._RawFileStoreOperations;
import omero.api._RawFileStoreTie;
import omero.grid.FileSet;
import omero.grid.RepositoryListConfig;
import omero.grid.RepositoryPrx;
import omero.grid._RepositoryDisp;
import omero.model.IObject;
import omero.model.ImageI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.model.Pixels;
import omero.model.PixelsType;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicRepositoryI
extends _RepositoryDisp {
    private static final Log log = LogFactory.getLog(PublicRepositoryI.class);
    private static final String OMERO_PATH = ".omero";
    private static final String THUMB_PATH = "thumbnails";
    private static final String IMAGE_NO_KEY = "image_no";
    public static final String NO_NAME_SET = "NO_NAME_SET";
    private final long id;
    private final File root;
    private final Executor executor;
    private final SqlAction sql;
    private final Principal principal;
    private final Map<String, omero.model.DimensionOrder> dimensionOrderMap = new ConcurrentHashMap<String, omero.model.DimensionOrder>();
    private final Map<String, PixelsType> pixelsTypeMap = new ConcurrentHashMap<String, PixelsType>();
    private String repoUuid;

    public PublicRepositoryI(File root, long repoObjectId, Executor executor, SqlAction sql, Principal principal) throws Exception {
        this.id = repoObjectId;
        this.executor = executor;
        this.sql = sql;
        this.principal = principal;
        if (root == null || !root.isDirectory()) {
            throw new ValidationException(null, null, "Root directory must be a existing, readable directory.");
        }
        this.root = root.getAbsoluteFile();
        this.repoUuid = null;
    }

    public OriginalFile root(Current __current) throws ServerError {
        return new OriginalFileI(this.id, false);
    }

    public OriginalFile register(String path, RString mimetype, Current __current) throws ServerError {
        File file = new File(path).getAbsoluteFile();
        OriginalFileI omeroFile = new OriginalFileI();
        omeroFile = this.createOriginalFile(file, mimetype);
        IceMapper mapper = new IceMapper();
        final ome.model.core.OriginalFile omeFile = (ome.model.core.OriginalFile)mapper.reverse((Object)omeroFile);
        Long id = (Long)this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork((Object)this, "register", new Object[]{path}){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return ((ome.model.core.OriginalFile)sf.getUpdateService().saveAndReturnObject((ome.model.IObject)omeFile)).getId();
            }
        });
        omeroFile.setId(rtypes.rlong((long)id));
        omeroFile.unload();
        return omeroFile;
    }

    public OriginalFile registerOriginalFile(OriginalFile omeroFile, Current __current) throws ServerError {
        if (omeroFile == null) {
            throw new ValidationException(null, null, "obj is required argument");
        }
        Principal currentUser = this.currentUser(__current);
        IceMapper mapper = new IceMapper();
        final ome.model.core.OriginalFile omeFile = (ome.model.core.OriginalFile)mapper.reverse((Object)omeroFile);
        final String repoId = this.getRepoUuid();
        Long id = (Long)this.executor.execute(currentUser, (Executor.Work)new Executor.SimpleWork((Object)this, "registerOriginalFile", new Object[]{repoId}){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                long id = ((ome.model.core.OriginalFile)sf.getUpdateService().saveAndReturnObject((ome.model.IObject)omeFile)).getId();
                PublicRepositoryI.this.sql.setFileRepo(id, repoId);
                return id;
            }
        });
        omeroFile.setId(rtypes.rlong((long)id));
        return omeroFile;
    }

    public List<IObject> registerFileSet(OriginalFile keyFile, List<omero.model.Image> imageList, Current __current) throws ServerError {
        if (keyFile == null) {
            throw new ValidationException(null, null, "keyFile is a required argument");
        }
        Principal currentUser = this.currentUser(__current);
        ArrayList<IObject> objList = new ArrayList<IObject>();
        IceMapper mapper = new IceMapper();
        final ome.model.IObject omeFile = (ome.model.IObject)mapper.reverse((Object)keyFile);
        final String repoId = this.getRepoUuid();
        String clientSessionUuid = (String)__current.ctx.get("omero.session.uuid");
        Long ofId = (Long)this.executor.execute(currentUser, (Executor.Work)new Executor.SimpleWork((Object)this, "registerParentFile", new Object[]{repoId}){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                long id = sf.getUpdateService().saveAndReturnObject(omeFile).getId();
                PublicRepositoryI.this.sql.setFileRepo(id, repoId);
                return id;
            }
        });
        keyFile.setId(rtypes.rlong((long)ofId));
        objList.add((IObject)keyFile);
        if (imageList == null || imageList.size() == 0) {
            return objList;
        }
        final String path = keyFile.getPath().getValue();
        final String name = keyFile.getName().getValue();
        int imageCount = 0;
        HashMap<String, String> params = new HashMap<String, String>();
        for (omero.model.Image obj : imageList) {
            params.put(IMAGE_NO_KEY, Integer.toString(imageCount));
            final HashMap<String, String> paramMap = params;
            final ome.model.IObject omeObj = (ome.model.IObject)mapper.reverse((Object)obj);
            Long id = (Long)this.executor.execute(currentUser, (Executor.Work)new Executor.SimpleWork((Object)this, "registerImageList", new Object[]{repoId}){

                @Transactional(readOnly=false)
                public Object doWork(Session session, ServiceFactory sf) {
                    long id = sf.getUpdateService().saveAndReturnObject(omeObj).getId();
                    ome.model.IObject result = sf.getQueryService().findByQuery("select p from Pixels p where p.image = " + id, null);
                    long pixId = result.getId();
                    PublicRepositoryI.this.sql.setPixelsNamePathRepo(pixId, name, path, repoId);
                    PublicRepositoryI.this.sql.setPixelsParams(pixId, paramMap);
                    return id;
                }
            });
            obj.setId(rtypes.rlong((long)id));
            objList.add((IObject)obj);
            ++imageCount;
        }
        return objList;
    }

    public List<omero.model.Image> importFileSet(OriginalFile keyFile, Current __current) throws ServerError {
        OMEROMetadataStoreClient store;
        Principal currentUser = this.currentUser(__current);
        final String name = keyFile.getName().getValue();
        final String path = keyFile.getPath().getValue();
        File file = new File(new File(this.root, path), name);
        final String repoId = this.getRepoUuid();
        String clientSessionUuid = (String)__current.ctx.get("omero.session.uuid");
        Map returnMap = (Map)this.executor.execute(currentUser, (Executor.Work)new Executor.SimpleWork((Object)this, "importFileSetMetadata", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                HashMap<Integer, Image> iMap = new HashMap<Integer, Image>();
                List pixIds = PublicRepositoryI.this.sql.findRepoPixels(repoId, path, name);
                if (pixIds == null || pixIds.size() == 0) {
                    return iMap;
                }
                for (Long pId : pixIds) {
                    Map params = PublicRepositoryI.this.sql.getPixelsParams(pId.longValue());
                    long pixelsId = pId;
                    Long imageId = PublicRepositoryI.this.sql.findRepoImageFromPixels(pixelsId);
                    Parameters p = new Parameters();
                    p.addId(new Long(imageId));
                    Image image = (Image)sf.getQueryService().findByQuery("select i from Image i join fetch i.pixels as p join fetch p.pixelsType join fetch p.dimensionOrder left outer join fetch p.channels left outer join fetch p.planeInfo left outer join fetch p.pixelsFileMaps left outer join fetch p.settings left outer join fetch p.thumbnails left outer join fetch i.instrument left outer join fetch i.imagingEnvironment left outer join fetch i.experiment left outer join fetch i.format left outer join fetch i.objectiveSettings left outer join fetch i.stageLabel left outer join fetch i.annotationLinks left outer join fetch i.wellSamples left outer join fetch i.rois where i.id = :id", p);
                    iMap.put(new Integer((String)params.get(PublicRepositoryI.IMAGE_NO_KEY)), image);
                }
                return iMap;
            }
        });
        if (returnMap == null) {
            return null;
        }
        IceMapper mapper = new IceMapper();
        Map imageMap = mapper.map(returnMap);
        for (Map.Entry entry : imageMap.entrySet()) {
            log.info((Object)("Image: " + ((omero.model.Image)entry.getValue()).getName().getValue() + ", series=" + ((Integer)entry.getKey()).toString() + ", id=" + Long.toString(((omero.model.Image)entry.getValue()).getId().getValue())));
        }
        ImportConfig config = new ImportConfig();
        config.hostname.set("localhost");
        config.port.set(new Integer(4064));
        config.sessionKey.set(clientSessionUuid);
        try {
            store = config.createStore();
        }
        catch (Exception e) {
            log.error((Object)"Failed to create OMEROMetadataStoreClient: ", (Throwable)e);
            return null;
        }
        OMEROWrapper reader = new OMEROWrapper(config);
        ImportLibrary library = new ImportLibrary(store, reader);
        library.setMetadataOnly(true);
        library.prepare(imageMap);
        List<Object> pix = new ArrayList();
        try {
            pix = library.importImage(file, 0, 0, 1, null, null, false, false, null, null);
        }
        catch (Throwable t) {
            log.error((Object)"Faled to importImage: ", t);
            return null;
        }
        ArrayList<omero.model.Image> images = new ArrayList<omero.model.Image>();
        int count = 0;
        for (omero.model.Image im : imageMap.values()) {
            im.clearPixels();
            im.addPixels((Pixels)pix.get(count));
            images.add(im);
            ++count;
        }
        return images;
    }

    public void delete(String path, Current __current) throws ServerError {
        File file = this.checkPath(path);
        FileUtils.deleteQuietly((File)file);
    }

    public List<OriginalFile> listFiles(String path, RepositoryListConfig config, Current __current) throws ServerError {
        Principal currentUser = this.currentUser(__current);
        File file = this.checkPath(path);
        if (!file.exists()) {
            throw new ValidationException(null, null, "Path does not exist");
        }
        if (!file.isDirectory()) {
            throw new ValidationException(null, null, "Path is not a directory");
        }
        RepositoryListConfig conf = config == null ? new RepositoryListConfig(1, true, true, false, true, false) : config;
        List<File> files = this.filteredFiles(file, conf);
        List<OriginalFile> oFiles = this.filesToOriginalFiles(files);
        if (conf.registered) {
            oFiles = this.knownOriginalFiles(oFiles, currentUser);
        }
        return oFiles;
    }

    public List<FileSet> listFileSets(String path, RepositoryListConfig config, Current __current) throws ServerError {
        List<FileSet> rv;
        Principal currentUser = this.currentUser(__current);
        File file = this.checkPath(path);
        if (!file.exists()) {
            throw new ValidationException(null, null, "Path does not exist");
        }
        if (!file.isDirectory()) {
            throw new ValidationException(null, null, "Path is not a directory");
        }
        RepositoryListConfig conf = config == null ? new RepositoryListConfig(1, true, true, false, true, false) : config;
        List<File> files = this.filteredFiles(file, conf);
        List<String> names = this.filesToPaths(files);
        List<ImportContainer> containers = this.importableImageFiles(path, conf.depth);
        try {
            rv = this.processImportContainers(containers, names, conf.showOriginalFiles, currentUser);
        }
        catch (InternalException e) {
            throw new omero.InternalException(this.stackTraceAsString(e), null, e.getMessage());
        }
        return rv;
    }

    public String mimetype(String path, Current __current) throws ServerError {
        File file = this.checkPath(path);
        if (!file.exists()) {
            throw new ValidationException(null, null, "Path does not exist");
        }
        return this.getMimetype(file);
    }

    public String getThumbnail(String path, Current __current) throws ServerError {
        Principal currentUser = this.currentUser(__current);
        File file = this.checkPath(path);
        if (!file.exists()) {
            throw new ValidationException(null, null, "Path does not exist");
        }
        if (!file.isFile()) {
            throw new ValidationException(null, null, "Path is not a file");
        }
        String tnPath = this.createThumbnail(file);
        return tnPath;
    }

    public String getThumbnailByIndex(String path, int imageIndex, Current __current) throws ServerError {
        Principal currentUser = this.currentUser(__current);
        File file = this.checkPath(path);
        if (!file.exists()) {
            throw new ValidationException(null, null, "Path does not exist");
        }
        if (!file.isFile()) {
            throw new ValidationException(null, null, "Path is not a file");
        }
        String tnPath = this.createThumbnail(file, imageIndex);
        return tnPath;
    }

    public boolean fileExists(String path, Current __current) throws ServerError {
        File file = this.checkPath(path);
        return file.exists();
    }

    public OriginalFile load(String path, Current __current) throws ServerError {
        return null;
    }

    public RawPixelsStorePrx pixels(String path, Current __current) throws ServerError {
        return null;
    }

    public RawFileStorePrx file(long fileId, Current __current) throws ServerError {
        Principal currentUser = this.currentUser(__current);
        File file = this.getFile(fileId, currentUser);
        if (file == null) {
            return null;
        }
        Current adjustedCurr = new Current();
        adjustedCurr.ctx = __current.ctx;
        adjustedCurr.operation = __current.operation;
        String sessionUuid = (String)__current.ctx.get("omero.session");
        adjustedCurr.id = new Identity(__current.id.name, sessionUuid);
        RepoRawFileStoreI rfs = new RepoRawFileStoreI(fileId, file);
        _RawFileStoreTie tie = new _RawFileStoreTie((_RawFileStoreOperations)rfs);
        RegisterServantMessage msg = new RegisterServantMessage((Object)this, (Ice.Object)tie, adjustedCurr);
        try {
            this.executor.getContext().publishMessage((InternalMessage)msg);
        }
        catch (Throwable t) {
            if (t instanceof ServerError) {
                throw (ServerError)t;
            }
            omero.InternalException ie = new omero.InternalException();
            IceMapper.fillServerError((ServerError)ie, (Throwable)t);
            throw ie;
        }
        ObjectPrx prx = msg.getProxy();
        if (prx == null) {
            throw new omero.InternalException(null, null, "No ServantHolder for proxy.");
        }
        return RawFileStorePrxHelper.uncheckedCast((ObjectPrx)prx);
    }

    public RawFileStorePrx read(String path, Current __current) throws ServerError {
        return null;
    }

    public void rename(String path, Current __current) throws ServerError {
    }

    public RenderingEnginePrx render(String path, Current __current) throws ServerError {
        return null;
    }

    public ThumbnailStorePrx thumbs(String path, Current __current) throws ServerError {
        return null;
    }

    public void transfer(String srcPath, RepositoryPrx target, String targetPath, Current __current) throws ServerError {
    }

    public RawFileStorePrx write(String path, Current __current) throws ServerError {
        return null;
    }

    private File checkPath(String path) throws ValidationException {
        if (path == null || path.length() == 0) {
            throw new ValidationException(null, null, "Path is empty");
        }
        boolean found = false;
        File file = new File(path).getAbsoluteFile();
        do {
            if (!file.equals(this.root)) continue;
            found = true;
            break;
        } while ((file = file.getParentFile()) != null);
        if (!found) {
            throw new ValidationException(null, null, path + " is not within " + this.root.getAbsolutePath());
        }
        return new File(path).getAbsoluteFile();
    }

    private List<File> filteredFiles(File file, RepositoryListConfig config) throws ServerError {
        IOFileFilter filter = config.hidden ? FileFilterUtils.trueFileFilter() : FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"."));
        if (!config.dirs || !config.files) {
            filter = config.dirs ? FileFilterUtils.makeDirectoryOnly((IOFileFilter)filter) : (config.files ? FileFilterUtils.makeFileOnly((IOFileFilter)filter) : FileFilterUtils.falseFileFilter());
        }
        List<File> files = Arrays.asList(file.listFiles((FileFilter)filter));
        return files;
    }

    private String getMimetype(File file) {
        String contentType = new MimetypesFileTypeMap().getContentType(file);
        return contentType;
    }

    private omero.model.DimensionOrder getDimensionOrder(String dimensionOrder) {
        if (this.dimensionOrderMap.size() == 0) {
            this.buildDimensionOrderMap(this.dimensionOrderMap);
        }
        return this.dimensionOrderMap.get(dimensionOrder);
    }

    private PixelsType getPixelsType(String pixelsType) {
        if (this.pixelsTypeMap.size() == 0) {
            this.buildPixelsTypeMap(this.pixelsTypeMap);
        }
        return this.pixelsTypeMap.get(pixelsType);
    }

    private List<OriginalFile> filesToOriginalFiles(Collection<File> files) {
        ArrayList<OriginalFile> rv = new ArrayList<OriginalFile>();
        for (File f : files) {
            rv.add(this.createOriginalFile(f));
        }
        return rv;
    }

    private List<String> filesToPaths(Collection<File> files) {
        ArrayList<String> rv = new ArrayList<String>();
        for (File f : files) {
            rv.add(f.getAbsolutePath());
        }
        return rv;
    }

    private List<OriginalFile> knownOriginalFiles(Collection<OriginalFile> files, Principal currentUser) {
        ArrayList<OriginalFile> rv = new ArrayList<OriginalFile>();
        for (OriginalFile f : files) {
            OriginalFile oFile = this.getOriginalFile(f.getPath().getValue(), f.getName().getValue(), currentUser);
            if (oFile != null) {
                rv.add(oFile);
                continue;
            }
            rv.add(f);
        }
        return rv;
    }

    private List<ImportContainer> importableImageFiles(String path, int depth) {
        String[] paths = new String[]{path};
        ImportableFiles imp = new ImportableFiles(paths, depth);
        List<ImportContainer> containers = imp.getContainers();
        return containers;
    }

    private List<FileSet> processImportContainers(List<ImportContainer> containers, List<String> names, boolean showOriginalFiles, Principal currentUser) {
        ArrayList<FileSet> rv = new ArrayList<FileSet>();
        for (ImportContainer ic : containers) {
            FileSet set = new FileSet();
            set.importableImage = true;
            set.fileName = ic.getFile().getAbsolutePath();
            set.parentFile = this.getOriginalFile(this.getRelativePath(ic.getFile()), ic.getFile().getName(), currentUser);
            if (set.parentFile == null) {
                set.parentFile = this.createOriginalFile(ic.getFile());
            }
            set.hidden = ic.getFile().isHidden();
            set.dir = ic.getFile().isDirectory();
            set.reader = ic.getReader();
            set.imageCount = ic.getBfImageCount();
            set.usedFiles = new ArrayList();
            List<String> iFileList = Arrays.asList(ic.getUsedFiles());
            for (String iFile : iFileList) {
                this.removeNameFromFileList(iFile, names);
                if (!showOriginalFiles) continue;
                File f = new File(iFile);
                OriginalFile oFile = this.getOriginalFile(this.getRelativePath(f), f.getName(), currentUser);
                if (oFile != null) {
                    set.usedFiles.add(oFile);
                    continue;
                }
                set.usedFiles.add(this.createOriginalFile(f));
            }
            int i = 0;
            set.imageList = new ArrayList();
            List<String> iNames = ic.getBfImageNames();
            for (Pixels pix : ic.getBfPixels()) {
                pix = this.createPixels(pix);
                String imageName = iNames.get(i);
                if (imageName == null) {
                    imageName = NO_NAME_SET;
                } else if (imageName.equals("")) {
                    imageName = NO_NAME_SET;
                }
                omero.model.Image image = this.getImage(set.fileName, i, currentUser);
                if (image == null) {
                    image = this.createImage(imageName, pix);
                }
                set.imageList.add(image);
                ++i;
            }
            rv.add(set);
        }
        if (names.size() > 0) {
            for (String iFile : names) {
                File f = new File(iFile);
                FileSet set = new FileSet();
                set.importableImage = false;
                set.fileName = iFile;
                set.parentFile = this.getOriginalFile(this.getRelativePath(f), f.getName(), currentUser);
                if (set.parentFile == null) {
                    set.parentFile = this.createOriginalFile(f);
                }
                set.hidden = f.isHidden();
                set.dir = f.isDirectory();
                set.imageCount = 0;
                set.usedFiles = new ArrayList();
                if (showOriginalFiles) {
                    OriginalFile oFile = this.getOriginalFile(this.getRelativePath(f), f.getName(), currentUser);
                    if (oFile != null) {
                        set.usedFiles.add(oFile);
                    } else {
                        set.usedFiles.add(this.createOriginalFile(f));
                    }
                }
                set.imageList = new ArrayList();
                rv.add(set);
            }
        }
        return rv;
    }

    private OriginalFile createOriginalFile(File f) {
        String mimetype = this.getMimetype(f);
        return this.createOriginalFile(f, rtypes.rstring((String)mimetype));
    }

    private OriginalFile createOriginalFile(File f, RString mimetype) {
        OriginalFileI file = new OriginalFileI();
        file.setName(rtypes.rstring((String)f.getName()));
        if (f.getAbsolutePath().equals(this.root.getAbsolutePath())) {
            file.setPath(rtypes.rstring((String)f.getParent()));
        } else {
            file.setPath(rtypes.rstring((String)this.getRelativePath(f)));
        }
        file.setSha1(rtypes.rstring((String)"UNKNOWN"));
        file.setMimetype(mimetype);
        file.setMtime(rtypes.rtime((long)f.lastModified()));
        file.setSize(rtypes.rlong((long)f.length()));
        return file;
    }

    private omero.model.Image createImage(String imageName, Pixels pix) {
        ImageI image = new ImageI();
        image.setName(rtypes.rstring((String)imageName));
        image.setAcquisitionDate(rtypes.rtime((long)System.currentTimeMillis()));
        image.addPixels(pix);
        return image;
    }

    private Pixels createPixels(Pixels pix) {
        omero.model.DimensionOrder dimOrder = this.getDimensionOrder("XYZCT");
        pix.setDimensionOrder(dimOrder);
        pix.setPixelsType(this.getPixelsType(pix.getPixelsType().getValue().getValue()));
        pix.setSha1(rtypes.rstring((String)"UNKNOWN"));
        return pix;
    }

    private OriginalFile getOriginalFile(final String path, final String name, Principal currentUser) {
        final String uuid = this.getRepoUuid();
        ome.model.core.OriginalFile oFile = (ome.model.core.OriginalFile)this.executor.execute(currentUser, (Executor.Work)new Executor.SimpleWork((Object)this, "getOriginalFile", new Object[]{uuid, path, name}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                try {
                    Long id = PublicRepositoryI.this.sql.findRepoFile(uuid, path, name, null);
                    return sf.getQueryService().find(ome.model.core.OriginalFile.class, id.longValue());
                }
                catch (EmptyResultDataAccessException e) {
                    return null;
                }
            }
        });
        if (oFile == null) {
            return null;
        }
        IceMapper mapper = new IceMapper();
        OriginalFile rv = (OriginalFile)mapper.map((Filterable)oFile);
        return rv;
    }

    private File getFile(final long id, Principal currentUser) {
        final String uuid = this.getRepoUuid();
        return (File)this.executor.execute(currentUser, (Executor.Work)new Executor.SimpleWork((Object)this, "getFile", new Object[]{id}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                String path = PublicRepositoryI.this.sql.findRepoFilePath(uuid, id);
                if (path == null) {
                    return null;
                }
                return new File(PublicRepositoryI.this.root, path);
            }
        });
    }

    private omero.model.Image getImage(String fullPath, int count, Principal currentUser) {
        String name;
        String path;
        File f = new File(fullPath);
        final String uuid = this.getRepoUuid();
        Image image = (Image)this.executor.execute(currentUser, (Executor.Work)new Executor.SimpleWork((Object)this, "getImage", new Object[0], path = this.getRelativePath(f), name = f.getName(), count){
            final /* synthetic */ String val$path;
            final /* synthetic */ String val$name;
            final /* synthetic */ int val$count;
            {
                this.val$path = string2;
                this.val$name = string3;
                this.val$count = n;
                super(x0, x1, x2);
            }

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                List pixIds = PublicRepositoryI.this.sql.findRepoPixels(uuid, this.val$path, this.val$name);
                if (pixIds == null || pixIds.size() == 0) {
                    return null;
                }
                long pixelsId = 0L;
                for (Long pId : pixIds) {
                    Map params = PublicRepositoryI.this.sql.getPixelsParams(pId.longValue());
                    if (Integer.parseInt((String)params.get(PublicRepositoryI.IMAGE_NO_KEY)) != this.val$count) continue;
                    pixelsId = pId;
                    break;
                }
                if (pixelsId == 0L) {
                    return null;
                }
                Long imageId = PublicRepositoryI.this.sql.findRepoImageFromPixels(pixelsId);
                return sf.getQueryService().find(Image.class, imageId.longValue());
            }
        });
        if (image == null) {
            return null;
        }
        IceMapper mapper = new IceMapper();
        omero.model.Image rv = (omero.model.Image)mapper.map((Filterable)image);
        return rv;
    }

    private Map<Integer, omero.model.Image> getImageMap(OriginalFile keyFile, Principal currentUser) {
        final String uuid = this.getRepoUuid();
        final String path = keyFile.getPath().getValue();
        final String name = keyFile.getName().getValue();
        Map imageMap = (Map)this.executor.execute(currentUser, (Executor.Work)new Executor.SimpleWork((Object)this, "getImageMap", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                HashMap<Integer, Image> iMap = new HashMap<Integer, Image>();
                List pixIds = PublicRepositoryI.this.sql.findRepoPixels(uuid, path, name);
                if (pixIds == null || pixIds.size() == 0) {
                    return iMap;
                }
                for (Long pId : pixIds) {
                    Map params = PublicRepositoryI.this.sql.getPixelsParams(pId.longValue());
                    long pixelsId = pId;
                    Long imageId = PublicRepositoryI.this.sql.findRepoImageFromPixels(pixelsId);
                    Image image = (Image)sf.getQueryService().find(Image.class, imageId.longValue());
                    iMap.put(new Integer((String)params.get(PublicRepositoryI.IMAGE_NO_KEY)), image);
                }
                return iMap;
            }
        });
        IceMapper mapper = new IceMapper();
        Map rv = mapper.map(imageMap);
        return rv;
    }

    private String createThumbnail(File file) throws ServerError {
        return this.createThumbnail(file, 0);
    }

    private String createThumbnail(File file, int imageIndex) throws ServerError {
        byte[] thumb;
        File parent = file.getParentFile();
        File tnParent = new File(new File(parent, OMERO_PATH), THUMB_PATH);
        tnParent.mkdirs();
        File tnFile = new File(tnParent, file.getName() + "_" + Integer.toString(imageIndex) + "_tn.jpg");
        if (tnFile.exists()) {
            return tnFile.getAbsolutePath();
        }
        ImageReader reader = new ImageReader();
        reader.setNormalized(true);
        try {
            reader.setId(file.getAbsolutePath());
            reader.setSeries(imageIndex);
            int z = reader.getSizeZ() / 2;
            int t = reader.getSizeT() / 2;
            int ndx = reader.getIndex(z, 0, t);
            thumb = reader.openThumbBytes(ndx);
        }
        catch (FormatException exc) {
            throw new ServerError(null, this.stackTraceAsString(exc), "Thumbnail error, read failed.");
        }
        catch (IOException exc) {
            throw new ServerError(null, this.stackTraceAsString(exc), "Thumbnail error, read failed.");
        }
        OMEXMLMetadata meta = null;
        try {
            loci.common.services.ServiceFactory sf = new loci.common.services.ServiceFactory();
            meta = ((OMEXMLService)sf.getInstance(OMEXMLService.class)).createOMEXMLMetadata();
        }
        catch (DependencyException e) {
            throw new ServerError(null, this.stackTraceAsString(e), "Thumbnail error, could not create OME-XML service.");
        }
        catch (ServiceException e) {
            throw new ServerError(null, this.stackTraceAsString(e), "Thumbnail error, could not create OME-XML metadata.");
        }
        int thumbSizeX = reader.getThumbSizeX();
        int thumbSizeY = reader.getThumbSizeY();
        meta.createRoot();
        meta.setImageID("Image:0", 0);
        meta.setPixelsID("Pixels:0", 0);
        meta.setPixelsBinDataBigEndian(Boolean.TRUE, 0, 0);
        meta.setPixelsDimensionOrder(DimensionOrder.XYZCT, 0);
        meta.setPixelsType(PixelType.UINT8, 0);
        meta.setPixelsSizeX(new PositiveInteger(Integer.valueOf(thumbSizeX)), 0);
        meta.setPixelsSizeY(new PositiveInteger(Integer.valueOf(thumbSizeY)), 0);
        meta.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(1)), 0);
        meta.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), 0);
        meta.setPixelsSizeT(new PositiveInteger(Integer.valueOf(1)), 0);
        meta.setChannelID("Channel:0:0", 0, 0);
        meta.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(1)), 0, 0);
        ImageWriter writer = new ImageWriter();
        writer.setMetadataRetrieve((MetadataRetrieve)meta);
        try {
            writer.setId(tnFile.getAbsolutePath());
            writer.saveBytes(0, thumb);
            writer.close();
        }
        catch (FormatException exc) {
            throw new ServerError(null, this.stackTraceAsString(exc), "Thumbnail error, write failed.\n File id: " + tnFile.getAbsolutePath());
        }
        catch (IOException exc) {
            throw new ServerError(null, this.stackTraceAsString(exc), "Thumbnail error, write failed.\n File id: " + tnFile.getAbsolutePath());
        }
        return tnFile.getAbsolutePath();
    }

    private String getRepoUuid() {
        if (this.repoUuid == null) {
            final long repoId = this.id;
            ome.model.core.OriginalFile oFile = (ome.model.core.OriginalFile)this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork((Object)this, "getRepoUuid", new Object[0]){

                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    return sf.getQueryService().find(ome.model.core.OriginalFile.class, repoId);
                }
            });
            OriginalFileI file = (OriginalFileI)new IceMapper().map((Filterable)oFile);
            this.repoUuid = file.getSha1().getValue();
        }
        return this.repoUuid;
    }

    private Map<String, omero.model.DimensionOrder> buildDimensionOrderMap(Map<String, omero.model.DimensionOrder> dimensionOrderMap) {
        List dimOrderList = (List)this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork((Object)this, "buildDimensionOrderMap", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findAllByQuery("from DimensionOrder as d", null);
            }
        });
        IceMapper mapper = new IceMapper();
        List dimensionOrderList = (List)mapper.map((Collection)dimOrderList);
        for (omero.model.DimensionOrder dimensionOrder : dimensionOrderList) {
            dimensionOrderMap.put(dimensionOrder.getValue().getValue(), dimensionOrder);
        }
        return dimensionOrderMap;
    }

    private Map<String, PixelsType> buildPixelsTypeMap(Map<String, PixelsType> pixelsTypeMap) {
        List pixTypeList = (List)this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork((Object)this, "buildPixelsTypeMap", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findAllByQuery("from PixelsType as p", null);
            }
        });
        IceMapper mapper = new IceMapper();
        List pixelsTypeList = (List)mapper.map((Collection)pixTypeList);
        for (PixelsType pixelsType : pixelsTypeList) {
            pixelsTypeMap.put(pixelsType.getValue().getValue(), pixelsType);
        }
        return pixelsTypeMap;
    }

    private String getRelativePath(File f) {
        String path = f.getParent().substring(this.root.getAbsolutePath().length(), f.getParent().length());
        path = path + "/";
        return path;
    }

    private void removeNameFromFileList(String sText, List<String> sList) {
        int index;
        for (index = 0; index < sList.size() && !sText.equals(sList.get(index)); ++index) {
        }
        if (index < sList.size()) {
            sList.remove(index);
        }
    }

    private String stackTraceAsString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private Principal currentUser(Current __current) {
        return new Principal((String)__current.ctx.get("omero.session.uuid"));
    }
}

