/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import Ice.ObjectAdapter;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.repo.AbstractRepositoryI;
import ome.services.util.Executor;
import ome.util.SqlAction;
import omero.ServerError;
import omero.ValidationException;
import omero.model.OriginalFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemporaryRepositoryI
extends AbstractRepositoryI {
    private static final Log log = LogFactory.getLog(TemporaryRepositoryI.class);

    public TemporaryRepositoryI(ObjectAdapter oa, Registry reg, Executor ex, SqlAction sql, String sessionUuid) {
        super(oa, reg, ex, sql, sessionUuid, System.getProperty("java.io.tmpdir"));
    }

    public String getFilePath(OriginalFile file, Current __current) throws ServerError {
        String repo = this.getFileRepo(file);
        if (repo == null || !repo.equals(this.getRepoUuid())) {
            String msg = String.format("%s (in %s) does not belong to this repository: %s", file.getId().getValue(), repo, this.getRepoUuid());
            throw new ValidationException(null, null, msg);
        }
        return file.getPath().getValue();
    }
}

