/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultListModel;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.gui.HistoryTableAbstractDataSource;
import ome.formats.importer.gui.ImportEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryDB
extends HistoryTableAbstractDataSource {
    private static Log log = LogFactory.getLog(HistoryDB.class);
    private static int DB_VERSION = 300;
    public SimpleDateFormat day = new SimpleDateFormat("MMM d, ''yy");
    public SimpleDateFormat hour = new SimpleDateFormat("HH:mm");
    private SimpleDateFormat sqlDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat sqlDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Connection conn;
    public static boolean alertOnce = false;

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void initializeDataSource() throws SQLException, ClassNotFoundException {
        String saveDirectory = System.getProperty("user.home") + File.separator + "omero";
        if (!new File(saveDirectory).exists()) {
            new File(saveDirectory).mkdir();
        }
        Class.forName("org.hsqldb.jdbcDriver");
        this.conn = DriverManager.getConnection("jdbc:hsqldb:file:" + saveDirectory + File.separator + "history" + "300", "sa", "");
        try {
            this.update("CREATE TABLE import_table ( uID INT IDENTITY, experimenterID BIGINT, date DATETIME, status VARCHAR(64) )");
            this.update("CREATE TABLE file_table ( uID INT IDENTITY, importID BIGINT, experimenterID BIGINT, rowNum INT, filename VARCHAR(256), projectID BIGINT, datasetID BIGINT, date DATETIME, status VARCHAR(64), filepath VARCHAR(256) )");
            this.update("CREATE TABLE db_version (version INT )");
            this.update("INSERT INTO db_version (version) VALUES('" + DB_VERSION + "'" + ")");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean wipeDataSource(Long experimenterID) {
        if (experimenterID == -1L) {
            try {
                this.update("DELETE * FROM import_table");
                this.update("DELETE * FROM file_table");
            }
            catch (SQLException e) {
                return false;
            }
            return true;
        }
        try {
            this.update("DELETE FROM import_table WHERE experimenterID = " + experimenterID);
            this.update("DELETE FROM file_table WHERE experimenterID = " + experimenterID);
        }
        catch (SQLException e) {
            String s = String.format("Error removing user history for experimenter %d.", experimenterID);
            log.error((Object)s, (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void shutdownDataSource() throws SQLException {
        Statement st = this.conn.createStatement();
        st.execute("SHUTDOWN");
        this.conn.close();
    }

    public ResultSet getImportResults(String table, Long experimenterID) {
        if (experimenterID == -1L) {
            try {
                return this.getQueryResults("SELECT * FROM " + table);
            }
            catch (SQLException e) {
                String s = String.format("Error retrieving results from %s as experimenter %d.", table, experimenterID);
                log.error((Object)s, (Throwable)e);
                return null;
            }
        }
        try {
            return this.getQueryResults("SELECT * FROM " + table + " WHERE ExperimenterID = " + experimenterID);
        }
        catch (SQLException e) {
            String s = String.format("Error retrieving results from %s as experimenter %d.", table, experimenterID);
            log.error((Object)s, (Throwable)e);
            return null;
        }
    }

    public ResultSet getFileResults(HistoryDB db, String table, int importID, Long experimenterID, String string, boolean done, boolean failed, boolean invalid, boolean pending, Date from, Date to) {
        String fromString = null;
        String toString = null;
        if (string == null) {
            string = "";
        }
        string = this.stripIllegalSearchCharacters(string);
        String queryString = "SELECT * FROM " + table + " WHERE ExperimenterID = " + experimenterID + " AND filename like '%" + string + "%'";
        queryString = done ? queryString + " AND (status = 'done'" : queryString + " AND (status != 'done'";
        queryString = failed ? (done ? queryString + " OR status = 'failed'" : queryString + " AND status = 'failed'") : queryString + " AND status != 'failed'";
        queryString = invalid ? (done || failed ? queryString + " OR status = 'invalid'" : queryString + " AND status = 'invalid'") : queryString + " AND status != 'invalid'";
        queryString = pending ? (done || failed || invalid ? queryString + " OR status = 'pending')" : queryString + " AND status = 'pending')") : queryString + " AND status != 'pending')";
        if (importID != -1) {
            queryString = queryString + " AND importID = " + importID;
        }
        if (from != null) {
            fromString = this.sqlDateFormat.format(from);
            queryString = queryString + " AND date >= '" + fromString + "'";
        }
        if (to != null) {
            toString = this.sqlDateFormat.format(this.getDaysBefore(to, 1));
            queryString = queryString + " AND date <= '" + toString + "'";
        }
        try {
            return this.getQueryResults(queryString);
        }
        catch (SQLException e) {
            String s = String.format("Error retrieving results with query string '%s'.", queryString);
            log.error((Object)s, (Throwable)e);
            return null;
        }
    }

    @Override
    public int addBaseTableRow(Long experimenterID, String status) throws SQLException {
        return this.update("INSERT INTO import_table(experimenterID, date, status) VALUES(" + experimenterID + ", " + "'" + this.sqlDateTimeFormat.format(new Date()) + "', " + "'" + status + "'" + " )");
    }

    @Override
    public int getLastBaseUid() throws SQLException {
        ResultSet rs = this.getGeneratedKeys();
        rs.next();
        return rs.getInt(1);
    }

    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        Statement st = null;
        st = this.conn.createStatement();
        String sql = "CALL IDENTITY()";
        ResultSet rs = st.executeQuery(sql);
        st.close();
        return rs;
    }

    @Override
    public int addItemTableRow(Long experimenterID, Integer importID, Integer rowNum, String filename, Long projectID, Long datasetID, String status, File file) throws SQLException {
        return this.update("INSERT INTO file_table(importID, experimenterID, rowNum, filename, projectID, datasetID, date, status, filepath) VALUES(" + importID + ", " + experimenterID + ", " + rowNum + ", " + "'" + filename + "', " + projectID + ", " + datasetID + ", " + "'" + this.sqlDateTimeFormat.format(new Date()) + "', " + "'" + status + "', " + "'" + file.getAbsolutePath() + "'" + " )");
    }

    @Override
    public Integer updateBaseStatus(int id, String status) throws SQLException {
        int result = this.update("UPDATE import_table SET status = '" + status + "' WHERE uID = " + id);
        this.notifyObservers(new ImportEvent.QUICKBAR_UPDATE());
        return result;
    }

    @Override
    public Integer updateItemStatus(int id, int rowNum, String status) throws SQLException {
        return this.update("UPDATE file_table SET status = '" + status + "' WHERE importID = " + id + " AND rowNum = " + rowNum);
    }

    public synchronized int update(String expression) throws SQLException {
        Statement st = null;
        st = this.conn.createStatement();
        int i = st.executeUpdate(expression);
        if (i == -1) {
            System.out.println("db error : " + expression);
        }
        st.close();
        return i;
    }

    public synchronized ResultSet getQueryResults(String expression) throws SQLException {
        Statement st = null;
        st = this.conn.createStatement();
        return st.executeQuery(expression);
    }

    @Override
    public DefaultListModel getBaseTableDataByDate(Date start, Date end) {
        try {
            ResultSet rs = this.getQueryResults("SELECT * FROM import_table WHERE date BETWEEN '" + this.sqlDateFormat.format(end) + "' AND '" + this.sqlDateFormat.format(start) + "'");
            DefaultListModel<ImportEntry> list = new DefaultListModel<ImportEntry>();
            while (rs.next()) {
                String icon = rs.getString("status").equals("complete") ? "gfx/import_done_16.png" : "gfx/warning_msg16.png";
                String dayString = this.day.format(rs.getObject("date"));
                String hourString = this.hour.format(rs.getObject("date"));
                if (this.day.format(new Date()).equals(dayString)) {
                    dayString = "Today";
                }
                if (this.day.format(this.getYesterday()).equals(dayString)) {
                    dayString = "Yesterday";
                }
                ImportEntry entry = new ImportEntry(dayString + " " + hourString, icon, rs.getInt("uID"));
                list.addElement(entry);
            }
            return list;
        }
        catch (SQLException e) {
            String s = String.format("Error retrieving import list from %s to %s.", start.toString(), end.toString());
            log.error((Object)s, (Throwable)e);
            return null;
        }
    }

    @Override
    public Vector<Object> getBaseQuery(Long experimenterID) {
        return null;
    }

    @Override
    public Vector<Object> getItemQuery(Long importID, Long experimenterID, String queryString, Date from, Date to) {
        return null;
    }
}

