/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.Iterator;
import java.util.List;
import ome.formats.model.ChannelData;
import omero.RInt;
import omero.model.Channel;
import omero.model.Filter;
import omero.model.Laser;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.model.TransmittanceRange;

public class ColorsFactory {
    public static final int RED_INDEX = 0;
    public static final int GREEN_INDEX = 1;
    public static final int BLUE_INDEX = 2;
    public static final int ALPHA_INDEX = 3;
    static final int DEFAULT_ALPHA = 255;
    private static final int BLUE_MIN = 400;
    private static final int BLUE_MAX = 500;
    private static final int GREEN_MIN = 501;
    private static final int GREEN_MAX = 559;
    private static final int RED_MIN = 560;
    private static final int RED_MAX = 700;
    private static final int RANGE = 15;

    private static boolean rangeBlue(int wavelength) {
        return wavelength <= 500;
    }

    private static boolean rangeGreen(int wavelength) {
        return wavelength >= 501 && wavelength <= 559;
    }

    private static boolean rangeRed(int wavelength) {
        return wavelength >= 560;
    }

    private static Integer getValue(RInt value) {
        return value == null ? null : Integer.valueOf(value.getValue());
    }

    private static boolean isFilterHasEmissionData(Filter f) {
        if (f == null) {
            return false;
        }
        TransmittanceRange transmittance = f.getTransmittanceRange();
        if (transmittance == null) {
            return false;
        }
        return transmittance.getCutIn() != null;
    }

    private static boolean hasEmissionExcitationData(ChannelData channelData, boolean full) {
        Laser laser;
        LightSource src;
        Filter f;
        Iterator<Filter> i;
        LogicalChannel lc = channelData.getLogicalChannel();
        if (lc == null) {
            return false;
        }
        if (lc.getEmissionWave() != null) {
            return true;
        }
        List<Filter> filters = channelData.getLightPathEmissionFilters();
        if (filters != null) {
            i = filters.iterator();
            while (i.hasNext()) {
                if (!ColorsFactory.isFilterHasEmissionData(i.next())) continue;
                return true;
            }
        }
        if (channelData.getFilterSet() != null && ColorsFactory.isFilterHasEmissionData(f = channelData.getFilterSetEmissionFilter())) {
            return true;
        }
        if (!full) {
            return false;
        }
        if (channelData.getLightSource() != null && (src = channelData.getLightSource()) instanceof Laser && (laser = (Laser)src).getWavelength() != null) {
            return true;
        }
        if (lc.getExcitationWave() != null) {
            return true;
        }
        filters = channelData.getLightPathExcitationFilters();
        if (filters != null) {
            i = filters.iterator();
            while (i.hasNext()) {
                if (!ColorsFactory.isFilterHasEmissionData(i.next())) continue;
                return true;
            }
        }
        return channelData.getFilterSet() != null && ColorsFactory.isFilterHasEmissionData(f = channelData.getFilterSetExcitationFilter());
    }

    static Integer getValueFromFilter(Filter filter, boolean emission) {
        Integer v;
        if (filter == null) {
            return null;
        }
        TransmittanceRange transmittance = filter.getTransmittanceRange();
        if (transmittance == null) {
            return null;
        }
        Integer cutIn = ColorsFactory.getValue(transmittance.getCutIn());
        if (emission) {
            if (cutIn == null) {
                return null;
            }
            return cutIn + 15;
        }
        Integer cutOut = ColorsFactory.getValue(transmittance.getCutOut());
        if (cutOut == null) {
            return null;
        }
        if (cutIn == null || cutIn == 0) {
            cutIn = cutOut - 30;
        }
        if ((v = Integer.valueOf((cutIn + cutOut) / 2)) < 0) {
            return 0;
        }
        return v;
    }

    public static int[] getColor(ChannelData channelData) {
        int[] toReturn;
        LightSource ls;
        Iterator<Filter> i;
        Integer value;
        LogicalChannel lc = channelData.getLogicalChannel();
        Channel channel = channelData.getChannel();
        if (lc == null) {
            return null;
        }
        if (!ColorsFactory.hasEmissionExcitationData(channelData, true)) {
            Integer red = ColorsFactory.getValue(channel.getRed());
            Integer green = ColorsFactory.getValue(channel.getGreen());
            Integer blue = ColorsFactory.getValue(channel.getBlue());
            Integer alpha = ColorsFactory.getValue(channel.getAlpha());
            if (red != null && green != null && blue != null && alpha != null) {
                return new int[]{red, green, blue, alpha};
            }
        }
        if ((value = ColorsFactory.getValue(lc.getEmissionWave())) != null) {
            return ColorsFactory.determineColor(value);
        }
        List<Filter> filters = channelData.getLightPathEmissionFilters();
        if (filters != null) {
            i = filters.iterator();
            while (value == null && i.hasNext()) {
                value = ColorsFactory.getValueFromFilter(i.next(), true);
            }
        }
        if (value == null) {
            value = ColorsFactory.getValueFromFilter(channelData.getFilterSetEmissionFilter(), true);
        }
        if (value == null && channelData.getLightSource() != null && (ls = channelData.getLightSource()) instanceof Laser) {
            value = ColorsFactory.getValue(((Laser)ls).getWavelength());
        }
        if (value != null) {
            return ColorsFactory.determineColor(value);
        }
        value = ColorsFactory.getValue(lc.getExcitationWave());
        if (value != null) {
            return ColorsFactory.determineColor(value);
        }
        if (value == null && (filters = channelData.getLightPathExcitationFilters()) != null) {
            i = filters.iterator();
            while (value == null && i.hasNext()) {
                value = ColorsFactory.getValueFromFilter(i.next(), false);
            }
        }
        if (value == null) {
            value = ColorsFactory.getValueFromFilter(channelData.getFilterSetExcitationFilter(), false);
        }
        if ((toReturn = ColorsFactory.determineColor(value)) != null) {
            return toReturn;
        }
        switch (channelData.getChannelIndex()) {
            case 0: {
                return ColorsFactory.newRedColor();
            }
            case 1: {
                return ColorsFactory.newGreenColor();
            }
        }
        return ColorsFactory.newBlueColor();
    }

    public static int[] determineColor(Integer value) {
        if (value == null) {
            return null;
        }
        if (ColorsFactory.rangeBlue(value)) {
            return ColorsFactory.newBlueColor();
        }
        if (ColorsFactory.rangeGreen(value)) {
            return ColorsFactory.newGreenColor();
        }
        if (ColorsFactory.rangeRed(value)) {
            return ColorsFactory.newRedColor();
        }
        return null;
    }

    public static boolean hasEmissionData(ChannelData channelData) {
        return ColorsFactory.hasEmissionExcitationData(channelData, false);
    }

    public static int[] newRedColor() {
        return new int[]{255, 0, 0, 255};
    }

    public static int[] newGreenColor() {
        return new int[]{0, 255, 0, 255};
    }

    public static int[] newBlueColor() {
        return new int[]{0, 0, 255, 255};
    }

    public static int[] newGreyColor() {
        return new int[]{128, 128, 128, 255};
    }

    public static int[] newWhiteColor() {
        return new int[]{255, 255, 255, 255};
    }
}

