/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.util.IniFileLoader;
import ome.system.UpgradeCheck;
import omero.model.Annotation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportConfig {
    private static final Log log = LogFactory.getLog(ImportConfig.class);
    public static final String SERVER_NAME_SEPARATOR = ",";
    public static final String READERS_KEY = "omero.import.readers";
    private final Preferences prefs;
    private final IniFileLoader ini;
    private final Properties props;
    private String omeroVersion = "Unknown";
    public final StrValue hostname;
    public final StrValue username;
    public final StrValue password;
    public final IntValue port;
    public final LongValue savedProject;
    public final LongValue savedDataset;
    public final LongValue savedScreen;
    public final StrValue sessionKey;
    public final LongValue group;
    public final StrValue email;
    public final StrValue serverList;
    public final StrValue imageName;
    public final StrValue imageDescription;
    public final StrValue plateName;
    public final StrValue plateDescription;
    public final StrValue targetClass;
    public final LongValue targetId;
    public final BoolValue debug;
    public final BoolValue contOnError;
    public final BoolValue sendReport;
    public final BoolValue sendFiles;
    public final BoolValue sendLogFile;
    public final BoolValue companionFile;
    public final BoolValue archiveImage;
    public final BoolValue useCustomImageNaming;
    public final BoolValue useFullPath;
    public final IntValue numOfDirectories;
    public final FileValue savedDirectory;
    public final StrValue readersPath;
    public final BoolValue encryptedConnection;
    public final AnnotationListValue annotations;
    public final DoubleArrayValue userPixels;

    private static Preferences prefs() {
        Preferences prefs = Preferences.userNodeForPackage(ImportConfig.class);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            log.error((Object)"Error flushing preferences");
        }
        return prefs;
    }

    public ImportConfig() {
        this(null);
    }

    public ImportConfig(File configFile) {
        this(ImportConfig.prefs(), new IniFileLoader(configFile), System.getProperties());
    }

    public ImportConfig(Preferences prefs, IniFileLoader ini, Properties props) {
        this.prefs = prefs;
        this.props = props;
        this.ini = ini;
        this.isUpgradeRequired();
        if (ini != null) {
            ini.updateFlexReaderServerMaps();
        }
        log.info((Object)String.format("Bioformats version: %s revision: %s date: %s", "5.0-DEV", "7175", "9 November 2010"));
        this.hostname = new StrValue("hostname", this, "omero.host");
        this.username = new StrValue("username", this, "omero.name");
        this.password = new StrValue("password", this, "omero.pass");
        this.port = new IntValue("port", this, 4064, "omero.port"){

            public synchronized void load() {
                super.load();
                if (this._current.compareAndSet(null, this._default)) {
                    log.debug((Object)"Replacing port load value with default");
                }
            }
        };
        this.sessionKey = new StrValue("session", this);
        this.group = new LongValue("group", this, 0L);
        this.email = new StrValue("email", this);
        this.serverList = new StrValue("serverList", this);
        this.imageName = new StrValue("imageName", this);
        this.imageDescription = new StrValue("imageDescription", this);
        this.plateName = new StrValue("plateName", this);
        this.plateDescription = new StrValue("plateDescription", this);
        this.targetClass = new StrValue("targetClass", this);
        this.targetId = new LongValue("targetId", this, 0L);
        this.savedProject = new LongValue("savedProject", this, 0L);
        this.savedDataset = new LongValue("savedDataset", this, 0L);
        this.savedScreen = new LongValue("savedScreen", this, 0L);
        this.debug = new BoolValue("debug", this, false);
        this.contOnError = new BoolValue("contOnError", this, false);
        this.sendReport = new BoolValue("sendReport", this, false);
        this.sendFiles = new BoolValue("sendFiles", this, true);
        this.companionFile = new BoolValue("companionFile", this, true);
        this.sendLogFile = new BoolValue("sendLogFile", this, true);
        this.archiveImage = new BoolValue("archive", this, false);
        this.useFullPath = new BoolValue("useFullPath", this, true);
        this.useCustomImageNaming = new BoolValue("overrideImageName", this, true);
        this.numOfDirectories = new IntValue("numOfDirectories", this, 0);
        this.savedDirectory = new FileValue("savedDirectory", this);
        this.encryptedConnection = new BoolValue("ecryptedConnection", this, true);
        this.annotations = new AnnotationListValue("annotations", this, (List<Annotation>)new ArrayList<Annotation>());
        this.userPixels = new DoubleArrayValue("userPixels", this, null);
        this.readersPath = new StrValue("readersPath", this);
    }

    public boolean isUpgradeRequired() {
        ResourceBundle bundle = ResourceBundle.getBundle("omero");
        this.omeroVersion = bundle.getString("omero.version");
        log.info((Object)("OMERO Version: " + this.omeroVersion));
        String url = bundle.getString("omero.upgrades.url");
        UpgradeCheck check = new UpgradeCheck(url, this.omeroVersion, "importer");
        check.run();
        return check.isUpgradeNeeded();
    }

    public void configureDebug(Level level) {
        if (level == null) {
            level = Level.toLevel((int)this.ini.getDebugLevel());
        }
        Logger.getLogger((String)"ome.formats").setLevel(level);
        Logger.getLogger((String)"loci").setLevel(level);
    }

    public OMEROMetadataStoreClient createStore() throws Exception {
        if (!this.canLogin()) {
            throw new RuntimeException("Can't create store. See canLogin()");
        }
        OMEROMetadataStoreClient client2 = new OMEROMetadataStoreClient();
        if (this.sessionKey.empty()) {
            client2.initialize((String)this.username.get(), (String)this.password.get(), (String)this.hostname.get(), (Integer)this.port.get(), (Long)this.group.get(), (Boolean)this.encryptedConnection.get());
        } else {
            client2.initialize((String)this.hostname.get(), (Integer)this.port.get(), (String)this.sessionKey.get(), (Boolean)this.encryptedConnection.get());
        }
        return client2;
    }

    public boolean canLogin() {
        return (!this.username.empty() && !this.password.empty() || !this.sessionKey.empty()) && !this.hostname.empty();
    }

    public String getLogFile() {
        return this.ini.getLogFile();
    }

    public String getHomeUrl() {
        return this.ini.getHomeUrl();
    }

    public String getForumUrl() {
        return this.ini.getForumUrl();
    }

    public String getAppTitle() {
        return this.ini.getAppTitle();
    }

    public String getVersionNumber() {
        return this.omeroVersion;
    }

    public String getIniVersionNumber() {
        return this.ini.getVersionNumber();
    }

    public String getUserSettingsDirectory() {
        return this.ini.getUserSettingsDirectory();
    }

    public boolean getUseQuaqua() {
        return this.ini.getUseQuaqua();
    }

    public void setUseQuaqua(boolean b) {
        this.ini.setUseQuaqua(b);
    }

    public void setDebugLevel(int level) {
        this.ini.setDebugLevel(level);
    }

    public int getDebugLevel() {
        return this.ini.getDebugLevel();
    }

    public Rectangle getUIBounds() {
        return this.ini.getUIBounds();
    }

    public void setUIBounds(Rectangle bounds) {
        this.ini.setUIBounds(bounds);
    }

    public String getFeedbackUrl() {
        return this.ini.getUploaderURL();
    }

    public String getTokenUrl() {
        return this.ini.getUploaderTokenURL();
    }

    public String getUploaderUrl() {
        return this.ini.getUploaderURL();
    }

    public boolean getUserFullPath() {
        return this.ini.getUserFullPath();
    }

    public void setUserFullPath(boolean b) {
        this.ini.setUserFullPath(b);
    }

    public boolean getCustomImageNaming() {
        return this.ini.getCustomImageNaming();
    }

    public void setCustomImageNaming(boolean b) {
        this.ini.setCustomImageNaming(b);
    }

    public int getNumOfDirectories() {
        return this.ini.getNumOfDirectories();
    }

    public void setNumOfDirectories(int i) {
        this.ini.setNumOfDirectories(i);
    }

    public List<String> getServerList() {
        if (this.serverList.empty() || ((String)this.serverList.get()).trim().length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] l = ((String)this.serverList.get()).split(SERVER_NAME_SEPARATOR, 0);
        if (l == null || l.length == 0) {
            return null;
        }
        if (list != null) {
            list.clear();
        }
        for (int index = 0; index < l.length; ++index) {
            if (list == null) continue;
            list.add(l[index].trim());
        }
        return list;
    }

    public void updateServerList(String currentServer) {
        List<String> l = this.getServerList();
        if (l != null && l.contains(currentServer)) {
            return;
        }
        if (this.serverList.empty() || ((String)this.serverList.get()).length() == 0) {
            this.serverList.set(currentServer.trim());
        } else {
            this.serverList.set(this.serverList + SERVER_NAME_SEPARATOR + currentServer);
        }
    }

    public void removeServer(String server) {
        List<String> l = this.getServerList();
        if (l == null) {
            return;
        }
        l.remove(server);
        Iterator<String> i = l.iterator();
        String list = "";
        int n = l.size() - 1;
        int index = 0;
        while (i.hasNext()) {
            list = list + i.next();
            if (index != n) {
                list = list + SERVER_NAME_SEPARATOR;
            }
            ++index;
        }
        this.serverList.set(list);
    }

    protected void prompt(Value value, String prompt, boolean hide) {
        String v = value.toString();
        if (hide) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < v.length(); ++i) {
                sb.append("*");
            }
            v = sb.toString();
        }
        System.out.print(String.format("%s[%s]:", prompt, v));
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    String input;
                    if ((input = br.readLine()) == null || input.trim().equals("")) {
                        continue;
                    }
                    value.set(value.fromString(input));
                }
            }
            catch (IOException e) {
                log.error((Object)"IGNORING: ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void requestFromUser() {
        if (!this.canLogin()) {
            this.loadAll();
            this.prompt(this.hostname, " Enter server name: ", false);
            this.prompt(this.username, " Enter user name: ", false);
            this.prompt(this.password, " Enter password: ", true);
        }
    }

    protected List<Value<?>> values() {
        ArrayList rv = new ArrayList();
        for (Field f : this.getClass().getFields()) {
            try {
                Object o = f.get(this);
                if (!(o instanceof Value)) continue;
                Value cv = (Value)o;
                rv.add(cv);
            }
            catch (Exception e) {
                log.debug((Object)("Error during field lookup: " + e));
            }
        }
        return rv;
    }

    public Map<String, String> map() {
        HashMap<String, String> rv = new HashMap<String, String>();
        for (Value<?> cv : this.values()) {
            rv.put(cv.key, cv.toString());
        }
        return rv;
    }

    public void loadGui() {
        this.email.load();
        this.archiveImage.load();
    }

    public void saveGui() {
        this.email.store();
        this.archiveImage.store();
    }

    public void loadAll() {
        this.savedProject.load();
        this.savedDataset.load();
        this.savedScreen.load();
        this.useCustomImageNaming.load();
        this.useFullPath.load();
        this.numOfDirectories.load();
        this.savedDirectory.load();
        this.companionFile.load();
        this.sendLogFile.load();
        this.sendFiles.load();
        this.sendReport.load();
        this.port.load();
    }

    public void saveAll() {
        this.savedProject.store();
        this.savedDataset.store();
        this.savedScreen.store();
        this.useCustomImageNaming.store();
        this.useFullPath.store();
        this.numOfDirectories.store();
        this.savedDirectory.store();
        this.companionFile.store();
        this.sendLogFile.store();
        this.sendFiles.store();
        this.sendReport.store();
        try {
            this.prefs.flush();
            this.ini.flushPreferences();
        }
        catch (BackingStoreException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileValue
    extends Value<File> {
        public FileValue(String key, ImportConfig config) {
            super(key, config);
        }

        @Override
        protected File fromString(String arg0) {
            if (arg0 == null) {
                return null;
            }
            return new File(arg0);
        }

        @Override
        public File get() {
            File f = (File)super.get();
            if (f != null && f.exists()) {
                return f;
            }
            this.set(null);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongValue
    extends Value<Long> {
        public LongValue(String key, ImportConfig config, long defValue) {
            super(key, config, defValue);
        }

        @Override
        protected Long fromString(String arg0) {
            try {
                return Long.valueOf(arg0);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntValue
    extends Value<Integer> {
        public IntValue(String key, ImportConfig config, int defValue) {
            super(key, config, defValue);
        }

        public IntValue(String key, ImportConfig config, int defValue, String omeroKey) {
            super(key, config, defValue, omeroKey);
        }

        @Override
        protected Integer fromString(String arg0) {
            try {
                return Integer.valueOf(arg0);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BoolValue
    extends Value<Boolean> {
        public BoolValue(String key, ImportConfig config, boolean defValue) {
            super(key, config, defValue);
        }

        @Override
        protected Boolean fromString(String arg0) {
            if (arg0 == null) {
                return null;
            }
            return Boolean.parseBoolean(arg0);
        }
    }

    public static class PassValue
    extends StrValue {
        public PassValue(String key, ImportConfig config) {
            super(key, config);
        }

        public synchronized void store() {
            log.trace((Object)"Skipping password storage");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleArrayValue
    extends Value<Double[]> {
        public DoubleArrayValue(String key, ImportConfig config, Double[] defValue) {
            super(key, config, defValue);
        }

        @Override
        protected Double[] fromString(String string) {
            throw new RuntimeException("Not implemented.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationListValue
    extends Value<List<Annotation>> {
        public AnnotationListValue(String key, ImportConfig config, List<Annotation> defValue) {
            super(key, config, defValue);
        }

        @Override
        protected List<Annotation> fromString(String string) {
            throw new RuntimeException("Not implemented.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StrValue
    extends Value<String> {
        public StrValue(String key, ImportConfig config) {
            super(key, config);
        }

        public StrValue(String key, ImportConfig config, String defValue) {
            super(key, config, defValue);
        }

        public StrValue(String key, ImportConfig config, String defValue, String omeroKey) {
            super(key, config, defValue, omeroKey);
        }

        @Override
        protected String fromString(String arg0) {
            return arg0;
        }

        @Override
        public boolean empty() {
            String s = (String)this.get();
            return s == null || s.length() == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Value<T> {
        final AtomicReference<T> _current = new AtomicReference();
        final String key;
        final String omeroKey;
        final Preferences prefs;
        final IniFileLoader ini;
        final Properties props;
        final T _default;
        Object which = null;

        Value(String key, ImportConfig config) {
            this(key, config, null, null);
        }

        Value(String key, ImportConfig config, T defValue) {
            this(key, config, defValue, null);
        }

        Value(String key, ImportConfig config, T defValue, String omeroKey) {
            this.key = key;
            this.omeroKey = omeroKey;
            this.ini = config.ini;
            this.prefs = config.prefs;
            this.props = config.props;
            this._default = defValue;
            this._current.set(null);
        }

        public T get() {
            if (this._current.get() == null) {
                return this._default;
            }
            return this._current.get();
        }

        public void set(T t) {
            this._current.set(t);
        }

        public String toString() {
            T t = this.get();
            if (t == null) {
                return "";
            }
            return t.toString();
        }

        public synchronized void store() {
            if (this.which instanceof Properties || this.which instanceof Preferences) {
                this.prefs.put(this.key, this.toString());
                log.debug((Object)("Saved " + this.key + " to " + this.prefs));
            } else if (this.which instanceof IniFileLoader) {
                log.debug((Object)("Saved " + this.key + " to " + this.ini));
            } else if (this.which == null && this.prefs != null) {
                this.prefs.put(this.key, this.toString());
                log.debug((Object)("Freshly saved " + this.key + " to " + this.prefs));
            } else {
                log.debug((Object)("WHICH:" + this.which));
            }
        }

        public synchronized void load() {
            if (this.empty() && this.props != null) {
                this.set(this.fromString(this.props.getProperty(this.key)));
                if (!this.empty()) {
                    this.which = this.props;
                    log.debug((Object)("Loaded " + this.key + " from " + this.props));
                    return;
                }
            }
            if (this.empty() && this.prefs != null) {
                this.set(this.fromString(this.prefs.get(this.key, "")));
                if (!this.empty()) {
                    this.which = this.prefs;
                    log.debug((Object)("Loaded " + this.key + " from " + this.prefs));
                    return;
                }
            }
            if (this.empty() && this.ini != null) {
                log.debug((Object)("Loaded " + this.key + " from " + this.ini));
            }
            if (this.empty()) {
                this.set(this._default);
                log.debug((Object)("Loaded " + this.key + " from default"));
                this.which = null;
            }
        }

        public boolean empty() {
            return this.get() == null;
        }

        protected abstract T fromString(String var1);
    }
}

