/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import loci.formats.IFormatHandler;
import loci.formats.gui.GUITools;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.gui.GuiCommonElements;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileQueueChooser
extends JFileChooser
implements ActionListener {
    public static final String REFRESHED = "refreshed";
    private Log log = LogFactory.getLog(FileQueueChooser.class);
    boolean DEBUG = false;
    private static final long serialVersionUID = 1L;
    private String laf = UIManager.getLookAndFeel().getClass().getName();
    private Component[] fileListObjects;
    private Component fileList = null;
    JButton refreshBtn;

    FileQueueChooser(ImportConfig config, OMEROWrapper scanReader) {
        try {
            JPanel fp = null;
            JToolBar tb = null;
            String refreshIcon = "gfx/recycled12.png";
            this.refreshBtn = GuiCommonElements.addBasicButton("Refresh ", refreshIcon, null);
            this.refreshBtn.setActionCommand(REFRESHED);
            this.refreshBtn.addActionListener(this);
            JPanel panel = new JPanel();
            double[][] mainTable = new double[][]{{10.0, -1.0, -2.0, -1.0, 10.0}, {-2.0}};
            TableLayout tl = new TableLayout((double[][])mainTable);
            panel.setLayout((LayoutManager)tl);
            if (this.DEBUG) {
                try {
                    Component[] components = this.getComponents();
                    Component component = null;
                    System.err.println("Components: " + components.length);
                    for (int i = 0; i < components.length; ++i) {
                        component = components[i];
                        System.err.println("Component " + i + " = " + component.getClass());
                    }
                }
                catch (Exception e) {
                    this.log.info((Object)"component exception ignore");
                }
            }
            if (this.laf.contains("AquaLookAndFeel")) {
                fp = (JPanel)this.getComponent(1);
                fp.setLayout(new BoxLayout(fp, 0));
                fp.add(this.refreshBtn);
            } else if (this.laf.contains("QuaquaLookAndFeel")) {
                fp = (JPanel)this.getComponent(1);
                panel.add((Component)this.refreshBtn, "1,0,C,C");
                panel.add(fp.getComponent(0), "2,0,C,C");
                fp.add((Component)panel, "North");
            } else if (this.laf.contains("Windows")) {
                try {
                    tb = (JToolBar)this.getComponent(1);
                    this.refreshBtn.setToolTipText("Refresh");
                    this.refreshBtn.setText(null);
                    tb.add((Component)this.refreshBtn, 8);
                }
                catch (Exception e) {
                    this.log.info((Object)"Exception ignored.");
                }
            } else if (this.laf.contains("MetalLookAndFeel")) {
                JPanel prefp = (JPanel)this.getComponent(0);
                fp = (JPanel)prefp.getComponent(0);
                this.refreshBtn.setToolTipText("Refresh");
                this.refreshBtn.setText(null);
                Dimension size = new Dimension(24, 24);
                this.refreshBtn.setMaximumSize(size);
                this.refreshBtn.setPreferredSize(size);
                this.refreshBtn.setMinimumSize(size);
                this.refreshBtn.setSize(size);
                fp.add(Box.createRigidArea(new Dimension(5, 0)));
                fp.add(this.refreshBtn);
            } else if (this.laf.contains("GTKLookAndFeel")) {
                fp = (JPanel)this.getComponent(0);
                this.refreshBtn.setIcon(null);
                fp.add(this.refreshBtn);
            } else if (this.laf.contains("MotifLookAndFeel")) {
                fp = (JPanel)this.getComponent(0);
                fp.add(this.refreshBtn);
            }
            if (fp != null && this.DEBUG) {
                fp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), fp.getBorder()));
                System.err.println(fp.getLayout());
            }
            if (tb != null && this.DEBUG) {
                tb.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), tb.getBorder()));
                System.err.println(tb.getLayout());
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        File dir = null;
        if (config != null) {
            dir = config.savedDirectory.get();
        }
        if (dir != null) {
            this.setCurrentDirectory(dir);
        } else {
            this.setCurrentDirectory(this.getFileSystemView().getHomeDirectory());
        }
        this.setControlButtonsAreShown(false);
        this.setFileSelectionMode(2);
        this.setMultiSelectionEnabled(true);
        this.setDragEnabled(true);
        this.setAcceptAllFileFilterUsed(false);
        FileFilter[] originalFF = null;
        int readerFFSize = 0;
        if (scanReader != null) {
            originalFF = GUITools.buildFileFilters((IFormatHandler)scanReader.getImageReader());
            readerFFSize = originalFF.length;
        }
        FileFilter[] ff = new FileFilter[readerFFSize + 7];
        ff[0] = new DashFileFilter();
        ff[readerFFSize + 1] = new DashFileFilter();
        ff[readerFFSize + 2] = new R3DNewFileFilter();
        ff[readerFFSize + 3] = new R3DOldFileFilter();
        ff[readerFFSize + 4] = new D3DNewFileFilter();
        ff[readerFFSize + 5] = new D3DOldFileFilter();
        ff[readerFFSize + 6] = new D3DNPrjFileFilter();
        if (originalFF != null) {
            System.arraycopy(originalFF, 0, ff, 1, originalFF.length);
        }
        for (int i = 0; i < ff.length; ++i) {
            this.addChoosableFileFilter(ff[i]);
        }
        this.setFileFilter(ff[1]);
        this.fileListObjects = this.getFileListObjects(this);
        if (this.fileListObjects.length > 0 && !this.laf.contains("Windows")) {
            this.fileList = this.fileListObjects[0];
            MouseCommand mc = new MouseCommand();
            this.fileList.addMouseListener(mc);
        }
    }

    public Component[] getFileListObjects(JFileChooser fileChooser) {
        Vector<Component> v = new Vector<Component>();
        Stack<Component> s = new Stack<Component>();
        s.push(fileChooser);
        while (!s.isEmpty()) {
            Component c = (Component)s.pop();
            if (!(c instanceof Container)) continue;
            Container d = (Container)c;
            for (int i = 0; i < d.getComponentCount(); ++i) {
                if (d.getComponent(i) instanceof JTable) {
                    v.add(d.getComponent(i));
                    continue;
                }
                s.push(d.getComponent(i));
            }
        }
        Component[] arr = new Component[v.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (Component)v.get(i);
        }
        return arr;
    }

    public void keyPressed(KeyEvent evt) {
        File[] arr;
        Object src = evt.getSource();
        int keyCode = evt.getKeyCode();
        if (src == this.fileList && keyCode == 10 && (arr = this.getSelectedFiles()).length == 1 && arr[0].isFile()) {
            this.approveSelection();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.refreshBtn) {
            this.setVisible(false);
        }
        this.rescanCurrentDirectory();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        System.err.println(laf);
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(laf + " not supported.");
        }
        System.err.println("laf: " + UIManager.getLookAndFeel());
        FileQueueChooser c = new FileQueueChooser(null, null);
        JFrame f = new JFrame();
        c.setMultiSelectionEnabled(true);
        f.getContentPane().add(c);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        f.pack();
    }

    static class D3DNPrjFileFilter
    extends FileFilter {
        D3DNPrjFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("_prj.dv");
        }

        public String getDescription() {
            return "Deltavision Files - Projected (*_prj.dv)";
        }
    }

    static class D3DOldFileFilter
    extends FileFilter {
        D3DOldFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".r3d_d3d");
        }

        public String getDescription() {
            return "Deltavision Files - Decon'd (.r3d_d3d)";
        }
    }

    static class R3DOldFileFilter
    extends FileFilter {
        R3DOldFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".r3d");
        }

        public String getDescription() {
            return "Deltavision Files - Raw (.r3d)";
        }
    }

    static class D3DNewFileFilter
    extends FileFilter {
        D3DNewFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("r3d_d3d.dv");
        }

        public String getDescription() {
            return "Deltavision Files - Decon'd (*r3d_d3d.dv)";
        }
    }

    static class R3DNewFileFilter
    extends FileFilter {
        R3DNewFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("r3d.dv");
        }

        public String getDescription() {
            return "Deltavision Files - Raw (*R3D.dv)";
        }
    }

    static class DashFileFilter
    extends FileFilter {
        DashFileFilter() {
        }

        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "----------------------------------------------";
        }
    }

    class MouseCommand
    implements MouseListener {
        MouseCommand() {
        }

        public void mousePressed(MouseEvent evt) {
            Object src = evt.getSource();
            if (src == FileQueueChooser.this.fileList) {
                if (evt.getModifiers() != 16) {
                    return;
                }
                File[] arr = FileQueueChooser.this.getSelectedFiles();
                if (evt.getClickCount() > 1 && arr.length == 1 && arr[0].isFile()) {
                    FileQueueChooser.this.approveSelection();
                }
            }
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }
    }
}

